/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.utility;

import java.util.Iterator;

public final class Splitter
implements Iterator {
    private final String text;
    private int found;
    private int start;
    private String separator;
    private String token;

    public Splitter(String text) {
        this.text = text;
        this.iterate();
    }

    public Object next() {
        return this.nextToken();
    }

    public String nextToken() {
        if (this.token != null) {
            String result = this.token;
            this.token = null;
            return result;
        }
        if (this.separator != null) {
            String result = this.separator;
            this.separator = null;
            this.iterate();
            return result;
        }
        return null;
    }

    private void iterate() {
        this.found = this.start;
        while (this.found < this.text.length() && !Character.isWhitespace(this.text.charAt(this.found))) {
            ++this.found;
        }
        if (this.found < this.text.length()) {
            this.token = this.text.substring(this.start, this.found);
            this.start = this.found;
            while (this.found < this.text.length() && Character.isWhitespace(this.text.charAt(this.found))) {
                ++this.found;
            }
            this.separator = this.text.substring(this.start, this.found);
            this.start = this.found;
        } else {
            this.separator = null;
            this.token = this.text.substring(this.start);
        }
        if (this.token.length() == 0) {
            this.token = null;
        }
    }

    public boolean hasNext() {
        return this.token != null || this.separator != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("this iterator doesn't support this method");
    }
}

