/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.trace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Trace {
    private static final Log BUSINESS = LogFactory.getFactory().getInstance("log");
    private static boolean traceOn = false;

    private Trace() {
    }

    public static void setTraceOn(boolean on) {
        traceOn = on;
    }

    public static void log(String message) {
        BUSINESS.error((Object)message);
    }

    public static void log(String message, String additional) {
        if (BUSINESS.isErrorEnabled()) {
            BUSINESS.error((Object)message);
            BUSINESS.error((Object)("    " + additional));
        }
    }

    public static void log(String message, String additional, String description) {
        if (BUSINESS.isErrorEnabled()) {
            BUSINESS.error((Object)message);
            BUSINESS.error((Object)("    " + additional));
            BUSINESS.error((Object)("    " + description));
        }
    }

    public static boolean isDebugEnabled(Class tracingClass) {
        if (traceOn) {
            Log log = LogFactory.getFactory().getInstance(tracingClass);
            return log.isDebugEnabled();
        }
        return false;
    }

    public static void trace(Class tracingClass, Object tracingObject, String method, Object object) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + object));
        }
    }

    public static void trace(Class tracingClass, String method, Object object) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + object));
        }
    }

    public static void trace(Class tracingClass, Object tracingObject, String method, Throwable throwable) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + throwable), throwable);
        }
    }

    public static void trace(Class tracingClass, String method, Throwable throwable) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + throwable), throwable);
        }
    }

    public static void fatal(Class tracingClass, Object tracingObject, String method, String description, Throwable throwable) {
        Log log = LogFactory.getFactory().getInstance(tracingClass);
        log.fatal((Object)("." + method + " " + description), throwable);
    }

    public static void fatal(Class tracingClass, String method, String description, Throwable throwable) {
        Log log = LogFactory.getFactory().getInstance(tracingClass);
        log.fatal((Object)("." + method + " " + description), throwable);
    }

    public static void trace(Class tracingClass, Object tracingObject, String method, String description, Throwable throwable) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + description), throwable);
        }
    }

    public static void trace(Class tracingClass, String method, String description, Throwable throwable) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + description), throwable);
        }
    }

    public static void begin(Class tracingClass, Object tracingObject, String method) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + "begin"));
        }
    }

    public static void begin(Class tracingClass, String method) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + "begin"));
        }
    }

    public static void end(Class tracingClass, Object tracingObject, String method) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + "end"));
        }
    }

    public static void end(Class tracingClass, String method) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + "end"));
        }
    }

    public static void info(Class tracingClass, Object tracingObject, String method, String message) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + message));
        }
    }

    public static void info(Class tracingClass, String method, String message) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + message));
        }
    }

    public static void param(Class tracingClass, Object tracingObject, String method, String param, Object value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void param(Class tracingClass, String method, String param, Object value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void param(Class tracingClass, Object tracingObject, String method, String param, int value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void param(Class tracingClass, String method, String param, int value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void param(Class tracingClass, Object tracingObject, String method, String param, boolean value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void param(Class tracingClass, String method, String param, boolean value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isDebugEnabled()) {
            log.debug((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void traceStack(Class tracingClass, Object tracingObject, String method) {
        if (traceOn) {
            Log log = LogFactory.getFactory().getInstance(tracingClass);
            if (!log.isDebugEnabled()) {
                return;
            }
            try {
                throw new Exception("Stacktrace");
            }
            catch (Exception e) {
                log.debug((Object)("." + method + " " + e), (Throwable)e);
            }
        }
    }

    public static final void traceStack(Class tracingClass, String method) {
        if (traceOn) {
            Log log = LogFactory.getFactory().getInstance(tracingClass);
            if (!log.isDebugEnabled()) {
                return;
            }
            try {
                throw new Exception("Stacktrace");
            }
            catch (Exception e) {
                log.debug((Object)("." + method + " " + e), (Throwable)e);
            }
        }
    }

    public static void paramInfo(Class tracingClass, Object tracingObject, String method, String param, Object value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, String method, String param, Object value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, Object tracingObject, String method, String param, int value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, String method, String param, int value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, Object tracingObject, String method, String param, boolean value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + param + "=" + value));
        }
    }

    public static void paramInfo(Class tracingClass, String method, String param, boolean value) {
        Log log;
        if (traceOn && (log = LogFactory.getFactory().getInstance(tracingClass)).isInfoEnabled()) {
            log.info((Object)("." + method + " " + param + "=" + value));
        }
    }
}

