/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import org.qedeq.base.io.TextInput;

public final class Version
implements Comparable {
    private final int major;
    private final int minor;
    private final int patch;

    public Version(String version) {
        TextInput text = new TextInput(version);
        this.major = text.readNonNegativeInt();
        if (!".".equals(text.readString(1))) {
            throw new IllegalArgumentException("version number must have two digits");
        }
        this.minor = text.readNonNegativeInt();
        if (!".".equals(text.readString(1))) {
            throw new IllegalArgumentException("version number must have two digits");
        }
        this.patch = text.readNonNegativeInt();
        text.skipWhiteSpace();
        if (!text.isEmpty()) {
            throw new IllegalArgumentException("version number to long: " + text.readString(100));
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Version)) {
            return -1;
        }
        Version other = (Version)o;
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.major ^ this.minor ^ this.patch;
    }

    public boolean equals(Object o) {
        return 0 == this.compareTo(o);
    }

    public boolean equals(String version) {
        Version compare = null;
        try {
            compare = new Version(version);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.equals(compare);
    }

    public String toString() {
        return this.major + "." + (this.minor < 10 ? "0" : "") + this.minor + "." + (this.patch < 10 ? "0" : "") + this.patch;
    }

    public boolean isLess(Version other) {
        return 0 > this.compareTo(other);
    }

    public boolean isBigger(Version other) {
        return 0 < this.compareTo(other);
    }

    public static boolean less(String version1, String version2) {
        return new Version(version1).isLess(new Version(version2));
    }

    public static boolean bigger(String version1, String version2) {
        return new Version(version1).isBigger(new Version(version2));
    }

    public static boolean equals(String version1, String version2) {
        return new Version(version1).equals(new Version(version2));
    }
}

