/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.LoadingListener;
import org.qedeq.base.io.Path;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.YodaUtility;

public final class UrlUtility {
    private static final Class CLASS = UrlUtility.class;
    static /* synthetic */ Class class$java$net$URLConnection;

    private UrlUtility() {
    }

    public static URL toUrl(File file) {
        try {
            return file.getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static File transformURLPathToFilePath(URL url) {
        try {
            return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String createRelativePath(File origin, File next) {
        if (origin.equals(next)) {
            return "";
        }
        Path org = new Path(origin.getPath().replace(File.separatorChar, '/'), "");
        Path ne = new Path(next.getPath().replace(File.separatorChar, '/'), "");
        return org.createRelative(ne.toString()).toString();
    }

    public static String easyUrl(String url) {
        String result = url;
        try {
            URL u = new URL(url);
            if (u.getProtocol().equalsIgnoreCase("file")) {
                return UrlUtility.transformURLPathToFilePath(u).getCanonicalPath();
            }
        }
        catch (RuntimeException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveUrlToFile(String url, File f, String proxyHost, String proxyPort, String nonProxyHosts, int connectTimeout, int readTimeout, LoadingListener listener) throws IOException {
        String method = "saveUrlToFile()";
        Trace.begin(CLASS, "saveUrlToFile()");
        if (!UrlUtility.isSetConnectionTimeOutSupported() && !IoUtility.isWebStarted()) {
            UrlUtility.saveQedeqFromWebToBufferApache(url, f, proxyHost, proxyPort, nonProxyHosts, connectTimeout, readTimeout, listener);
            Trace.end(CLASS, "saveUrlToFile()");
            return;
        }
        if (!IoUtility.isWebStarted()) {
            if (proxyHost != null) {
                System.setProperty("http.proxyHost", proxyHost);
            }
            if (proxyPort != null) {
                System.setProperty("http.proxyPort", proxyPort);
            }
            if (nonProxyHosts != null) {
                System.setProperty("http.nonProxyHosts", nonProxyHosts);
            }
        }
        FileOutputStream out = null;
        InputStream in = null;
        try {
            int bytesRead;
            URLConnection connection;
            block23: {
                connection = new URL(url).openConnection();
                if (connection instanceof HttpURLConnection) {
                    int responseCode;
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    if (UrlUtility.isSetConnectionTimeOutSupported()) {
                        try {
                            YodaUtility.executeMethod(httpConnection, "setConnectTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(connectTimeout)});
                        }
                        catch (NoSuchMethodException e) {
                            Trace.fatal(CLASS, "saveUrlToFile()", "URLConnection.setConnectTimeout was previously found", e);
                        }
                        catch (InvocationTargetException e) {
                            Trace.fatal(CLASS, "saveUrlToFile()", "URLConnection.setConnectTimeout throwed an error", e);
                        }
                    }
                    if (UrlUtility.isSetReadTimeoutSupported()) {
                        try {
                            YodaUtility.executeMethod(httpConnection, "setReadTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(readTimeout)});
                        }
                        catch (NoSuchMethodException e) {
                            Trace.fatal(CLASS, "saveUrlToFile()", "URLConnection.setReadTimeout was previously found", e);
                        }
                        catch (InvocationTargetException e) {
                            Trace.fatal(CLASS, "saveUrlToFile()", "URLConnection.setReadTimeout throwed an error", e);
                        }
                    }
                    if ((responseCode = httpConnection.getResponseCode()) == 200) {
                        in = httpConnection.getInputStream();
                        break block23;
                    } else {
                        String string;
                        in = httpConnection.getErrorStream();
                        String errorText = IoUtility.loadStreamWithoutException(in, 1000);
                        StringBuffer stringBuffer = new StringBuffer().append("Response code from HTTP server was ").append(responseCode);
                        if (errorText.length() > 0) {
                            string = "\nResponse  text from HTTP server was:\n" + errorText;
                            throw new IOException(stringBuffer.append(string).toString());
                        }
                        string = "";
                        throw new IOException(stringBuffer.append(string).toString());
                    }
                }
                Trace.paramInfo(CLASS, "saveUrlToFile()", "connection.getClass", connection.getClass().toString());
                in = connection.getInputStream();
            }
            if (!url.equals(connection.getURL().toString())) {
                throw new FileNotFoundException("\"" + url + "\" was substituted by " + "\"" + connection.getURL() + "\" from server");
            }
            double maximum = connection.getContentLength();
            IoUtility.createNecessaryDirectories(f);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[4096];
            int position = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                position += bytesRead;
                out.write(buffer, 0, bytesRead);
                if (!(maximum > 0.0)) continue;
                double completeness = (double)position / maximum;
                if (completeness < 0.0) {
                    completeness = 0.0;
                }
                if (completeness > 100.0) {
                    completeness = 1.0;
                }
                listener.loadingCompletenessChanged(completeness);
            }
            listener.loadingCompletenessChanged(1.0);
        }
        catch (Throwable throwable) {
            IoUtility.close(out);
            out = null;
            IoUtility.close(in);
            in = null;
            Trace.end(CLASS, "saveUrlToFile()");
            throw throwable;
        }
        IoUtility.close(out);
        out = null;
        IoUtility.close(in);
        in = null;
        Trace.end(CLASS, "saveUrlToFile()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveQedeqFromWebToBufferApache(String url, File f, String proxyHost, String proxyPort, String nonProxyHosts, int connectTimeout, int readTimeout, LoadingListener listener) throws IOException {
        String method = "saveQedeqFromWebToBufferApache()";
        Trace.begin(CLASS, "saveQedeqFromWebToBufferApache()");
        HttpClient client = new HttpClient();
        if (!IoUtility.isWebStarted() && proxyHost != null && proxyHost.length() > 0) {
            String pHost = proxyHost;
            int pPort = 80;
            if (proxyPort != null) {
                try {
                    pPort = Integer.parseInt(proxyPort);
                }
                catch (RuntimeException e) {
                    Trace.fatal(CLASS, "saveQedeqFromWebToBufferApache()", "proxy port not numeric: " + proxyPort, e);
                }
            }
            if (pHost.length() > 0) {
                client.getHostConfiguration().setProxy(pHost, pPort);
            }
        }
        GetMethod httpMethod = new GetMethod(url);
        try {
            httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            httpMethod.getParams().setSoTimeout(connectTimeout);
            int statusCode = client.executeMethod((HttpMethod)httpMethod);
            if (statusCode != 200) {
                throw new FileNotFoundException("Problems loading: " + url + "\n" + httpMethod.getStatusLine());
            }
            byte[] responseBody = httpMethod.getResponseBody();
            IoUtility.createNecessaryDirectories(f);
            IoUtility.saveFileBinary(f, responseBody);
            listener.loadingCompletenessChanged(1.0);
        }
        finally {
            httpMethod.releaseConnection();
            Trace.end(CLASS, "saveQedeqFromWebToBufferApache()");
        }
    }

    public static boolean isSetConnectionTimeOutSupported() {
        return LazyHolderTimeoutMethods.IS_SET_CONNECTION_TIMEOUT_SUPPORTED;
    }

    public static boolean isSetReadTimeoutSupported() {
        return LazyHolderTimeoutMethods.IS_SET_READ_TIMEOUT_SUSPPORTED;
    }

    private static final class LazyHolderTimeoutMethods {
        private static final boolean IS_SET_CONNECTION_TIMEOUT_SUPPORTED = YodaUtility.existsMethod(class$java$net$URLConnection == null ? (class$java$net$URLConnection = UrlUtility.class$("java.net.URLConnection")) : class$java$net$URLConnection, "setConnectTimeout", new Class[]{Integer.TYPE});
        private static final boolean IS_SET_READ_TIMEOUT_SUSPPORTED = YodaUtility.existsMethod(class$java$net$URLConnection == null ? (class$java$net$URLConnection = UrlUtility.class$("java.net.URLConnection")) : class$java$net$URLConnection, "setReadTimeout", new Class[]{Integer.TYPE});

        private LazyHolderTimeoutMethods() {
        }
    }
}

