/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.base.utility.StringUtility;

public final class Path {
    private final String[] path;
    private final String name;

    public Path(String filePath) {
        String[] p = StringUtility.split(filePath, "/");
        this.name = p[p.length - 1];
        String[] p2 = new String[p.length - 1];
        System.arraycopy(p, 0, p2, 0, p2.length);
        this.path = this.removeRelativeDirs(p2);
    }

    public Path(String dirPath, String fileName) {
        this(dirPath.endsWith("/") ? StringUtility.split(dirPath.substring(0, dirPath.length() - 1), "/") : StringUtility.split(dirPath, "/"), fileName);
    }

    public Path(String[] dirNames, String fileName) {
        this.path = this.removeRelativeDirs(dirNames);
        this.name = fileName != null ? fileName : "";
    }

    public Path createRelative(String filePath) {
        int i;
        int max;
        Path to = new Path(filePath);
        if (this.isRelative()) {
            return to;
        }
        if (to.isRelative()) {
            return to;
        }
        for (max = 0; max < this.path.length && max < to.path.length && !"..".equals(this.path[max]) && EqualsUtility.equals(this.path[max], to.path[max]); ++max) {
        }
        String[] r = new String[this.path.length - max + to.path.length - max];
        for (i = max; i < this.path.length; ++i) {
            r[i - max] = "..";
        }
        for (i = max; i < to.path.length; ++i) {
            r[i - max + this.path.length - max] = to.path[i];
        }
        return new Path(r, to.name);
    }

    public boolean isDirectory() {
        return this.name.length() == 0;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isAbsolute() {
        return this.path.length > 0 && (this.path[0].length() == 0 || this.path[0].endsWith(":"));
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public String getFileName() {
        return this.name;
    }

    public String getDirectory() {
        StringBuffer result = new StringBuffer(256);
        for (int i = 0; i < this.path.length; ++i) {
            result.append(this.path[i]).append("/");
        }
        return result.toString();
    }

    private String[] removeRelativeDirs(String[] dirNames) {
        int i;
        ArrayList<String> d = new ArrayList<String>();
        for (i = 0; i < dirNames.length; ++i) {
            d.add(dirNames[i]);
        }
        i = 0;
        while (i < d.size()) {
            if (i > 0 && "..".equals(d.get(i)) && !"".equals(d.get(i - 1)) && !"..".equals(d.get(i - 1))) {
                d.remove(i - 1);
                d.remove(i - 1);
                --i;
                continue;
            }
            if (".".equals(d.get(i))) {
                d.remove(i);
                continue;
            }
            ++i;
        }
        return d.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        for (int i = 0; i < this.path.length; ++i) {
            result.append(this.path[i]).append("/");
        }
        result.append(this.name);
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        return EqualsUtility.equals(this.path, other.path) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

