/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Parameters {
    private final Map map;

    public Parameters(Map map) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        this.map = map;
    }

    public Parameters() {
        this.map = new HashMap();
    }

    public String getString(String key) {
        Object oval = this.map.get(key);
        return oval instanceof String ? (String)oval : "";
    }

    public String getString(String key, String def) {
        Object oval = this.map.get(key);
        return oval instanceof String ? (String)oval : def;
    }

    public int getInt(String key) {
        Object oval = this.map.get(key);
        if (oval instanceof String) {
            try {
                return Integer.parseInt(oval.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getInt(String key, int def) {
        Object oval = this.map.get(key);
        if (oval instanceof String) {
            try {
                return Integer.parseInt(oval.toString().trim());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return def;
    }

    public boolean getBoolean(String key) {
        Object oval = this.map.get(key);
        if (oval instanceof String) {
            return "true".equalsIgnoreCase(oval.toString());
        }
        return false;
    }

    public boolean getBoolean(String key, boolean def) {
        Object oval = this.map.get(key);
        if (oval instanceof String) {
            if ("true".equalsIgnoreCase((String)oval)) {
                return true;
            }
            if ("false".equalsIgnoreCase((String)oval)) {
                return false;
            }
        }
        return def;
    }

    public String getParameterString() {
        StringBuffer buffer = new StringBuffer(30);
        Iterator e = this.map.entrySet().iterator();
        boolean notFirst = false;
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            String key = String.valueOf(entry.getKey());
            if (notFirst) {
                buffer.append(", ");
            } else {
                notFirst = true;
            }
            buffer.append(key);
            buffer.append("=");
            buffer.append(String.valueOf(entry.getValue()));
        }
        return buffer.toString();
    }

    public void setDefault(String key, int value) {
        if (!this.map.containsKey(key) || !(this.map.get(key) instanceof String)) {
            this.map.put(key, "" + value);
        }
    }

    public void setDefault(String key, String value) {
        if (!this.map.containsKey(key) || !(this.map.get(key) instanceof String)) {
            this.map.put(key, value);
        }
    }

    public void setDefault(String key, boolean value) {
        if (!this.map.containsKey(key) || !(this.map.get(key) instanceof String)) {
            this.map.put(key, "" + value);
        }
    }

    public Set keySet() {
        return this.map.keySet();
    }
}

