/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.text.se.main;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.UrlUtility;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.common.KernelProperties;
import org.qedeq.kernel.bo.common.ServiceModule;
import org.qedeq.kernel.bo.log.LogListener;
import org.qedeq.kernel.bo.log.LogListenerImpl;
import org.qedeq.kernel.bo.log.ModuleEventListener;
import org.qedeq.kernel.bo.log.ModuleEventListenerLog;
import org.qedeq.kernel.bo.log.ModuleEventLog;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.log.TraceListener;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.bo.service.DefaultInternalKernelServices;
import org.qedeq.kernel.bo.service.logic.SimpleProofFinderPlugin;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.config.QedeqConfig;
import org.qedeq.kernel.xml.dao.XmlQedeqFileDao;

public final class Main {
    private Main() {
    }

    private static void checkDirectoryExistenceAndOptionallyCreate(QedeqGuiConfig config) throws IOException {
        File file = config.getLogFile();
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("can't create directory: " + dir.getAbsolutePath());
        }
    }

    private static void initLog4J(QedeqGuiConfig config) {
        String resourceName = "log4j.xml";
        String resourceDirectoryName = "config";
        File resourceDir = new File(config.getBasisDirectory(), resourceDirectoryName);
        File resource = new File(resourceDir, "log4j.xml");
        String res = "/" + resourceDirectoryName + "/" + "log4j.xml";
        if (!resource.exists()) {
            URL url = Main.class.getResource(res);
            if (url == null) {
                Main.errorPrintln("Resource not found: " + res);
            } else {
                try {
                    if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                        Main.errorPrintln("Creation of directory failed: " + resourceDir.getAbsolutePath());
                    }
                    StringBuffer buffer = new StringBuffer();
                    IoUtility.loadFile((URL)url, (StringBuffer)buffer, (String)"UTF-8");
                    IoUtility.saveFile((File)resource, (StringBuffer)buffer, (String)"UTF-8");
                }
                catch (IOException e1) {
                    Main.errorPrintln("Resource can not be saved: " + resource.getAbsolutePath());
                    e1.printStackTrace();
                }
            }
        } else {
            res = UrlUtility.toUrl((File)resource).toString();
        }
        System.setProperty("log4j.configDebug", "true");
        System.setProperty("log4j.configuration", res);
        try {
            if (res.endsWith(".xml")) {
                DOMConfigurator.configureAndWatch((String)resource.getCanonicalPath(), (long)5000L);
            } else {
                PropertyConfigurator.configureAndWatch((String)resource.getCanonicalPath(), (long)5000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void errorPrintln(String message) {
        System.err.println("ERROR>>> " + message);
    }

    public static void main(String[] args) {
        String qedeq = null;
        if (args.length == 0) {
            Main.printProgramInformation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String option = args[i].substring(1).toLowerCase();
                if (option.length() <= 0 && i + 1 < args.length) {
                    option = args[i + 1];
                }
                if (option.equals("help") || option.equals("h") || option.equals("?")) {
                    Main.printProgramInformation();
                    return;
                }
                Main.printArgumentError("Unknown option: " + option);
                return;
            }
            if (qedeq != null) {
                Main.printArgumentError("only one QEDEQ module can be searched at once.");
                return;
            }
            qedeq = args[i];
        }
        if (qedeq == null) {
            Main.printArgumentError("QEDEQ module must be specified.");
            return;
        }
        Main.findProofs(qedeq);
    }

    public static void printProgramInformation() {
        System.err.println("Name");
        System.err.println("----");
        System.err.println(Main.class.getName() + " - find simple propositional calculus proofs");
        System.err.println();
        System.err.println("Synopsis");
        System.err.println("--------");
        System.err.println("[-h] <module url>");
        System.err.println();
        System.err.println("Description");
        System.err.println("-----------");
        System.err.println("This program finds formal proofs for propositional calculus propositions.");
        System.err.println("You give it an QEDEQ module URL and the missing formal proofs will be added.");
        System.err.println("When a proof was found the buffered file (or original if the protocol is");
        System.err.println("\"file\") will be altered.");
        System.err.println();
        System.err.println("Options and Parameter");
        System.err.println("---------------------");
        System.err.println("-h           writes this text and returns");
        System.err.println("<module url> URL for QEDEQ module to work on");
        System.err.println();
        System.err.println("Example");
        System.err.println("-------");
        System.err.println("http://www.qedeq.org/" + KernelContext.getInstance().getKernelVersionDirectory() + "/sample/qedeq_sample4.xml");
        System.err.println();
    }

    private static void printArgumentError(String message) {
        System.err.println(">>>ERROR reason:");
        System.err.println(message);
        System.err.println();
        System.err.println(">>>Calling convention:");
        Main.printProgramInformation();
    }

    public static void findProofs(String qedeq) {
        try {
            QedeqGuiConfig.init(new File(IoUtility.getStartDirectory((String)"qedeq"), "config/org.qedeq.properties"), IoUtility.getStartDirectory((String)"qedeq"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Configuration file not found!");
            System.exit(-1);
            return;
        }
        try {
            Main.initLog4J(QedeqGuiConfig.getInstance());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Initialization of Log4J failed!");
            System.exit(-2);
            return;
        }
        try {
            try {
                Main.checkDirectoryExistenceAndOptionallyCreate(QedeqGuiConfig.getInstance());
                QedeqLog.getInstance().addLog((LogListener)new LogListenerImpl());
                QedeqLog.getInstance().addLog((LogListener)new TraceListener());
                ModuleEventLog.getInstance().addLog((ModuleEventListener)new ModuleEventListenerLog());
                KernelContext.getInstance().init((QedeqConfig)QedeqGuiConfig.getInstance(), (ServiceModule)new DefaultInternalKernelServices((QedeqConfig)QedeqGuiConfig.getInstance(), (KernelProperties)KernelContext.getInstance(), (QedeqFileDao)new XmlQedeqFileDao()));
                KernelContext.getInstance().startup();
                ModuleAddress address = KernelContext.getInstance().getModuleAddress(qedeq);
                KernelContext.getInstance().loadModule(address);
                KernelContext.getInstance().executePlugin(SimpleProofFinderPlugin.class.getName(), address, null);
                KernelContext.getInstance().shutdown();
            }
            catch (IOException e) {
                System.err.println("Application start failed!");
                System.exit(-3);
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Unexpected major failure!");
            System.exit(-4);
            return;
        }
    }
}

