/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.ResourceLoaderUtility;
import org.qedeq.base.io.StringOutput;
import org.qedeq.base.io.SubTextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.gui.se.main.GuiOptions;

public final class GuiHelper {
    private static final Class CLASS = GuiHelper.class;
    private static Color lineHighlighterBackgroundColor = new Color(232, 242, 254);
    private static Color markedAndHiglightedBackgroundColor = new Color(232, 242, 254, 128);
    private static Color errorTextBackgroundColor = new Color(180, 206, 255);
    private static Color warningTextBackgroundColor = new Color(255, 255, 190);
    private static final int DEFAULT_EMPTY_BORDER_PIXEL_X = 10;
    private static final int DEFAULT_EMPTY_BORDER_PIXEL_Y = 10;
    private static final int SEARCH_TEXT_BOX_WIDTH = 500;
    private static final String UNKNOWN_STRING = "47 49 46 38 37 61 10 00 10 00 C6 43 00 00 00 00 07 02 02 0C 04 04 0E 04 04 10 05 05 14 06 06 15 06 06 18 07 07 1E 09 09 21 0A 0A 26 0B 0B 2D 0D 0D 31 0E 0E 32 0F 0F 3D 12 12 3F 13 13 40 13 13 44 14 14 46 15 15 49 15 15 4A 16 16 50 18 18 51 18 18 52 18 18 68 1F 1F 6C 20 20 7A 24 24 7C 24 24 8C 29 29 96 2C 2C 99 2D 2D 9B 2E 2E 9D 2E 2E A0 2F 2F A3 30 30 A4 31 31 A7 31 31 B3 35 35 B6 36 36 B8 36 36 BC 38 38 C4 3A 3A C9 3B 3B CC 3C 3C CD 3D 3D CE 3D 3D D0 3D 3D D1 3E 3E D5 3F 3F D9 40 40 DB 41 41 E0 42 42 E3 43 43 E4 43 43 E9 45 45 ED 46 46 EE 46 46 F1 47 47 F3 48 48 F4 48 48 F7 49 49 F8 49 49 FA 4A 4A FB 4A 4A FC 4A 4A FD 4B 4B FE 4B 4B FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 2C 00 00 00 00 10 00 10 00 00 07 87 80 42 82 83 84 85 86 87 88 89 85 3E 2E 23 22 30 83 36 26 1F 28 3A 83 1C 0C 0E 0B 05 20 42 33 0F 0D 10 07 11 83 27 2B 82 15 06 3B 3B 24 38 42 29 01 87 17 09 37 84 2D 03 86 19 04 26 84 2A 0A 14 85 1B 02 25 82 40 42 2F 08 16 85 33 03 18 83 3E 42 1A 00 32 85 35 12 1E 42 3F D9 42 1D 13 35 85 3C 2C 34 85 34 2D 3D 85 31 00 19 42 D0 D0 19 00 31 85 39 21 2A 42 41 F6 42 2A 21 39 84 F7 C5 83 C6 04 F9 53 54 28 10 00 3B ";
    public static final ImageIcon UNKNOWN = new ImageIcon(StringUtility.hex2byte((String)"47 49 46 38 37 61 10 00 10 00 C6 43 00 00 00 00 07 02 02 0C 04 04 0E 04 04 10 05 05 14 06 06 15 06 06 18 07 07 1E 09 09 21 0A 0A 26 0B 0B 2D 0D 0D 31 0E 0E 32 0F 0F 3D 12 12 3F 13 13 40 13 13 44 14 14 46 15 15 49 15 15 4A 16 16 50 18 18 51 18 18 52 18 18 68 1F 1F 6C 20 20 7A 24 24 7C 24 24 8C 29 29 96 2C 2C 99 2D 2D 9B 2E 2E 9D 2E 2E A0 2F 2F A3 30 30 A4 31 31 A7 31 31 B3 35 35 B6 36 36 B8 36 36 BC 38 38 C4 3A 3A C9 3B 3B CC 3C 3C CD 3D 3D CE 3D 3D D0 3D 3D D1 3E 3E D5 3F 3F D9 40 40 DB 41 41 E0 42 42 E3 43 43 E4 43 43 E9 45 45 ED 46 46 EE 46 46 F1 47 47 F3 48 48 F4 48 48 F7 49 49 F8 49 49 FA 4A 4A FB 4A 4A FC 4A 4A FD 4B 4B FE 4B 4B FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF 2C 00 00 00 00 10 00 10 00 00 07 87 80 42 82 83 84 85 86 87 88 89 85 3E 2E 23 22 30 83 36 26 1F 28 3A 83 1C 0C 0E 0B 05 20 42 33 0F 0D 10 07 11 83 27 2B 82 15 06 3B 3B 24 38 42 29 01 87 17 09 37 84 2D 03 86 19 04 26 84 2A 0A 14 85 1B 02 25 82 40 42 2F 08 16 85 33 03 18 83 3E 42 1A 00 32 85 35 12 1E 42 3F D9 42 1D 13 35 85 3C 2C 34 85 34 2D 3D 85 31 00 19 42 D0 D0 19 00 31 85 39 21 2A 42 41 F6 42 2A 21 39 84 F7 C5 83 C6 04 F9 53 54 28 10 00 3B "));
    public static final boolean IS_LOW_RESOLUTION = Toolkit.getDefaultToolkit().getScreenSize().width <= 1000;

    private GuiHelper() {
    }

    public static void configureUI(GuiOptions options) {
        UIManager.put("ClassLoader", CLASS.getClassLoader());
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        Options.setUseNarrowButtons((boolean)options.isUseNarrowButtons());
        Options.setTabIconsEnabled((boolean)options.isTabIconsEnabled());
        UIManager.put("jgoodies.popupDropShadowEnabled", options.isPopupDropShadowEnabled());
        UIManager.put("TextArea.disabledBackground", UIManager.get("TextArea.background"));
        UIManager.put("ToolTip.font", new FontUIResource("Lucida Sans Unicode", 0, UIManager.getFont("ToolTip.font").getSize()));
        LookAndFeel selectedLaf = options.getSelectedLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)options.getSelectedTheme());
            PlasticLookAndFeel.setTabStyle((String)options.getPlasticTabStyle());
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled((boolean)options.isPlasticHighContrastFocusEnabled());
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        try {
            UIManager.setLookAndFeel(selectedLaf);
        }
        catch (Exception e) {
            Trace.trace((Class)CLASS, (String)"configureUI", (String)"Can't change L&F", (Throwable)e);
        }
    }

    public static AbstractButton createToolBarButton(String iconName, String toolTipText) {
        JButton button = new JButton(GuiHelper.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public static AbstractButton createToolBarButton(String iconName, String toolTipText, ActionListener action, KeyStroke keyStroke) {
        AbstractButton button = GuiHelper.createToolBarButton(iconName, toolTipText);
        button.registerKeyboardAction(action, keyStroke, 2);
        return button;
    }

    public static AbstractButton createToolBarRadioButton(String iconName, String toolTipText) {
        JToggleButton button = new JToggleButton(GuiHelper.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public static ImageIcon readImageIcon(String filename) {
        URL url = ResourceLoaderUtility.getResourceUrl((String)("images/" + filename));
        if (url == null) {
            Trace.fatal((Class)CLASS, (String)"readImageIcon", (String)("image icon not found: images/" + filename), (Throwable)new RuntimeException());
            return UNKNOWN;
        }
        return new ImageIcon(url);
    }

    public static Color getLineHighlighterBackgroundColor() {
        return lineHighlighterBackgroundColor;
    }

    public static Color getErrorTextBackgroundColor() {
        return errorTextBackgroundColor;
    }

    public static Color getWarningTextBackgroundColor() {
        return warningTextBackgroundColor;
    }

    public static Color getCurrentAndMarkedBackgroundColor() {
        return markedAndHiglightedBackgroundColor;
    }

    public static void paintCurrentLineBackground(Graphics g, JTextComponent c, Color col) {
        Rectangle r;
        if (c.getSelectionStart() != c.getSelectionEnd()) {
            return;
        }
        try {
            r = c.modelToView(c.getCaretPosition());
        }
        catch (BadLocationException couldNotHappen) {
            throw new RuntimeException(couldNotHappen);
        }
        g.setColor(col);
        g.fillRect(0, r.y, c.getWidth(), r.height);
    }

    public static JComponent addSpaceAndAlignRight(JPanel panel) {
        JPanel withSpace = new JPanel();
        withSpace.add(panel);
        JPanel alignRight = new JPanel();
        alignRight.setLayout(new FlowLayout(2));
        alignRight.add(withSpace);
        return alignRight;
    }

    public static JComponent alignLeft(JPanel panel) {
        JPanel withSpace = new JPanel();
        withSpace.add(panel);
        JPanel alignLeft = new JPanel();
        alignLeft.setLayout(new FlowLayout(0));
        alignLeft.add(withSpace);
        return alignLeft;
    }

    public static int getEmptyBoderPixelsX() {
        return 10;
    }

    public static int getEmptyBorderPixelsY() {
        return 10;
    }

    public static Border getEmptyBorder() {
        return BorderFactory.createEmptyBorder(GuiHelper.getEmptyBorderPixelsY(), GuiHelper.getEmptyBoderPixelsX(), GuiHelper.getEmptyBorderPixelsY(), GuiHelper.getEmptyBoderPixelsX());
    }

    public static Border getEmptyBorderStackable() {
        return BorderFactory.createEmptyBorder(GuiHelper.getEmptyBorderPixelsY() / 2, GuiHelper.getEmptyBoderPixelsX(), GuiHelper.getEmptyBorderPixelsY() / 2, GuiHelper.getEmptyBoderPixelsX());
    }

    public static void calcColumnWidths(JTable table) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            if (h != null) {
                Component c = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = c.getPreferredSize().width;
            }
            for (int row = rowCount - 1; row >= 0; --row) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
        }
    }

    public static int getSearchTextBoxWidth() {
        return 500;
    }

    public static JComponent addSpaceAndTitle(JPanel panel, String title) {
        JPanel withSpace = new JPanel();
        withSpace.setBorder(GuiHelper.getEmptyBorderStackable());
        withSpace.add(panel);
        withSpace.setLayout(new GridLayout(0, 1));
        JPanel withTitle = new JPanel();
        withTitle.setBorder(BorderFactory.createTitledBorder(title));
        withTitle.add(withSpace);
        withTitle.setLayout(new GridLayout(0, 1));
        return withTitle;
    }

    public static String getToolTipText(String text) {
        StringOutput output = new StringOutput();
        SubTextInput input = new SubTextInput(text);
        int sw = Toolkit.getDefaultToolkit().getScreenSize().width;
        if (sw >= 1200) {
            output.setColumns(160);
        } else if (sw >= 1000) {
            output.setColumns(120);
        } else {
            output.setColumns(100);
        }
        while (!input.isEmpty()) {
            String token = input.readStringTilWhitespace();
            output.addToken(token);
            StringBuffer ws = new StringBuffer();
            while (Character.isWhitespace(input.getChar())) {
                ws = ws.append((char)input.read());
            }
            output.addWs(ws.toString());
        }
        IoUtility.close((InputStream)input);
        return "<html>" + StringUtility.replace((String)StringUtility.replace((String)StringUtility.escapeXml((String)output.toString()), (String)"&apos;", (String)"'"), (String)"\n", (String)"<br>") + "</html>";
    }
}

