/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.tree;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.gui.se.util.MenuHelper;

public final class QedeqTreeContextMenu
extends JPopupMenu {
    public QedeqTreeContextMenu(QedeqController controller) {
        String resolution = QedeqGuiConfig.getInstance().getIconSize();
        JMenuItem item = MenuHelper.createMenuItem("Remove", 'R');
        item.addActionListener(controller.getRemoveModuleAction());
        item.setToolTipText("Unload selected QEDEQ modules. Changes status of dependent modules. Local module buffer is not affected.");
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/actions/edit-cut.png"));
        this.add(item);
        this.addSeparator();
        item = MenuHelper.createMenuItem("Check Well-Formedness", 'W');
        item.setToolTipText("Check if all formulas are well formed within selected QEDEQ modules. This includes dependency checking.");
        item.addActionListener(controller.getCheckWellFormedAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/status/software-update-available.png"));
        this.add(item);
        item = MenuHelper.createMenuItem("Check Fully-Formally Proved", 'F');
        item.setToolTipText("Check if all propositions have formal correct proofss within selected QEDEQ modules. This includes dependency checking.");
        item.addActionListener(controller.getCheckFormallyProvedAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/actions/run.png"));
        this.add(item);
        this.addSeparator();
        JMenuItem[] pluginMenu = controller.getPluginMenuEntries();
        for (int i = 0; i < pluginMenu.length; ++i) {
            this.add(pluginMenu[i]);
        }
        this.addSeparator();
        item = MenuHelper.createMenuItem("Remove Plugin Results", 'R');
        item.addActionListener(controller.getRemovePluginResultsAction());
        item.setToolTipText("Remove all warnings and errors that were produced by all plugin executions for the selected module.");
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/actions/edit-clear.png"));
        this.add(item);
        this.addSeparator();
        item = MenuHelper.createMenuItem("Terminate Threads", 'T');
        item.addActionListener(controller.getTerminateAllAction());
        item.setToolTipText("Terminate all currently running plugin processes.");
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/actions/process-stop.png"));
        this.add(item);
        this.addSeparator();
        item = MenuHelper.createMenuItem("Load from Web", 'W');
        item.setToolTipText("Load QEDEQ module from anywhere in the Web");
        item.addActionListener(controller.getAddAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/actions/list-add.png"));
        this.add(item);
        item = MenuHelper.createMenuItem("Load local File", 'F');
        item.setToolTipText("Load QEDEQ module from file system");
        item.addActionListener(controller.getAddFileAction());
        item.setIcon(GuiHelper.readImageIcon("tango/" + resolution + "/actions/document-open.png"));
        this.add(item);
    }
}

