/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.base.io.AbstractOutput;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.io.ResourceLoaderUtility;
import org.qedeq.base.io.StringOutput;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.io.TextOutput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.base.utility.YodaUtility;
import org.qedeq.gui.se.element.CPTextArea;
import org.qedeq.kernel.bo.KernelContext;
import org.qedeq.kernel.bo.module.InternalKernelServices;
import org.qedeq.kernel.bo.module.KernelQedeqBo;
import org.qedeq.kernel.bo.module.ModuleLabels;
import org.qedeq.kernel.bo.parser.MathParser;
import org.qedeq.kernel.bo.parser.ParserException;
import org.qedeq.kernel.bo.parser.Term;
import org.qedeq.kernel.bo.service.DefaultKernelQedeqBo;
import org.qedeq.kernel.bo.service.Element2LatexImpl;
import org.qedeq.kernel.bo.service.Element2Utf8Impl;
import org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeVisitor;
import org.qedeq.kernel.se.base.list.Element;
import org.qedeq.kernel.se.base.module.Conclusion;
import org.qedeq.kernel.se.base.module.FormalProofLine;
import org.qedeq.kernel.se.base.module.FormalProofLineList;
import org.qedeq.kernel.se.base.module.Formula;
import org.qedeq.kernel.se.base.module.Hypothesis;
import org.qedeq.kernel.se.base.module.Node;
import org.qedeq.kernel.se.base.module.NodeType;
import org.qedeq.kernel.se.base.module.Proposition;
import org.qedeq.kernel.se.base.module.Reason;
import org.qedeq.kernel.se.common.DefaultModuleAddress;
import org.qedeq.kernel.se.common.ModuleAddress;
import org.qedeq.kernel.se.common.ModuleContext;
import org.qedeq.kernel.se.common.ModuleDataException;
import org.qedeq.kernel.se.common.SourceFileExceptionList;
import org.qedeq.kernel.se.dto.module.AddVo;
import org.qedeq.kernel.se.dto.module.ConclusionVo;
import org.qedeq.kernel.se.dto.module.ConditionalProofVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineListVo;
import org.qedeq.kernel.se.dto.module.FormalProofLineVo;
import org.qedeq.kernel.se.dto.module.FormalProofVo;
import org.qedeq.kernel.se.dto.module.FormulaVo;
import org.qedeq.kernel.se.dto.module.HypothesisVo;
import org.qedeq.kernel.se.dto.module.ModusPonensVo;
import org.qedeq.kernel.se.dto.module.NodeVo;
import org.qedeq.kernel.se.dto.module.PropositionVo;
import org.qedeq.kernel.se.dto.module.SubstPredVo;
import org.qedeq.kernel.se.visitor.QedeqNumbers;
import org.qedeq.kernel.xml.dao.Qedeq2Xml;
import org.qedeq.kernel.xml.handler.parser.LoadXmlOperatorListUtility;
import org.qedeq.kernel.xml.parser.BasicParser;
import org.xml.sax.SAXException;

public class ProofParserPane
extends JFrame {
    private static final String UNKNOWN_PROPOSITION_ID = "proposition:unknown";
    private static final Class CLASS = ProofParserPane.class;
    private CPTextArea source = new CPTextArea(true);
    private CPTextArea resultQedeqField = new CPTextArea(false);
    private CPTextArea resultTextField = new CPTextArea(false);
    private CPTextArea error = new CPTextArea(false);
    private JScrollPane sourceScroller = new JScrollPane();
    private JSplitPane splitPane1 = new JSplitPane(0);
    private JSplitPane splitPane2 = new JSplitPane(1);
    private JMenuBar menu = new JMenuBar();
    private final List operators;
    private int errorPosition = -1;
    private JSplitPane globalPane;
    private final File resourceFile;
    private final MathParser parser;
    private PropositionVo proposition;

    public ProofParserPane(String name, MathParser parser, String title, String resourceName, String sample) throws SourceFileExceptionList {
        super(title);
        this.parser = parser;
        this.source.setText(sample);
        String resourceDirectoryName = "config";
        try {
            this.resourceFile = ResourceLoaderUtility.getResourceFile((File)KernelContext.getInstance().getConfig().getBasisDirectory(), (String)"config", (String)resourceName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.operators = LoadXmlOperatorListUtility.getOperatorList((InternalKernelServices)((InternalKernelServices)YodaUtility.getFieldValue((Object)KernelContext.getInstance(), (String)"services")), (File)this.resourceFile);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        this.setupView(name);
        this.updateView();
    }

    private final void setupView(String name) {
        Container pane = this.getContentPane();
        this.source.setDragEnabled(true);
        this.source.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.source.setAutoscrolls(true);
        this.source.setCaretPosition(0);
        this.source.setEditable(true);
        this.source.getCaret().setVisible(false);
        this.source.setLineWrap(false);
        this.source.setWrapStyleWord(true);
        this.source.setFocusable(true);
        this.resultTextField.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.resultTextField.setAutoscrolls(true);
        this.resultTextField.setCaretPosition(0);
        this.resultTextField.setEditable(false);
        this.resultTextField.getCaret().setVisible(false);
        this.resultTextField.setFocusable(true);
        this.resultQedeqField.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.resultQedeqField.setAutoscrolls(true);
        this.resultQedeqField.setCaretPosition(0);
        this.resultQedeqField.setEditable(false);
        this.resultQedeqField.getCaret().setVisible(false);
        this.resultQedeqField.setFocusable(true);
        this.error.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.error.setForeground(Color.RED);
        this.error.setAutoscrolls(true);
        this.error.setCaretPosition(0);
        this.error.setEditable(false);
        this.error.getCaret().setVisible(false);
        this.error.setFocusable(true);
        this.error.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ProofParserPane.this.updateView();
            }
        });
        JViewport qedeqPort = this.sourceScroller.getViewport();
        qedeqPort.add(this.source);
        JScrollPane resultTextScroller = new JScrollPane();
        JViewport resultTextPort = resultTextScroller.getViewport();
        resultTextPort.add(this.resultTextField);
        JScrollPane resultQedeqScroller = new JScrollPane();
        JViewport resultQedeqPort = resultQedeqScroller.getViewport();
        resultQedeqPort.add(this.resultQedeqField);
        JScrollPane errorScroller = new JScrollPane();
        JViewport errorPort = errorScroller.getViewport();
        errorPort.add(this.error);
        this.splitPane2.setLeftComponent(this.sourceScroller);
        this.splitPane2.setRightComponent(resultTextScroller);
        this.splitPane2.setResizeWeight(0.5);
        this.splitPane2.setOneTouchExpandable(true);
        this.splitPane1.setTopComponent(this.splitPane2);
        this.splitPane1.setBottomComponent(resultQedeqScroller);
        this.splitPane1.setResizeWeight(0.0);
        this.splitPane1.setOneTouchExpandable(true);
        this.error.setText("");
        this.globalPane = new JSplitPane(0);
        this.globalPane.setTopComponent(this.splitPane1);
        this.globalPane.setBottomComponent(errorScroller);
        this.globalPane.setResizeWeight(1.0);
        this.globalPane.setOneTouchExpandable(true);
        pane.add(this.globalPane);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }

            public void componentShown(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentShown", (Object)e);
            }
        });
        this.menu.removeAll();
        JMenu transformMenu = new JMenu("Transform");
        transformMenu.setMnemonic('T');
        JMenuItem transform = new JMenuItem(name + " to QEDEQ");
        transform.setMnemonic('Q');
        transform.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                try {
                    ProofParserPane.this.setProposition(ProofParserPane.this.source.getText());
                    ProofParserPane.this.resultQedeqField.setText(ProofParserPane.this.getQedeqXml((Proposition)ProofParserPane.this.proposition));
                    ProofParserPane.this.resultTextField.setText(ProofParserPane.this.getUtf8((Proposition)ProofParserPane.this.proposition));
                }
                catch (ModuleDataException e) {
                    ProofParserPane.this.error.setText(ProofParserPane.this.error.getText() + (Object)((Object)e) + "\n");
                    Trace.fatal((Class)CLASS, (Object)this, (String)"setupView$transform", (String)"Problem during parsing", (Throwable)e);
                }
                ProofParserPane.this.updateView();
            }
        });
        transformMenu.add(transform);
        this.menu.add(transformMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic('A');
        about.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                JOptionPane.showMessageDialog(ProofParserPane.this, "This dialog enables to transform textual input into the QEDEQ format.\nThe operators and their QEDEQ counterparts are defined int the file:\n" + ProofParserPane.this.resourceFile, "About", 1);
            }
        });
        helpMenu.add(about);
        this.menu.add(helpMenu);
        this.setJMenuBar(this.menu);
        this.setSize(1000, 800);
    }

    private Element getElement(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        Element[] elements = new Element[]{};
        try {
            elements = BasicParser.createElements((String)text);
        }
        catch (ParserConfigurationException e1) {
            Trace.fatal((Class)CLASS, (String)"setupView$actionPerformed", (String)"Parser configuration error", (Throwable)e1);
            return null;
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (elements.length == 0) {
            return null;
        }
        return elements[0];
    }

    public void setLineWrap(boolean wrap) {
        this.source.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.source.getLineWrap();
    }

    public synchronized void updateView() {
        String method = "updateView()";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView()");
        this.splitPane2.setDividerLocation(0.35);
        if (this.errorPosition >= 0) {
            this.globalPane.setDividerLocation(this.globalPane.getHeight() - this.globalPane.getDividerSize() - this.error.getFontMetrics(this.error.getFont()).getHeight() * 3 - 4);
        } else {
            this.error.setText("");
            this.globalPane.setDividerLocation(this.getHeight());
        }
        this.repaint();
    }

    private void setProposition(String text) {
        this.proposition = new PropositionVo();
        this.error.setText("");
        StringBuffer buffer = new StringBuffer(text);
        TextInput input = new TextInput(buffer);
        this.parser.setParameters(input, this.operators);
        this.errorPosition = -1;
        try {
            this.proposition = new PropositionVo();
            FormalProofVo fp = new FormalProofVo();
            this.proposition.addFormalProof(fp);
            FormalProofLineListVo proof = new FormalProofLineListVo();
            fp.setFormalProofLineList((FormalProofLineList)proof);
            Stack<Object> proofStack = new Stack<Object>();
            Term term = null;
            do {
                FormulaVo formula;
                String label;
                String line;
                if ((line = input.getLine().trim()).toLowerCase().endsWith("hypothesis")) {
                    ConditionalProofVo conditional = new ConditionalProofVo();
                    input.skipWhiteSpace();
                    input.read();
                    String label2 = input.readLetterDigitString();
                    input.skipWhiteSpace();
                    input.readString(1);
                    HypothesisVo hypothesis = new HypothesisVo();
                    FormulaVo formula2 = new FormulaVo();
                    term = this.parser.readTerm();
                    if (term != null) {
                        formula2.setElement(this.getElement(term.getQedeqXml()));
                    }
                    hypothesis.setFormula((Formula)formula2);
                    hypothesis.setLabel(label2);
                    conditional.setHypothesis((Hypothesis)hypothesis);
                    proof.add((FormalProofLine)conditional);
                    proofStack.push(proof);
                    proofStack.push(conditional);
                    proof = new FormalProofLineListVo();
                    conditional.setFormalProofLineList((FormalProofLineList)proof);
                    input.skipToEndOfLine();
                    continue;
                }
                if (line.toLowerCase().endsWith("conclusion")) {
                    input.skipWhiteSpace();
                    input.read();
                    label = input.readLetterDigitString();
                    input.skipWhiteSpace();
                    input.readString(1);
                    ConclusionVo conclusion = new ConclusionVo();
                    formula = new FormulaVo();
                    term = this.parser.readTerm();
                    if (term != null) {
                        formula.setElement(this.getElement(term.getQedeqXml()));
                    }
                    conclusion.setFormula((Formula)formula);
                    conclusion.setLabel(label);
                    ConditionalProofVo conditional = (ConditionalProofVo)proofStack.pop();
                    conditional.setConclusion((Conclusion)conclusion);
                    proof = (FormalProofLineListVo)proofStack.pop();
                    input.skipToEndOfLine();
                    continue;
                }
                if (line.startsWith("(") && Character.isDigit(line.charAt(1))) {
                    input.skipWhiteSpace();
                    input.read();
                    label = input.readLetterDigitString();
                    input.skipWhiteSpace();
                    input.readString(1);
                    FormalProofLineVo l = new FormalProofLineVo();
                    formula = new FormulaVo();
                    term = this.parser.readTerm();
                    if (term != null) {
                        formula.setElement(this.getElement(term.getQedeqXml()));
                    }
                    l.setFormula((Formula)formula);
                    l.setLabel(label);
                    int mark = input.getPosition();
                    String reason = "";
                    try {
                        reason = input.readStringTilWhitespace().toLowerCase();
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    System.out.println("reason = " + reason);
                    if ("add".equals(reason)) {
                        AddVo add = new AddVo();
                        add.setReference(input.readStringTilWhitespace());
                        l.setReason((Reason)add);
                    } else if ("mp".equals(reason)) {
                        ModusPonensVo mp = new ModusPonensVo();
                        String ref1 = input.readStringTilWhitespace();
                        String ref2 = "";
                        if (ref1.endsWith(",")) {
                            ref1 = ref1.substring(0, ref1.length() - 1);
                        } else if (ref1.indexOf(",") >= 0) {
                            ref2 = ref1.substring(ref1.indexOf(",") + 1);
                            ref1 = ref1.substring(0, ref1.indexOf(","));
                        }
                        mp.setReference1(ref1);
                        if (ref2.length() == 0) {
                            ref2 = input.readStringTilWhitespace();
                        }
                        mp.setReference2(ref2);
                        l.setReason((Reason)mp);
                    } else if ("subpred".equals(reason)) {
                        SubstPredVo subpred = new SubstPredVo();
                        term = this.parser.readTerm();
                        if (term != null) {
                            subpred.setPredicateVariable(this.getElement(term.getQedeqXml()));
                        }
                        if ((term = this.parser.readTerm()) != null) {
                            subpred.setSubstituteFormula(this.getElement(term.getQedeqXml()));
                        }
                        subpred.setReference(input.readStringTilWhitespace());
                        l.setReason((Reason)subpred);
                        input.setPosition(mark);
                    } else {
                        input.setPosition(mark);
                    }
                    proof.add((FormalProofLine)l);
                    input.skipToEndOfLine();
                    continue;
                }
                FormulaVo formula3 = new FormulaVo();
                term = this.parser.readTerm();
                if (term != null) {
                    formula3.setElement(this.getElement(term.getQedeqXml()));
                    this.proposition.setFormula(formula3);
                }
                input.skipToEndOfLine();
            } while (!input.isEmpty() && !this.parser.eof());
        }
        catch (ParserException e) {
            e.printStackTrace(System.out);
            StringBuffer result = new StringBuffer();
            this.errorPosition = input.getPosition();
            result.append(input.getRow() + ":" + input.getColumn() + ":" + "\n");
            result.append(e.getMessage() + "\n");
            result.append(input.getLine().replace('\t', ' ').replace('\r', ' ') + "\n");
            StringBuffer pointer = StringUtility.getSpaces((int)input.getColumn());
            pointer.append('^');
            result.append(pointer);
            System.out.println(result.toString());
            this.error.setText(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            StringBuffer result = new StringBuffer();
            this.errorPosition = input.getPosition();
            result.append(input.getRow() + ":" + input.getColumn() + ":" + "\n");
            result.append(e.getMessage() + "\n");
            result.append(input.getLine().replace('\t', ' ').replace('\r', ' ') + "\n");
            StringBuffer pointer = StringUtility.getSpaces((int)input.getColumn());
            pointer.append('^');
            result.append(pointer);
            System.out.println(result.toString());
            this.error.setText(result.toString());
        }
        IoUtility.close((InputStream)input);
    }

    private String getQedeqXml(Proposition proposition) throws ModuleDataException {
        DefaultKernelQedeqBo prop = new DefaultKernelQedeqBo(null, (ModuleAddress)DefaultModuleAddress.MEMORY);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TextOutput output = new TextOutput("out", (OutputStream)outputStream, "UTF-8");
        output.pushLevel();
        output.pushLevel();
        output.pushLevel();
        output.pushLevel();
        Qedeq2Xml visitor = new Qedeq2Xml(null, (KernelQedeqBo)prop, output);
        NodeVo node = new NodeVo();
        node.setId(UNKNOWN_PROPOSITION_ID);
        node.setNodeType((NodeType)proposition);
        visitor.getTraverser().accept((Node)node);
        try {
            return outputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getUtf8(Proposition proposition) throws ModuleDataException {
        DefaultKernelQedeqBo prop = new DefaultKernelQedeqBo(null, (ModuleAddress)DefaultModuleAddress.MEMORY);
        prop.setLabels(new ModuleLabels());
        NodeVo node = new NodeVo();
        node.setId(UNKNOWN_PROPOSITION_ID);
        node.setNodeType((NodeType)proposition);
        prop.getLabels().addNode(new ModuleContext((ModuleAddress)DefaultModuleAddress.MEMORY), node, (KernelQedeqBo)prop, new QedeqNumbers(0, 0));
        StringOutput output = new StringOutput();
        Qedeq2UnicodeVisitor visitor = new Qedeq2UnicodeVisitor(null, (KernelQedeqBo)prop, true, 120, false, false){

            protected String getUtf8(Element element) {
                if (element == null) {
                    return "";
                }
                ModuleLabels labels = new ModuleLabels();
                Element2LatexImpl converter = new Element2LatexImpl(labels);
                Element2Utf8Impl textConverter = new Element2Utf8Impl(converter);
                return textConverter.getUtf8(element);
            }

            protected String[] getUtf8(Element element, int max) {
                if (element == null) {
                    return new String[]{""};
                }
                ModuleLabels labels = new ModuleLabels();
                Element2LatexImpl converter = new Element2LatexImpl(labels);
                Element2Utf8Impl textConverter = new Element2Utf8Impl(converter);
                return textConverter.getUtf8(element, 0);
            }
        };
        visitor.setParameters((AbstractOutput)output, "en");
        visitor.getTraverser().accept((Node)node);
        return output.toString();
    }
}

