/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.qedeq.base.io.Parameters;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.logic.model.FourDynamicModel;
import org.qedeq.kernel.bo.logic.model.SixDynamicModel;
import org.qedeq.kernel.bo.logic.model.ThreeDynamicModel;
import org.qedeq.kernel.bo.logic.model.UnaryDynamicModel;
import org.qedeq.kernel.bo.module.PluginBo;
import org.qedeq.kernel.bo.service.heuristic.DynamicHeuristicCheckerPlugin;
import org.qedeq.kernel.bo.service.latex.Qedeq2LatexPlugin;
import org.qedeq.kernel.bo.service.logic.SimpleProofFinderPlugin;
import org.qedeq.kernel.bo.service.unicode.Qedeq2UnicodeTextPlugin;
import org.qedeq.kernel.bo.service.unicode.Qedeq2Utf8Plugin;
import org.qedeq.kernel.se.common.Plugin;

public class PluginPreferencesDialog
extends JDialog {
    private static final Class CLASS = PluginPreferencesDialog.class;
    private JTextField qedeq2Utf8ShowLanguageTF;
    private JCheckBox qedeq2Utf8ShowInfoCB;
    private JTextField qedeq2Utf8ShowMaximumColumnTF;
    private JCheckBox qedeq2LatexInfoCB;
    private JCheckBox qedeq2LatexBriefCB;
    private JCheckBox qedeq2Utf8InfoCB;
    private JTextField qedeq2Utf8MaximumColumnTF;
    private JCheckBox qedeq2Utf8BriefCB;
    private final Qedeq2LatexPlugin qedeq2latex;
    private final Qedeq2Utf8Plugin qedeq2utf8;
    private final Qedeq2UnicodeTextPlugin qedeq2utf8Show;
    private final SimpleProofFinderPlugin proofFinder;
    private DynamicHeuristicCheckerPlugin dynamicHeuristicChecker;
    private String dynamicHeuristicCheckerModel = "";
    private JTextField proofFinderMaximumProofLengthTF;
    private JTextField proofFinderExtraVarsTF;
    private JTextField proofFinderPropositionVariableOrderTF;
    private JTextField proofFinderPropositionVariableWeightTF;
    private JTextField proofFinderPartFormulaOrderTF;
    private JTextField proofFinderPartFormulaWeightTF;
    private JTextField proofFinderDisjunctionOrderTF;
    private JTextField proofFinderDisjunctionWeightTF;
    private JTextField proofFinderImplicationOrderTF;
    private JTextField proofFinderImplicationWeightTF;
    private JTextField proofFinderNegationOrderTF;
    private JTextField proofFinderNegationWeightTF;
    private JTextField proofFinderConjunctionOrderTF;
    private JTextField proofFinderConjunctionWeightTF;
    private JTextField proofFinderEquivalenceOrderTF;
    private JTextField proofFinderEquivalenceWeightTF;
    private JTextField proofFinderLogFrequenceTF;
    private JTextField proofFinderSkipFormulasTF;
    private JTabbedPane tabbedPane;
    private List creators;

    public PluginPreferencesDialog(JFrame parent) {
        super((Frame)parent, "Plugin Preferences");
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.qedeq2latex = new Qedeq2LatexPlugin();
            this.qedeq2utf8 = new Qedeq2Utf8Plugin();
            this.qedeq2utf8Show = new Qedeq2UnicodeTextPlugin();
            this.dynamicHeuristicChecker = new DynamicHeuristicCheckerPlugin();
            this.proofFinder = new SimpleProofFinderPlugin();
            this.creators = new ArrayList();
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.setupView();
            this.updateView();
        }
        catch (RuntimeException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"Initalization of PreferencesDialog failed.", (String)"Constructor", (Throwable)e);
            throw e;
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    public final void setupView() {
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.creators.add(this.qedeq2Utf8ShowConfig((PluginBo)this.qedeq2utf8Show));
        this.creators.add(this.qedeq2LatexConfig((PluginBo)this.qedeq2latex));
        this.creators.add(this.qedeq2Utf8Config((PluginBo)this.qedeq2utf8));
        this.creators.add(this.dynamicHeuristicCheckerConfig((PluginBo)this.dynamicHeuristicChecker));
        this.creators.add(this.proofFinderConfig((PluginBo)this.proofFinder));
        Iterator iter = this.creators.iterator();
        while (iter.hasNext()) {
            PluginGuiPreferencesCreator creator = (PluginGuiPreferencesCreator)iter.next();
            this.tabbedPane.addTab(creator.getName(), creator.create(QedeqGuiConfig.getInstance().getPluginEntries((Plugin)creator.getPlugin())));
        }
        this.tabbedPane.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), this.tabbedPane.getBorder()));
        content.add((Component)this.tabbedPane, "Center");
        content.add((Component)GuiHelper.addSpaceAndAlignRight(this.buildButtonPanel()), "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.getWidth();
        if (2 * width < screenSize.width) {
            width = 2 * width;
        }
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, width, this.getHeight());
    }

    private PluginGuiPreferencesCreator qedeq2LatexConfig(final PluginBo plugin) {
        return new PluginGuiPreferencesCreator(plugin){

            JComponent create(Parameters parameters) {
                FormLayout layout = new FormLayout("left:pref, 5dlu, fill:pref:grow");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                builder.getPanel().setOpaque(false);
                PluginPreferencesDialog.this.qedeq2LatexInfoCB = new JCheckBox(" Also write reference labels (makes it easier for authors)", parameters.getBoolean("info"));
                builder.append((Component)PluginPreferencesDialog.this.qedeq2LatexInfoCB);
                builder.nextLine();
                PluginPreferencesDialog.this.qedeq2LatexBriefCB = new JCheckBox(" Leave out main text entries. Creates a very brief document.", parameters.getBoolean("brief"));
                builder.append((Component)PluginPreferencesDialog.this.qedeq2LatexBriefCB);
                return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
            }
        };
    }

    private PluginGuiPreferencesCreator qedeq2Utf8Config(final PluginBo plugin) {
        return new PluginGuiPreferencesCreator(plugin){

            JComponent create(Parameters parameters) {
                FormLayout layout = new FormLayout("left:pref, 5dlu, fill:50dlu, fill:pref:grow");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                builder.getPanel().setOpaque(false);
                PluginPreferencesDialog.this.qedeq2Utf8InfoCB = new JCheckBox(" Also write reference labels (makes it easier for authors)", parameters.getBoolean("info"));
                builder.append((Component)PluginPreferencesDialog.this.qedeq2Utf8InfoCB, 4);
                builder.nextLine();
                builder.append("Maximum row length");
                PluginPreferencesDialog.this.qedeq2Utf8MaximumColumnTF = new JTextField(parameters.getString("maximumColumn"));
                PluginPreferencesDialog.this.qedeq2Utf8MaximumColumnTF.setToolTipText("After this character number the line is broken.0 means no break at all.");
                builder.append((Component)PluginPreferencesDialog.this.qedeq2Utf8MaximumColumnTF);
                builder.nextLine();
                PluginPreferencesDialog.this.qedeq2Utf8BriefCB = new JCheckBox(" Leave out main text entries. Creates a very brief document.", parameters.getBoolean("brief"));
                builder.append((Component)PluginPreferencesDialog.this.qedeq2Utf8BriefCB);
                return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
            }
        };
    }

    private PluginGuiPreferencesCreator qedeq2Utf8ShowConfig(final PluginBo plugin) {
        return new PluginGuiPreferencesCreator(plugin){

            JComponent create(Parameters parameters) {
                FormLayout layout = new FormLayout("left:pref, 5dlu, fill:50dlu, fill:pref:grow");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                builder.getPanel().setOpaque(false);
                builder.append("Default language");
                PluginPreferencesDialog.this.qedeq2Utf8ShowLanguageTF = new JTextField(parameters.getString("language"));
                PluginPreferencesDialog.this.qedeq2Utf8ShowLanguageTF.setToolTipText("Default language for showing module contents.");
                builder.append((Component)PluginPreferencesDialog.this.qedeq2Utf8ShowLanguageTF);
                builder.nextLine();
                PluginPreferencesDialog.this.qedeq2Utf8ShowInfoCB = new JCheckBox(" Also write reference labels (makes it easier for authors)", parameters.getBoolean("info"));
                builder.append((Component)PluginPreferencesDialog.this.qedeq2Utf8ShowInfoCB, 4);
                builder.nextLine();
                builder.append("Maximum row length");
                PluginPreferencesDialog.this.qedeq2Utf8ShowMaximumColumnTF = new JTextField(parameters.getString("maximumColumn"));
                PluginPreferencesDialog.this.qedeq2Utf8ShowMaximumColumnTF.setToolTipText("After this character number the line is broken.0 means no break at all.");
                builder.append((Component)PluginPreferencesDialog.this.qedeq2Utf8ShowMaximumColumnTF);
                return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
            }
        };
    }

    private PluginGuiPreferencesCreator dynamicHeuristicCheckerConfig(final PluginBo plugin) {
        return new PluginGuiPreferencesCreator(plugin){

            JComponent create(Parameters parameters) {
                FormLayout layout = new FormLayout("left:pref, 5dlu, fill:pref:grow", "top:pref:grow, top:pref:grow, top:pref:grow");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                builder.getPanel().setOpaque(false);
                ThreeDynamicModel modelThree = new ThreeDynamicModel();
                FourDynamicModel modelFour = new FourDynamicModel();
                SixDynamicModel modelSix = new SixDynamicModel();
                ButtonGroup dynamicHeuristicCheckerModelBG = new ButtonGroup();
                UnaryDynamicModel modelOne = new UnaryDynamicModel();
                PluginPreferencesDialog.this.dynamicHeuristicCheckerModel = parameters.getString("model");
                ActionListener modelSelectionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PluginPreferencesDialog.this.dynamicHeuristicCheckerModel = e.getActionCommand();
                    }
                };
                JRadioButton dynamicHeuristicCheckerOneModelRB = new JRadioButton("One");
                if (PluginPreferencesDialog.this.dynamicHeuristicCheckerModel.equals(modelOne.getClass().getName())) {
                    dynamicHeuristicCheckerOneModelRB.setSelected(true);
                }
                dynamicHeuristicCheckerOneModelRB.setActionCommand(modelOne.getClass().getName());
                dynamicHeuristicCheckerOneModelRB.addActionListener(modelSelectionListener);
                dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerOneModelRB);
                builder.append((Component)dynamicHeuristicCheckerOneModelRB);
                builder.append((Component)PluginPreferencesDialog.this.getDescription(modelOne.getDescription()));
                JRadioButton dynamicHeuristicCheckerThreeModelRB = new JRadioButton("Three");
                if (PluginPreferencesDialog.this.dynamicHeuristicCheckerModel.equals(modelThree.getClass().getName())) {
                    dynamicHeuristicCheckerThreeModelRB.setSelected(true);
                }
                dynamicHeuristicCheckerThreeModelRB.setActionCommand(modelThree.getClass().getName());
                dynamicHeuristicCheckerThreeModelRB.addActionListener(modelSelectionListener);
                dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerThreeModelRB);
                builder.append((Component)dynamicHeuristicCheckerThreeModelRB);
                builder.append((Component)PluginPreferencesDialog.this.getDescription(modelThree.getDescription()));
                JRadioButton dynamicHeuristicCheckerFourModelRB = new JRadioButton("Four");
                if (PluginPreferencesDialog.this.dynamicHeuristicCheckerModel.equals(modelFour.getClass().getName())) {
                    dynamicHeuristicCheckerFourModelRB.setSelected(true);
                }
                dynamicHeuristicCheckerFourModelRB.setActionCommand(modelFour.getClass().getName());
                dynamicHeuristicCheckerFourModelRB.addActionListener(modelSelectionListener);
                dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerFourModelRB);
                builder.append((Component)dynamicHeuristicCheckerFourModelRB);
                builder.append((Component)PluginPreferencesDialog.this.getDescription(modelFour.getDescription()));
                JRadioButton dynamicHeuristicCheckerSixModelRB = new JRadioButton("Six");
                if (PluginPreferencesDialog.this.dynamicHeuristicCheckerModel.equals(modelSix.getClass().getName())) {
                    dynamicHeuristicCheckerSixModelRB.setSelected(true);
                }
                dynamicHeuristicCheckerSixModelRB.setActionCommand(modelSix.getClass().getName());
                dynamicHeuristicCheckerSixModelRB.addActionListener(modelSelectionListener);
                dynamicHeuristicCheckerModelBG.add(dynamicHeuristicCheckerSixModelRB);
                builder.append((Component)dynamicHeuristicCheckerSixModelRB);
                builder.append((Component)PluginPreferencesDialog.this.getDescription(modelSix.getDescription()));
                return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
            }
        };
    }

    private PluginGuiPreferencesCreator proofFinderConfig(final PluginBo plugin) {
        return new PluginGuiPreferencesCreator(plugin){

            JComponent create(Parameters parameters) {
                FormLayout layout = new FormLayout("left:pref, 5dlu, fill:50dlu, 5dlu, fill:50dlu, fill:pref:grow");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                builder.getPanel().setOpaque(false);
                builder.append("Maximum proof lines");
                PluginPreferencesDialog.this.proofFinderMaximumProofLengthTF = new JTextField(parameters.getString("maximumProofLines"));
                PluginPreferencesDialog.this.proofFinderMaximumProofLengthTF.setToolTipText("After this proof line number we abandom. the search. This is not the maximum proof line length of the final proof but the but the maximum number of all generated proof lines.");
                builder.append((Component)PluginPreferencesDialog.this.proofFinderMaximumProofLengthTF);
                builder.nextLine();
                builder.append("Log frequence");
                PluginPreferencesDialog.this.proofFinderLogFrequenceTF = new JTextField(parameters.getString("logFrequence"));
                PluginPreferencesDialog.this.proofFinderLogFrequenceTF.setToolTipText("After this number of new proof lines we create a logging output.");
                builder.append((Component)PluginPreferencesDialog.this.proofFinderLogFrequenceTF);
                builder.nextLine();
                builder.append("Skip formulas");
                PluginPreferencesDialog.this.proofFinderSkipFormulasTF = new JTextField(parameters.getString("skipFormulas"));
                PluginPreferencesDialog.this.proofFinderSkipFormulasTF.setToolTipText("Skip these list of formula numbers (see log output). This a comma separated list of numbers.");
                builder.append((Component)PluginPreferencesDialog.this.proofFinderSkipFormulasTF);
                builder.nextLine();
                PluginPreferencesDialog.this.proofFinderExtraVarsTF = new JTextField(parameters.getString("extraVars"));
                builder.append("Extra proposition variables");
                builder.append((Component)PluginPreferencesDialog.this.proofFinderExtraVarsTF);
                PluginPreferencesDialog.this.proofFinderExtraVarsTF.setToolTipText("We use these number of extra proposition variables beside the ones we have in our initial formulas and the goal formula.");
                builder.nextLine();
                builder.appendSeparator();
                builder.append("Operator");
                builder.append("Order");
                builder.append("Weight");
                builder.nextLine();
                builder.append("Proposition variable");
                PluginPreferencesDialog.this.proofFinderPropositionVariableOrderTF = new JTextField(parameters.getString("propositionVariableOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderPropositionVariableOrderTF);
                PluginPreferencesDialog.this.proofFinderPropositionVariableWeightTF = new JTextField(parameters.getString("propositionVariableWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderPropositionVariableWeightTF);
                builder.nextLine();
                builder.append("Part formula");
                PluginPreferencesDialog.this.proofFinderPartFormulaOrderTF = new JTextField(parameters.getString("partFormulaOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderPartFormulaOrderTF);
                PluginPreferencesDialog.this.proofFinderPartFormulaWeightTF = new JTextField(parameters.getString("partFormulaWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderPartFormulaWeightTF);
                builder.nextLine();
                builder.append("Disjunction");
                PluginPreferencesDialog.this.proofFinderDisjunctionOrderTF = new JTextField(parameters.getString("disjunctionOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderDisjunctionOrderTF);
                PluginPreferencesDialog.this.proofFinderDisjunctionWeightTF = new JTextField(parameters.getString("disjunctionWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderDisjunctionWeightTF);
                builder.nextLine();
                builder.append("Implication");
                PluginPreferencesDialog.this.proofFinderImplicationOrderTF = new JTextField(parameters.getString("implicationOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderImplicationOrderTF);
                PluginPreferencesDialog.this.proofFinderImplicationWeightTF = new JTextField(parameters.getString("implicationWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderImplicationWeightTF);
                builder.nextLine();
                builder.append("Negation");
                PluginPreferencesDialog.this.proofFinderNegationOrderTF = new JTextField(parameters.getString("negationOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderNegationOrderTF);
                PluginPreferencesDialog.this.proofFinderNegationWeightTF = new JTextField(parameters.getString("negationWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderNegationWeightTF);
                builder.nextLine();
                builder.append("Conjunction");
                PluginPreferencesDialog.this.proofFinderConjunctionOrderTF = new JTextField(parameters.getString("conjunctionOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderConjunctionOrderTF);
                PluginPreferencesDialog.this.proofFinderConjunctionWeightTF = new JTextField(parameters.getString("conjunctionWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderConjunctionWeightTF);
                builder.nextLine();
                builder.append("Equivalence");
                PluginPreferencesDialog.this.proofFinderEquivalenceOrderTF = new JTextField(parameters.getString("equivalenceOrder"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderEquivalenceOrderTF);
                PluginPreferencesDialog.this.proofFinderEquivalenceWeightTF = new JTextField(parameters.getString("equivalenceWeight"));
                builder.append((Component)PluginPreferencesDialog.this.proofFinderEquivalenceWeightTF);
                builder.nextLine();
                return GuiHelper.addSpaceAndTitle(builder.getPanel(), plugin.getPluginDescription());
            }
        };
    }

    private JTextArea getDescription(String text) {
        JTextArea description = new JTextArea(text);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        return description;
    }

    private JPanel buildButtonPanel() {
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton def = new JButton("Default");
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int i = PluginPreferencesDialog.this.tabbedPane.getSelectedIndex();
                PluginGuiPreferencesCreator creator = (PluginGuiPreferencesCreator)PluginPreferencesDialog.this.creators.get(i);
                PluginPreferencesDialog.this.tabbedPane.setComponentAt(i, creator.createDefault());
            }
        });
        def.setToolTipText("Reset to default values for plugin currently displayed.");
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreferencesDialog.this.save();
                PluginPreferencesDialog.this.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginPreferencesDialog.this.dispose();
            }
        });
        bbuilder.addGriddedButtons(new JButton[]{def});
        bbuilder.addUnrelatedGap();
        bbuilder.addUnrelatedGap();
        bbuilder.addGriddedButtons(new JButton[]{cancel, ok});
        JPanel buttons = bbuilder.getPanel();
        return buttons;
    }

    public void updateView() {
        this.invalidate();
        this.repaint();
    }

    void save() {
        try {
            Qedeq2UnicodeTextPlugin plugin = this.qedeq2utf8Show;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "language", this.qedeq2Utf8ShowLanguageTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "info", this.qedeq2Utf8ShowInfoCB.isSelected());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "maximumColumn", this.qedeq2Utf8ShowMaximumColumnTF.getText());
            plugin = this.qedeq2latex;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "info", this.qedeq2LatexInfoCB.isSelected());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "brief", this.qedeq2LatexBriefCB.isSelected());
            plugin = this.qedeq2utf8;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "info", this.qedeq2Utf8InfoCB.isSelected());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "maximumColumn", this.qedeq2Utf8MaximumColumnTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "brief", this.qedeq2Utf8BriefCB.isSelected());
            plugin = this.dynamicHeuristicChecker;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "model", this.dynamicHeuristicCheckerModel);
            plugin = this.proofFinder;
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "maximumProofLines", this.proofFinderMaximumProofLengthTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "logFrequence", this.proofFinderLogFrequenceTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "skipFormulas", this.proofFinderSkipFormulasTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "extraVars", this.proofFinderExtraVarsTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "propositionVariableOrder", this.proofFinderPropositionVariableOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "propositionVariableWeight", this.proofFinderPropositionVariableWeightTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "partFormulaOrder", this.proofFinderPartFormulaOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "partFormulaWeight", this.proofFinderPartFormulaWeightTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "disjunctionOrder", this.proofFinderDisjunctionOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "disjunctionWeight", this.proofFinderDisjunctionWeightTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "implicationOrder", this.proofFinderImplicationOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "implicationWeight", this.proofFinderImplicationWeightTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "negationOrder", this.proofFinderNegationOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "negationWeight", this.proofFinderNegationWeightTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "conjunctionOrder", this.proofFinderConjunctionOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "conjunctionWeight", this.proofFinderConjunctionWeightTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "equivalenceOrder", this.proofFinderEquivalenceOrderTF.getText());
            QedeqGuiConfig.getInstance().setPluginKeyValue((Plugin)plugin, "equivalenceWeight", this.proofFinderEquivalenceWeightTF.getText());
        }
        catch (RuntimeException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"save", (String)"couldn't save preferences", (Throwable)e);
            JOptionPane.showMessageDialog(this, e.toString(), "Error", 0);
        }
        try {
            QedeqGuiConfig.getInstance().store();
        }
        catch (IOException e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"save", (String)"couldn't save preferences", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Couldn't save preferences", "Error", 0);
        }
    }

    private abstract class PluginGuiPreferencesCreator {
        private final PluginBo plugin;

        PluginGuiPreferencesCreator(PluginBo plugin) {
            this.plugin = plugin;
        }

        public PluginBo getPlugin() {
            return this.plugin;
        }

        public String getName() {
            return this.plugin.getPluginActionName();
        }

        private Parameters getDefaultPluginValues() {
            Parameters parameters = new Parameters();
            this.plugin.setDefaultValuesForEmptyPluginParameters(parameters);
            return parameters;
        }

        JComponent createDefault() {
            return this.create(this.getDefaultPluginValues());
        }

        abstract JComponent create(Parameters var1);
    }
}

