/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.common.QedeqBo;
import org.qedeq.kernel.se.common.Plugin;

public class ModulePropertiesPane
extends JPanel {
    private QedeqBo prop = null;
    private JTextField state;
    private JTextField plugin;
    private JTextField name;
    private JTextField ruleVersion;
    private JTextArea url;
    private JTextField errorsAndWarnings;

    public ModulePropertiesPane() {
        this.setupView();
        this.updateView();
    }

    private JComponent buildTestPanel() {
        FormLayout layout = new FormLayout("right:pref, 5dlu, fill:50dlu:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        builder.setDefaultDialogBorder();
        builder.append("State");
        this.state = this.createTextField("", false);
        builder.append((Component)this.state);
        builder.append("Name");
        this.name = this.createTextField("", false);
        builder.append((Component)this.name);
        builder.append("Rule Version");
        this.ruleVersion = this.createTextField("", false);
        builder.append((Component)this.ruleVersion);
        builder.append("URL");
        this.url = new JTextArea();
        this.url.setEditable(false);
        this.url.setLineWrap(false);
        builder.append(this.wrapWithScrollPane(this.url));
        builder.append("Running");
        this.plugin = this.createTextField("", false);
        builder.append((Component)this.plugin);
        builder.append("Problems");
        this.errorsAndWarnings = this.createTextField("", false);
        builder.append((Component)this.errorsAndWarnings);
        return builder.getPanel();
    }

    public final void setupView() {
        this.setLayout(new GridLayout(1, 1));
        this.add(this.buildTestPanel());
        this.setPreferredSize(new Dimension(200, 200));
    }

    public void setModel(QedeqBo prop) {
        this.prop = prop;
        this.updateView();
    }

    public QedeqBo getModel() {
        return this.prop;
    }

    public void updateView() {
        if (this.prop != null) {
            this.state.setText(this.prop.getStateDescription());
            this.name.setText(this.prop.getName());
            this.ruleVersion.setText(this.prop.getRuleVersion());
            this.url.setText(this.prop.getUrl().toString());
            Plugin p = this.prop.getCurrentlyRunningPlugin();
            if (p != null) {
                this.plugin.setText(p.getPluginActionName());
                this.plugin.setToolTipText(GuiHelper.getToolTipText(p.getPluginDescription()));
            } else {
                this.plugin.setText("");
                this.plugin.setToolTipText("");
            }
            this.errorsAndWarnings.setText(this.prop.getErrors().size() + " errors, " + this.prop.getWarnings().size() + " warnings");
        } else {
            this.state.setText("");
            this.name.setText("");
            this.ruleVersion.setText("");
            this.url.setText("");
            this.plugin.setText("");
            this.errorsAndWarnings.setText("");
        }
        this.invalidate();
        this.repaint();
    }

    private JTextField createTextField(String selectedText, boolean editable) {
        JTextField combo = new JTextField(selectedText);
        combo.setEditable(editable);
        return combo;
    }

    private Component wrapWithScrollPane(Component c) {
        return new JScrollPane(c, 21, 31);
    }
}

