/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.utility.DateUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.gui.se.element.CPTextArea;
import org.qedeq.gui.se.util.BareBonesBrowserLaunch;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.KernelContext;

public class AboutDialog
extends JDialog {
    public AboutDialog(Frame parent) {
        super(parent, "About", true);
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        ImageIcon icon = GuiHelper.readImageIcon("qedeq/32x32/qedeq.png");
        JLabel logo = new JLabel(icon, 4);
        logo.setText("GUI for Hilbert II ");
        logo.setHorizontalTextPosition(2);
        logo.setFont(UIManager.getFont("TitledBorder.font"));
        logo.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 0, 10), logo.getBorder()));
        String url = "http://www.qedeq.org/";
        JPanel logoPanel = new JPanel();
        logoPanel.setLayout(new GridLayout(1, 1));
        logoPanel.add(logo);
        logoPanel.setToolTipText("http://www.qedeq.org/");
        logoPanel.setCursor(new Cursor(12));
        logoPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    BareBonesBrowserLaunch.openURL("http://www.qedeq.org/");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        content.add((Component)logoPanel, "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setOpaque(false);
        tabbedPane.addTab("About", this.createAboutTab());
        tabbedPane.addTab("System Properties", this.createSystemPropertiesTab());
        tabbedPane.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), tabbedPane.getBorder()));
        content.add((Component)tabbedPane, "Center");
        content.add((Component)this.createBottomBar(), "South");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AboutDialog.this.dispose();
            }
        });
    }

    private JComponent createBottomBar() {
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton ok = new JButton("Close");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String command = actionEvent.getActionCommand();
                if (command.compareTo("Close") == 0) {
                    AboutDialog.this.dispose();
                }
            }
        });
        JButton copyButton = new JButton("Copy System Properties");
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer sb = new StringBuffer(1000);
                String[][] prop = IoUtility.getSortedSystemProperties();
                sb.append("# Copied Java system properties during run of ");
                sb.append(KernelContext.getInstance().getDescriptiveKernelVersion());
                sb.append("\n");
                sb.append("# GMT: ");
                sb.append(DateUtility.getGmtTimestamp());
                sb.append("\n#");
                sb.append("\n# The following list contains excaped characters as defined for \"properties\" files");
                sb.append("\n#\n");
                for (int i = 0; i < prop.length; ++i) {
                    sb.append(StringUtility.escapeProperty((String)prop[i][0]));
                    sb.append("=");
                    sb.append(StringUtility.escapeProperty((String)prop[i][1]));
                    sb.append("\n");
                }
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(sb.toString());
                cb.setContents(sel, null);
            }
        });
        copyButton.setToolTipText("Copy Java system information into the clipboard.");
        bbuilder.addGriddedButtons(new JButton[]{copyButton, ok});
        return GuiHelper.addSpaceAndAlignRight(bbuilder.getPanel());
    }

    private JComponent createSystemPropertiesTab() {
        Object[][] rowData = IoUtility.getSortedSystemProperties();
        for (int i = 0; i < rowData.length; ++i) {
            if (!"line.separator".equals(rowData[i][0])) continue;
            rowData[i][1] = StringUtility.escapeProperty((String)rowData[i][1]);
            break;
        }
        Object[] nvStrings = new String[]{"Property", "Value"};
        DefaultTableModel model = new DefaultTableModel(rowData, nvStrings){

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        JTable table = new JTable(model);
        table.setAutoResizeMode(0);
        GuiHelper.calcColumnWidths(table);
        JScrollPane scroller = new JScrollPane(table);
        scroller.setBorder(GuiHelper.getEmptyBorder());
        scroller.setBackground(UIManager.getColor("controlShadow"));
        return scroller;
    }

    private JComponent createAboutTab() {
        JPanel panel = new JPanel(new BorderLayout());
        StringBuffer sb = new StringBuffer();
        sb.append("This is Hilbert II - a project to create a formal correct (checkable by a proof verifier) but readable (like an ordinary LaTeX textbook) mathematical knowledge base.");
        sb.append("\n\nWritten by Michael Meyling <mime@qedeq.org>");
        sb.append("\nCopyright \u00a9 2000 - 2013 Michael Meyling. All Rights Reserved.");
        sb.append("\n\nHilbert II comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to redistribute it under certain conditions.");
        sb.append(" Please take a look at the license argreements section in the online help.");
        sb.append("\n\nKernel Version: " + KernelContext.getInstance().getKernelVersion());
        sb.append("\nCode Name: " + KernelContext.getInstance().getKernelCodeName());
        sb.append("\nBuild: " + KernelContext.getInstance().getBuildId());
        sb.append("\n\n" + KernelContext.getInstance().getDedication());
        sb.append("\n\n");
        sb.append("\nUsed memory: ");
        sb.append(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        sb.append("\nFree memory: ");
        sb.append(Runtime.getRuntime().freeMemory());
        sb.append("\nTotal memory: ");
        sb.append(Runtime.getRuntime().totalMemory());
        sb.append("\nMaximum memory: ");
        sb.append(Runtime.getRuntime().maxMemory());
        sb.append("\n\nNumber of processors/cores: ");
        sb.append(Runtime.getRuntime().availableProcessors());
        JScrollPane copy = AboutDialog.createTextScroller(sb.toString());
        copy.setBorder(GuiHelper.getEmptyBorder());
        panel.add((Component)copy, "Center");
        return panel;
    }

    public static JScrollPane createTextScroller(String text) {
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(AboutDialog.createTextArea(text));
        scroller.setBackground(UIManager.getColor("controlShadow"));
        return scroller;
    }

    public static JTextArea createTextArea(String text) {
        CPTextArea textArea = new CPTextArea(text, false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setCaretPosition(0);
        textArea.setBackground(UIManager.getColor("controlHighlight"));
        return textArea;
    }
}

