/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.element;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.util.GuiHelper;

public class FindDialog
extends JDialog {
    private static final Class CLASS = FindDialog.class;
    private static final int MAX_HISTORY_SIZE = 20;
    public static final List HISTORY = new ArrayList();
    private JTextComponent text;
    private JCheckBox caseSensitive;
    private JComboBox searchText;
    private JLabel status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FindDialog(JTextComponent text) {
        super((Frame)((JFrame)text.getTopLevelAncestor()), "Find");
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.setDefaultCloseOperation(2);
            this.setupView(text);
            this.updateView();
        }
        catch (Throwable e) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"Initalization of FindDialog failed.", (String)"Constructor", (Throwable)e);
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    private JComponent searchPanel() {
        FormLayout layout = new FormLayout("right:pref, 5dlu, fill:pref:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        builder.getPanel().setOpaque(false);
        this.searchText = new JComboBox();
        for (int i = 0; i < HISTORY.size() && i < 20; ++i) {
            this.searchText.addItem(HISTORY.get(i));
        }
        this.searchText.setEditable(true);
        builder.append("Search:", (Component)this.searchText);
        this.caseSensitive = new JCheckBox("", false);
        builder.append((Component)this.caseSensitive);
        builder.append((Component)new JLabel("Case sensitive"));
        return GuiHelper.addSpaceAndTitle(builder.getPanel(), "Find");
    }

    public final void setupView(JTextComponent text) {
        this.text = text;
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel allOptions = new JPanel();
        allOptions.setBorder(GuiHelper.getEmptyBorder());
        allOptions.setLayout(new BoxLayout(allOptions, 1));
        allOptions.add(this.searchPanel());
        allOptions.add(Box.createVerticalStrut(GuiHelper.getEmptyBorderPixelsY()));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setOpaque(false);
        tabbedPane.addTab("Main Options", allOptions);
        content.add(tabbedPane);
        content.add(GuiHelper.addSpaceAndAlignRight(this.createButtonPanel()));
        this.status = new JLabel("");
        JPanel panel = new JPanel();
        panel.add(this.status);
        content.add(GuiHelper.alignLeft(panel));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2, this.getWidth(), this.getHeight() + 20);
    }

    private JPanel createButtonPanel() {
        ButtonBarBuilder bbuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JButton findB = new JButton("Find");
        findB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int pos1 = FindDialog.this.findCaretPosition(FindDialog.this.text.getCaretPosition());
                    if (pos1 < 0) {
                        FindDialog.this.status.setText("Search from beginning");
                        pos1 = FindDialog.this.findCaretPosition(0);
                        if (pos1 < 0) {
                            FindDialog.this.status.setText("String not found");
                            return;
                        }
                    } else {
                        FindDialog.this.status.setText("");
                    }
                    int pos2 = pos1 + FindDialog.this.searchText.getSelectedItem().toString().length();
                    FindDialog.this.text.setCaretPosition(pos1);
                    FindDialog.this.text.moveCaretPosition(pos2);
                    FindDialog.this.text.requestFocus();
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        });
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.dispose();
            }
        });
        bbuilder.addGriddedButtons(new JButton[]{findB, close});
        JPanel buttons = bbuilder.getPanel();
        return buttons;
    }

    public void updateView() {
        this.invalidate();
        this.repaint();
    }

    private final int findCaretPosition(int start) {
        Document doc = this.text.getDocument();
        int nleft = doc.getLength();
        String data = "";
        Segment s = new Segment();
        int offs = 0;
        s.setPartialReturn(false);
        try {
            doc.getText(offs, nleft, s);
            data = s.toString();
        }
        catch (BadLocationException e) {
            data = this.text.getText();
        }
        String m = this.searchText.getSelectedItem().toString();
        HISTORY.remove(m);
        HISTORY.add(0, m);
        this.searchText.removeAllItems();
        for (int i = 0; i < HISTORY.size(); ++i) {
            this.searchText.addItem(HISTORY.get(i));
        }
        boolean cs = this.caseSensitive.isSelected();
        if (!cs) {
            data = data.toLowerCase();
            m = m.toLowerCase();
        }
        Trace.trace((Class)CLASS, (String)"findCaretPosition(int)", (Object)("searching for " + m + " from " + start));
        int result = data.indexOf(m, start);
        Trace.trace((Class)CLASS, (String)"findCaretPosition(int)", (Object)("result = " + result));
        return result;
    }
}

