/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.pane.ParserPane;
import org.qedeq.kernel.bo.parser.AsciiMathParser;
import org.qedeq.kernel.bo.parser.MathParser;
import org.qedeq.kernel.se.common.SourceFileExceptionList;

class TextParserAction
extends AbstractAction {
    private static final Class CLASS = TextParserAction.class;
    private final QedeqController controller;

    TextParserAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        String resourceName = "textMathOperators.xml";
        try {
            ParserPane pane = new ParserPane("Text", (MathParser)new AsciiMathParser(), "QEDEQ Text Parser Sample", "textMathOperators.xml", "a -> (b & c)\nA x (x in y <-> x in z) -> y = z\nset(x) <-> E y (y in x)\nE x A y a(x, y) -> A x E y a(x, y)\n");
            pane.setVisible(true);
        }
        catch (SourceFileExceptionList xl) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"Parser Window can not be opened", (Throwable)xl);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Parser Window can not be opened. There is a problem with \"textMathOperators.xml\"\n\nJust deleting this file in the config directory should fix the error.\n\n" + xl.toString(), "Error", 0);
        }
        catch (RuntimeException ex) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"unexpected problem", (Throwable)ex);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Parser Window can not be opened\n" + ex.toString(), "Error", 0);
        }
    }
}

