/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.qedeq.base.io.ResourceLoaderUtility;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.util.ExternalLinkContentViewerUI;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.KernelContext;

class HelpAction
extends AbstractAction {
    private static final Class CLASS = HelpAction.class;
    private final QedeqController controller;

    HelpAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        String pathToHS = "resources/help/Help.hs";
        URL hsURL = null;
        HelpSet hs = null;
        try {
            hsURL = ResourceLoaderUtility.getResourceUrl((String)pathToHS);
            hs = new HelpSet(null, hsURL);
        }
        catch (Exception ex) {
            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed(ActionEvent)", (String)"Problems loading help set.", (Throwable)ex);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "Help for " + KernelContext.getInstance().getDescriptiveKernelVersion() + "\n\n" + "Still missing" + "\n\n", "Help", 1, GuiHelper.readImageIcon("qedeq/32x32/qedeq.png"));
            return;
        }
        UIDefaults table = UIManager.getDefaults();
        Object[] uiDefaults = new Object[]{"HelpContentViewerUI", ExternalLinkContentViewerUI.class.getName()};
        table.putDefaults(uiDefaults);
        JHelp jHelp = new JHelp(hs);
        JDialog dialog = new JDialog(this.controller.getMainFrame(), "Help", true);
        dialog.getContentPane().add("Center", (Component)jHelp);
        dialog.setSize(new Dimension(950, 700));
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }
}

