<?xml version="1.0" encoding="UTF-8"?>
<!--
This file is part of the xframe software package
hosted at http://xframe.sourceforge.net

Copyright (c) 2003 Kurt Riede.
    
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  exclude-result-prefixes="xs" version="1.0">
  <!--
    Create HTML comment that a file is automaticly created by xframe.
  -->
  <xsl:template name="xsddocComment">
    <xsl:comment> This file is automaticaly generated by xframe - xsddoc</xsl:comment>
    <xsl:comment> hosted at http://xframe.sourceforge.net </xsl:comment>
    <xsl:comment> Please do not modify. </xsl:comment>
  </xsl:template>
  <!--
    Generate unique folder name for a URI by translating
    characters that are not alowed in file names to underscore.
  -->
  <xsl:template name="namespaceFolder">
    <xsl:param name="uri"/>
    <xsl:choose>
      <xsl:when test="normalize-space($uri) = ''">
        <xsl:value-of select="string('noNamespace')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="translate(normalize-space($uri), ':/\#?&amp;!', '_______')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!--
    Find target namespace of elements.
  -->
  <xsl:variable name="targetNamespace" select="/xs:schema/@targetNamespace" />
  <xsl:template match="xs:element" mode="targetNamespace">
   <xsl:choose>
      <xsl:when test="$targetNamespace and (parent::xs:schema or @form = 'qualified' or ancestor::xs:schema/@elementFormDefault = 'qualified')">
         <xsl:value-of select="$targetNamespace" />
      </xsl:when>
      <xsl:otherwise>no namespace</xsl:otherwise>
   </xsl:choose>
  </xsl:template>
  <!--
    Find target namespace of attributes.
  -->
  <xsl:template match="xs:attribute" mode="targetNamespace">
     <xsl:choose>
        <xsl:when test="$targetNamespace and (parent::xs:schema or @form = 'qualified' or ancestor::xs:schema/@attributeFormDefault = 'qualified')">
           <xsl:value-of select="$targetNamespace" />
        </xsl:when>
        <xsl:otherwise>no namespace</xsl:otherwise>
     </xsl:choose>
  </xsl:template>
  <!--
    Find target namespace of others.
  -->
  <xsl:template match="*" mode="targetNamespace">
     <xsl:choose>
        <xsl:when test="$targetNamespace">
           <xsl:value-of select="$targetNamespace" />
        </xsl:when>
        <xsl:otherwise>no namespace</xsl:otherwise>
     </xsl:choose>
  </xsl:template>
  <!--
    Return QName of name given as qname parameter.
  -->
  <xsl:template match="*" mode="resolve">
    <xsl:param name="qname"/>
    <xsl:variable name="ns" select="namespace::*[name() = substring-before($qname, ':')]"/>
    <xsl:variable name="local">
      <xsl:choose>
        <xsl:when test="contains($qname, ':')">
          <xsl:value-of select="substring-after($qname, ':')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$qname"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:text/>{<xsl:value-of select="$ns"/>}<xsl:text/>
    <xsl:value-of select="$local"/>
  </xsl:template>
  <!--
    Return namespace of name given as qname parameter.
  -->
  <xsl:template match="*" mode="namespace">
    <xsl:param name="qname"/>
    <xsl:value-of select="namespace::*[name() = substring-before($qname, ':')]"/>
  </xsl:template>
  <!--
    Return the local part of name given as qname parameter.
  -->
  <xsl:template match="*" mode="localName">
    <xsl:param name="qname"/>
    <xsl:choose>
      <xsl:when test="contains($qname, ':')">
        <xsl:value-of select="substring-after($qname, ':')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$qname"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--
    Returns the substring after the last occurance of a substring.
    Example:
      last-substring('a.b.c', '.') = 'c'
  -->
  <xsl:template name="last-substring">
    <xsl:param name="string"/>
    <xsl:param name="substring"/>
    <xsl:choose>
      <xsl:when test="contains($string, $substring)">
        <xsl:call-template name="last-substring">
          <xsl:with-param name="string" select="substring-after($string, $substring)"/>
          <xsl:with-param name="substring" select="$substring"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--
    Checks if a schema (or any included schema) defines any component.
    Returns a string containing "true" if any component exists.
  -->
  <xsl:template match="xs:schema" mode="hasComponents">
    <xsl:param name="processedLocations" select="/xs:schema/@targetNamespace"/>
    <xsl:choose>
      <xsl:when test="count(xs:complexType | xs:simpleType | xs:element | xs:attribute | xs:group | xs:attributeGroup | xs:redefine/xs:*) > 0">
        <xsl:text>true</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="xs:include | xs:redefine">
          <xsl:variable name="schemaLocation" select="@schemaLocation"/>
          <xsl:for-each select="document($schemaLocation)/xs:schema">
            <xsl:if test="not(contains($processedLocations, $schemaLocation))">
              <xsl:apply-templates select="." mode="hasComponents">
                <xsl:with-param name="processedLocations" select="concat($processedLocations, ' ', $schemaLocation)"/>
              </xsl:apply-templates>
            </xsl:if>
          </xsl:for-each>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!--
    - Given an attribute node containing a reference to a named definition
    - evaluate the element name of the corresponding named global definition.
    - The optional parameter ist the schema instance to search in, by default
    - the current schema. The template uses recursion to search in all included
    - or imported schemas if the reference was not found in current schema.
    - Returns one of (element, complexType, simpleType, attribute,
    - attributeGroup, group).
    - @param qname full qualified type name
    - @param referer refering attribute node
  -->
  <xsl:template match="xs:schema" mode="referenceType">
    <xsl:param name="qname"/>
    <xsl:param name="referer"/>
    <xsl:param name="processedLocations"/>
    <xsl:variable name="temp">
      <xsl:apply-templates select="." mode="referenceTypeIntern">
        <xsl:with-param name="qname" select="$qname"/>
        <xsl:with-param name="referer" select="$referer"/>
        <xsl:with-param name="processedLocations" select="$processedLocations"/>
      </xsl:apply-templates>
    </xsl:variable>
    <xsl:value-of select="substring-before($temp, ' ')"/>
  </xsl:template>
  <!--
  -->
  <xsl:template match="xs:schema" mode="referenceTypeIntern">
    <xsl:param name="qname"/>
    <xsl:param name="referer"/>
    <xsl:param name="processedLocations"/>
    <xsl:variable name="parent" select="$referer/.."/>
    <!-- try to resolve type reference in current schema -->
    <xsl:variable name="result">
      <xsl:choose>
        <!-- group references -->
        <xsl:when test="local-name($parent) = 'group' and name($referer) = 'ref'">
          <xsl:value-of select="local-name(key('modelGroupDefinitions', string($qname)) | key('modelGroupRedefinitions', string($qname)))"/>
        </xsl:when>
        <!-- element references -->
        <xsl:when test="local-name($parent) = 'element' and name($referer) = 'ref'">
          <xsl:value-of select="local-name(key('elementDeclarations', string($qname)))"/>
        </xsl:when>
        <!-- attribute references -->
        <xsl:when test="local-name($parent) = 'attribute' and name($referer) = 'ref'">
          <xsl:value-of select="local-name(key('attributeDeclarations', string($qname)))"/>
        </xsl:when>
        <!-- attributeGroup references -->
        <xsl:when test="local-name($parent) = 'attributeGroup' and name($referer) = 'ref'">
          <xsl:value-of select="local-name(key('attributeGroupDefinitions', string($qname)) | key('attributeGroupRedefinitions', string($qname)))"/>
        </xsl:when>
        <!-- type references -->
        <xsl:when test="name($referer) = 'type'">
          <xsl:value-of select="local-name(key('typeDefinitions', string($qname)) | key('typeRedefinitions', string($qname)))"/>
        </xsl:when>
        <!-- extensions and restrictions -->
        <xsl:when test="name($referer) = 'base'">
          <xsl:value-of select="local-name(key('typeDefinitions', string($qname)) | key('typeRedefinitions', string($qname)))"/>
        </xsl:when>
        <!-- list declarations -->
        <xsl:when test="name($referer) = 'itemType'">
          <xsl:value-of select="local-name(key('typeDefinitions', string($qname)) | key('typeRedefinitions', string($qname)))"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    <!-- if not found: recurse included schemas -->
    <xsl:choose>
      <xsl:when test="string($result) != ''">
        <xsl:value-of select="concat($result, ' ')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="includeResult">
          <xsl:for-each select="xs:include | xs:redefine">
            <xsl:if test="not(contains($processedLocations, concat(' ', @schemaLocation, ' ')))">
              <xsl:apply-templates select="document(@schemaLocation, .)/xs:schema" mode="referenceTypeIntern">
                <xsl:with-param name="qname" select="$qname"/>
                <xsl:with-param name="referer" select="$referer"/>
                <xsl:with-param name="processedLocations" select="concat($processedLocations, ' ', @schemaLocation, ' ')"/>
              </xsl:apply-templates>
            </xsl:if>
          </xsl:for-each>
        </xsl:variable>
        <xsl:choose>
          <!-- if not found: recurse imported schemas -->
          <xsl:when test="string($includeResult) != ''">
            <xsl:value-of select="$includeResult"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="xs:import">
              <xsl:if test="not(contains($processedLocations, concat(' ', @schemaLocation, ' ')))">
                <xsl:apply-templates select="document(@schemaLocation, .)/xs:schema" mode="referenceTypeIntern">
                  <xsl:with-param name="qname" select="$qname"/>
                  <xsl:with-param name="referer" select="$referer"/>
                  <xsl:with-param name="processedLocations" select="concat($processedLocations, ' ', @schemaLocation, ' ')"/>
                </xsl:apply-templates>
              </xsl:if>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
