/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.test;

import de.java2html.Java2Html;
import de.java2html.JavaSourceConversionSettings;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.JavaSourceConversionOptions;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;

public class Java2HtmlTest
extends TestCase {
    public void testConvertToHtml() {
        String result = Java2Html.convertToHtml("public static void main(){}");
        Java2HtmlTest.assertNotNull((Object)result);
        Java2HtmlTest.assertTrue((result.indexOf("public") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("static") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("void") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("main") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<font") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("</font>") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("public static") == -1 ? 1 : 0) != 0);
    }

    public void testConvertWithTabs() {
        String result = Java2Html.convertToHtml("public static void main(){\t\t}");
        Java2HtmlTest.assertNotNull((Object)result);
    }

    public void testConvertToHtmlPage() {
        String result = Java2Html.convertToHtmlPage("public static void main(){}");
        Java2HtmlTest.assertNotNull((Object)result);
        Java2HtmlTest.assertTrue((result.indexOf("public") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("static") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("void") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("main") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<font") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("</font>") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("public static") == -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<html>") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("</html>") != -1 ? 1 : 0) != 0);
    }

    public void testConvertBug0() {
        String result = Java2Html.convertToHtmlPage("package com.equate.core.bean;\r\n\r\npublic interface ResultBean {\r\n  \r\n}\r\n\r\n\r\n");
        Java2HtmlTest.assertNotNull((Object)result);
    }

    public void testConvertBug0Base() throws IOException {
        String javaSource = "\r\n\r\n";
        StringReader stringReader = new StringReader(javaSource);
        JavaSource source = new JavaSourceParser().parse(stringReader);
        JavaSourceIterator iterator = source.getIterator();
        JavaSourceRun run1 = iterator.getNext();
        Java2HtmlTest.assertNotNull((Object)run1);
        JavaSourceRun run2 = iterator.getNext();
        Java2HtmlTest.assertNotNull((Object)run2);
        Java2Html.convertToHtmlPage(javaSource);
    }

    public void testOptionsDefaultToNoAchor() {
        Java2HtmlTest.assertFalse((String)"By specification the html anchors must be off in default options.", (boolean)JavaSourceConversionOptions.getDefault().isAddLineAnchors());
    }

    public void testNoAnchors() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        String result = this.createHelloWorldConversionResult(options);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"1\">") == -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"2\">") == -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"3\">") == -1 ? 1 : 0) != 0);
    }

    public void testAnchors() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setAddLineAnchors(true);
        String result = this.createHelloWorldConversionResult(options);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"1\">") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"2\">") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"3\">") != -1 ? 1 : 0) != 0);
    }

    public void testAnchorPrefix() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setAddLineAnchors(true);
        options.setLineAnchorPrefix("prefix");
        String result = this.createHelloWorldConversionResult(options);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"prefix1\">") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"prefix2\">") != -1 ? 1 : 0) != 0);
        Java2HtmlTest.assertTrue((result.indexOf("<a name=\"prefix3\">") != -1 ? 1 : 0) != 0);
    }

    public void testLeftTableAlignment() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setHorizontalAlignment(HorizontalAlignment.LEFT);
        String result = this.createHelloWorldConversionResult(options);
        Java2HtmlTest.assertTrue((result.indexOf(" align=\"left\"") != -1 ? 1 : 0) != 0);
    }

    public void testCenterTableAlignment() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setHorizontalAlignment(HorizontalAlignment.CENTER);
        String result = this.createHelloWorldConversionResult(options);
        Java2HtmlTest.assertTrue((result.indexOf(" align=\"center\"") != -1 ? 1 : 0) != 0);
    }

    public void testRightTableAlignment() {
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        String result = this.createHelloWorldConversionResult(options);
        Java2HtmlTest.assertTrue((result.indexOf(" align=\"right\"") != -1 ? 1 : 0) != 0);
    }

    private String createHelloWorldConversionResult(JavaSourceConversionOptions options) {
        return Java2Html.convertToHtmlPage("public static void main(){\n System.out.println(\"Hello\");\n}", new JavaSourceConversionSettings(options));
    }
}

