/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import com.cenqua.clover.Logger;
import com.cenqua.clover.RecorderLogging;
import com.cenqua.clover.registry.Clover2Registry;
import com_cenqua_clover.CoverageRecorder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Clover {
    public static final int NO_SLICE = -1;
    private static int currentSlice = -1;
    private static long currentSliceStart = 0L;
    private static Class currentType;
    private static int typeID;
    private static Map typeIDs;
    private static final HashMap RECORDERS;
    private static final CoverageRecorder DUMMY_RECORDER;
    public static final int SLICE_START = 0;
    public static final int SLICE_END = 1;
    public static final String[] SLICE_TYPE;
    static /* synthetic */ Class class$com_cenqua_clover$Clover;

    private Clover() {
    }

    public static void globalFlush() {
        Clover.allRecordersFlush();
    }

    public static int getCurrentSlice() {
        return currentSlice;
    }

    public static Class getCurrentType() {
        return currentType;
    }

    public static long getCurrentSliceStart() {
        return currentSliceStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoverageRecorder getRecorder(char[] initChars, long dbVersion, long cfgbits, int maxDataIndex) {
        String initStr = new String(initChars);
        String recorderKey = initStr + "_" + dbVersion + "_" + cfgbits;
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            CoverageRecorder recorder = (CoverageRecorder)RECORDERS.get(recorderKey);
            if (recorder != null) {
                Logger.getInstance().debug("[found existing recorder for " + recorderKey + "]");
            } else {
                Logger.getInstance().debug("[creating new recorder for " + recorderKey + "]");
                recorder = Clover.createRecorder(initStr, dbVersion, cfgbits);
                RECORDERS.put(recorderKey, recorder);
                recorder.startRun();
            }
            if (recorder.getNumElements() < maxDataIndex) {
                Logger.getInstance().warn("CLOVER: Clover database: '" + initStr + "' is no longer valid. Required size: " + maxDataIndex + ", actual size: " + recorder.getNumElements());
                Logger.getInstance().warn("CLOVER: No coverage data will be gathered.");
                DUMMY_RECORDER.growToSize(maxDataIndex);
                return DUMMY_RECORDER;
            }
            return recorder;
        }
    }

    public static int getTypeID(Class runtimeType) {
        int result;
        Integer val = (Integer)typeIDs.get(runtimeType);
        if (val == null) {
            result = typeID++;
            typeIDs.put(runtimeType, new Integer(result));
        } else {
            result = val;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersFlush() {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.forceFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersSliceStart(Class type, int slice) {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            currentSlice = slice;
            currentSliceStart = System.currentTimeMillis();
            currentType = type;
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.sliceStart(type, currentSliceStart, slice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersSliceEnd(Class type, String method, int slice, int p, Throwable t) {
        HashMap hashMap = RECORDERS;
        synchronized (hashMap) {
            currentSlice = -1;
            long ts = System.currentTimeMillis();
            Iterator recorders = RECORDERS.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.sliceEnd(type, method, ts, slice, p, t);
            }
        }
    }

    public static CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits) {
        try {
            File infile = Clover.resolveRegistryFile(dbName);
            int numElements = Clover2Registry.readRegistryHeaderAndModeOnly(infile);
            return new CoverageRecorder(infile.getAbsolutePath(), dbVersion, numElements, cfgbits);
        }
        catch (IOException ioe) {
            Logger.getInstance().error("CLOVER: Unable to load coverage database.");
            Logger.getInstance().error("CLOVER: No coverage data will be gathered.");
            Logger.getInstance().error("CLOVER: " + ioe.getClass().getName());
            Logger.getInstance().error("CLOVER: " + ioe.getMessage());
            return new CoverageRecorder(null, 0L, 500000, cfgbits);
        }
    }

    private static File resolveRegistryFile(String dbName) {
        try {
            String initStringProp = System.getProperty("clover.initstring");
            if (initStringProp != null && initStringProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring: " + initStringProp);
                return new File(initStringProp);
            }
            String initStringBaseProp = System.getProperty("clover.initstring.basedir");
            if (initStringBaseProp != null && initStringBaseProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring basedir: " + initStringBaseProp);
                File dbFile = new File(dbName);
                return new File(initStringBaseProp, dbFile.getName());
            }
            String initStringPrefixProp = System.getProperty("clover.initstring.prefix");
            if (initStringPrefixProp != null && initStringPrefixProp.length() > 0) {
                Logger.getInstance().verbose("prepending initstring prefix: " + initStringPrefixProp);
                String newInit = initStringPrefixProp + dbName;
                if ((initStringPrefixProp.endsWith("/") || initStringPrefixProp.endsWith("\\")) && (dbName.startsWith("\\") || dbName.startsWith("/"))) {
                    newInit = initStringPrefixProp + dbName.substring(1);
                }
                return new File(newInit);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return new File(dbName);
    }

    public static String getRecordingName(int hash, String dbname, long ts) {
        return dbname + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36);
    }

    public static String getRecordingName(int typeid, int slice, int rectype, int hash, String dbname, long ts) {
        long globalSliceID = (long)typeid << 32 | (long)slice;
        return dbname + Long.toString(globalSliceID, 36) + "_" + SLICE_TYPE[rectype] + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36);
    }

    public static void l(String m) {
        Logger.getInstance().error(m);
    }

    public static void l(String m, Throwable t) {
        Logger.getInstance().error(m, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        typeID = Math.abs((int)(System.currentTimeMillis() + (long)(class$com_cenqua_clover$Clover == null ? (class$com_cenqua_clover$Clover = Clover.class$("com_cenqua_clover.Clover")) : class$com_cenqua_clover$Clover).hashCode()));
        RecorderLogging.init();
        typeIDs = Collections.synchronizedMap(new HashMap());
        RECORDERS = new HashMap();
        DUMMY_RECORDER = new CoverageRecorder(null, 0L, 50000, 0L);
        SLICE_TYPE = new String[]{"X", "Y"};
    }
}

