/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import java.util.BitSet;
import java.util.Map;
import java.util.StringTokenizer;

public class BitSetUtils {
    public static BitSet decode(String bsStr) throws IllegalArgumentException {
        BitSet res = new BitSet();
        StringTokenizer st = new StringTokenizer(bsStr, " ");
        while (st.hasMoreTokens()) {
            try {
                int i = Integer.parseInt(st.nextToken());
                res.set(i);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid BitSet encoding.");
            }
        }
        return res;
    }

    public static String encode(BitSet bs) {
        StringBuffer buf = new StringBuffer();
        String spacer = "";
        for (int i = 0; i < bs.length(); ++i) {
            if (!bs.get(i)) continue;
            buf.append(spacer);
            buf.append(i);
            spacer = " ";
        }
        buf.append(" ");
        return buf.toString();
    }

    public static int cardinality(BitSet bs) {
        int cardinality = 0;
        for (int i = 0; i < bs.length(); ++i) {
            if (!bs.get(i)) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public static BitSet moveRange(BitSet bs, int from, int to, int length) {
        BitSet res = new BitSet(Math.max(to + length, bs.length()));
        res.or(bs);
        res.clear(from, from + length);
        res.clear(to, to + length);
        int i = bs.nextSetBit(from);
        while (i >= 0 && i < from + length) {
            res.set(i - from + to);
            i = bs.nextSetBit(i + 1);
        }
        return res;
    }

    public static BitSet getMappedBitSet(BitSet bs, Map mapping) {
        BitSet res = new BitSet();
        for (int i = 0; i < bs.length(); ++i) {
            Integer mapValue;
            if (!bs.get(i) || (mapValue = (Integer)mapping.get(new Integer(i))) == null) continue;
            res.set(mapValue);
        }
        return res;
    }

    public static int[] toIntArray(BitSet bs, int size) {
        int[] result = new int[size];
        int i = bs.nextSetBit(0);
        while (i >= 0 && i < size) {
            result[i] = 1;
            i = bs.nextSetBit(i + 1);
        }
        return result;
    }

    public static BitSet fromIntArray(int[] data) {
        BitSet bitSet = new BitSet(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] <= 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public static BitSet fromInt(int bs) {
        if (bs < 0) {
            throw new IllegalArgumentException("Must supply a non-negative integer: " + bs + " < 0.");
        }
        BitSet result = new BitSet();
        int index = 0;
        while (bs > 0) {
            if (bs % 2 == 1) {
                result.set(index);
            }
            ++index;
            bs >>= 1;
        }
        return result;
    }
}

