/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.util;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.reporters.Column;
import java.util.Comparator;

public class MetricsDiffSummary {
    public static final Comparator DIFF_COMP = new Comparator(){

        public int compare(Object aObj1, Object aObj2) {
            float d2;
            if (aObj1 == null && aObj2 == null) {
                return 0;
            }
            if (aObj1 == null) {
                return -1;
            }
            if (aObj2 == null) {
                return 1;
            }
            MetricsDiffSummary ds1 = (MetricsDiffSummary)aObj1;
            MetricsDiffSummary ds2 = (MetricsDiffSummary)aObj2;
            float d1 = ds1.getPcDiff();
            if (d1 == (d2 = ds2.getPcDiff())) {
                return ds1.getName().compareTo(ds2.getName());
            }
            if (d1 > d2) {
                return 1;
            }
            return -1;
        }
    };
    private BaseClassInfo classThen;
    private BaseClassInfo classNow;
    private Number pcThen;
    private Number pcNow;
    private float diff;
    private Column column;

    public MetricsDiffSummary(BaseClassInfo classThen, BaseClassInfo classNow, Number pcThen, Number pcNow, float diff, Column column) {
        this.classThen = classThen;
        this.classNow = classNow;
        this.pcThen = pcThen;
        this.pcNow = pcNow;
        this.diff = diff;
        this.column = column;
    }

    public Column getColumn() {
        return this.column;
    }

    public String getString1() throws CloverException {
        return this.getString(this.classThen);
    }

    public String getString2() throws CloverException {
        return this.getString(this.classNow);
    }

    private String getString(BaseClassInfo clss) throws CloverException {
        Column col = this.column.copy();
        col.init(clss.getMetrics());
        return this.column.getFormat().format(col.getColumnData());
    }

    public float getPcDiff() {
        return this.diff;
    }

    public Number getPc1() {
        return this.pcThen;
    }

    public Number getPc2() {
        return this.pcNow;
    }

    public BaseClassInfo getCurrentClassInfo() {
        return this.classNow;
    }

    public String getName() {
        return this.classNow.getQualifiedName();
    }

    public String toString() {
        return this.pcThen + " " + this.getName() + " " + this.pcNow + "  (" + (this.diff >= 0.0f ? "+" : "") + this.diff + ")";
    }
}

