/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BaseProjectInfo
implements Serializable,
HasMetrics {
    private static final long serialVersionUID = 6373894439785073579L;
    protected String name;
    protected Map packages = new LinkedHashMap();
    private long version;
    private transient Map classLookup;
    private transient Map fileLookup;
    protected transient BlockMetrics rawMetrics;
    protected transient BlockMetrics metrics;
    protected transient ContextSet contextFilter;

    public BaseProjectInfo(String name) {
        this.name = name;
    }

    public List getPackages() {
        return new ArrayList(this.packages.values());
    }

    public void addPackage(BasePackageInfo pkg) {
        this.packages.put(pkg.getName(), pkg);
    }

    public BasePackageInfo getDefaultPackage() {
        return (BasePackageInfo)this.packages.get("default-pkg");
    }

    public BasePackageInfo getNamedPackage(String name) {
        if (name == null || name.length() == 0) {
            return this.getDefaultPackage();
        }
        return (BasePackageInfo)this.packages.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return this.packages.isEmpty();
    }

    public BaseClassInfo findClass(String fqcn) {
        if (this.classLookup == null) {
            this.buildClassLookupMap();
        }
        return (BaseClassInfo)this.classLookup.get(fqcn);
    }

    public BaseFileInfo findFile(String pkgPath) {
        if (this.fileLookup == null) {
            this.buildFileLookupMap();
        }
        return (BaseFileInfo)this.fileLookup.get(pkgPath);
    }

    public List getClasses(HasMetricsFilter filter) {
        if (this.classLookup == null) {
            this.buildClassLookupMap();
        }
        ArrayList<BaseClassInfo> result = new ArrayList<BaseClassInfo>();
        Iterator iterator = this.classLookup.values().iterator();
        while (iterator.hasNext()) {
            BaseClassInfo classInfo = (BaseClassInfo)iterator.next();
            if (!filter.accept(classInfo)) continue;
            result.add(classInfo);
        }
        return result;
    }

    public List getFiles(HasMetricsFilter filter) {
        if (this.fileLookup == null) {
            this.buildFileLookupMap();
        }
        ArrayList<BaseFileInfo> result = new ArrayList<BaseFileInfo>();
        Iterator iterator = this.fileLookup.values().iterator();
        while (iterator.hasNext()) {
            BaseFileInfo fileInfo = (BaseFileInfo)iterator.next();
            if (!filter.accept(fileInfo)) continue;
            result.add(fileInfo);
        }
        return result;
    }

    public List getPackages(HasMetricsFilter filter) {
        ArrayList<BasePackageInfo> result = new ArrayList<BasePackageInfo>();
        Iterator iterator = this.packages.values().iterator();
        while (iterator.hasNext()) {
            BasePackageInfo packageInfo = (BasePackageInfo)iterator.next();
            if (!filter.accept(packageInfo)) continue;
            result.add(packageInfo);
        }
        return result;
    }

    private void buildClassLookupMap() {
        final HashMap tmpClassLookup = new HashMap();
        this.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                List classes = file.getClasses();
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    BaseClassInfo info = (BaseClassInfo)it.next();
                    tmpClassLookup.put(info.getQualifiedName(), info);
                }
            }
        });
        this.classLookup = tmpClassLookup;
    }

    private void buildFileLookupMap() {
        final HashMap tmpFileLookup = new HashMap();
        this.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                tmpFileLookup.put(file.getPackagePath(), file);
            }
        });
        this.fileLookup = tmpFileLookup;
    }

    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public ContextSet getContextFilter() {
        return this.contextFilter;
    }

    public void setContextFilter(ContextSet filter) {
        this.contextFilter = filter;
        this.metrics = null;
    }

    public void visitFiles(FileInfoVisitor visitor) {
        Iterator iterator = this.packages.values().iterator();
        while (iterator.hasNext()) {
            BasePackageInfo pkgInfo = (BasePackageInfo)iterator.next();
            pkgInfo.visitFiles(visitor);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }
}

