/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.CloverToken;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.TokenListUtil;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class MethodSignature
implements Serializable {
    private static final long serialVersionUID = 2456494942827618143L;
    private Map tags = new HashMap();
    private Modifiers modifiers;
    private String name;
    private String returnType;
    private String[] paramTypes;
    private String[] throwsTypes;
    public transient String normSeqPrefix;
    public transient String normSeqSuffix;

    public MethodSignature(String name) {
        this.name = name;
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, String name, String returnType, String[] paramTypes, String[] throwsTypes) {
        this(firstToken, nameToken, lastToken, new HashMap(), new Modifiers(), name, returnType, paramTypes, throwsTypes);
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, Map tags, Modifiers modifiers, String name, String returnType, String[] paramTypes, String[] throwsTypes) {
        if (firstToken != null || lastToken != null) {
            int mods = modifiers.getModifiers();
            mods &= 0xFFFFFFFA;
            this.normSeqPrefix = Modifier.toString(mods |= 2) + (returnType != null ? " " + returnType : "") + " ";
            this.normSeqSuffix = TokenListUtil.getNormalisedSequence(nameToken.getNext(), lastToken);
        }
        this.tags = tags;
        this.modifiers = modifiers;
        this.name = name;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
        this.throwsTypes = throwsTypes;
    }

    public Map getTags() {
        return this.tags;
    }

    public int getModifiers() {
        return this.modifiers.getModifiers();
    }

    public void setModifiers(int modifiers) {
        this.modifiers.setModifiers(modifiers);
    }

    public Modifiers getFullModifiers() {
        return this.modifiers;
    }

    public Map getAnnotations() {
        return this.modifiers.getAnnotations();
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String[] getParamTypes() {
        return this.paramTypes;
    }

    public String[] getThrowsTypes() {
        return this.throwsTypes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setParamTypes(String[] paramTypes) {
        this.paramTypes = paramTypes;
    }

    public void setThrowsTypes(String[] throwsTypes) {
        this.throwsTypes = throwsTypes;
    }

    String getRenamedNormalisedSignature(String newName) {
        if (this.normSeqPrefix == null) {
            throw new IllegalStateException("This signature is not renameable.");
        }
        StringBuffer renamed = new StringBuffer();
        renamed.append(this.normSeqPrefix);
        renamed.append(" ");
        renamed.append(newName);
        renamed.append(this.normSeqSuffix);
        return renamed.toString();
    }
}

