/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.context;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.context.SimpleContext;
import com.cenqua.clover.context.StatementRegexpContext;
import com.cenqua.clover.instr.FileStructureInfo;
import com.cenqua.clover.registry.MethodInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ContextRegistry
implements Serializable {
    public static final int NO_INDEX = -1;
    public static final int CONTEXT_CLOVER_OFF = 0;
    public static final int CONTEXT_STATIC = 1;
    public static final int CONTEXT_INSTANCE = 2;
    public static final int CONTEXT_CTOR = 3;
    public static final int CONTEXT_METHOD = 4;
    public static final int CONTEXT_SWITCH = 5;
    public static final int CONTEXT_WHILE = 6;
    public static final int CONTEXT_DO = 7;
    public static final int CONTEXT_FOR = 8;
    public static final int CONTEXT_IF = 9;
    public static final int CONTEXT_ELSE = 10;
    public static final int CONTEXT_TRY = 11;
    public static final int CONTEXT_CATCH = 12;
    public static final int CONTEXT_FINALLY = 13;
    public static final int CONTEXT_SYNC = 14;
    public static final int CONTEXT_ASSERT = 15;
    public static final int CONTEXT_DEPRECATED = 16;
    public static final int CONTEXT_PRIVATE_METHOD = 17;
    public static final int CONTEXT_PROPERTY_ACCESSOR = 18;
    public static final int NEXT_INDEX = 19;
    private int nextIndex = 19;
    private static LinkedHashMap reservedContexts = new LinkedHashMap();
    private static LinkedHashMap reservedMethodContexts = new LinkedHashMap();
    private static HashSet reservedNames = new HashSet();
    private static final long serialVersionUID = 3100972174066982296L;
    private LinkedHashMap methodContexts = new LinkedHashMap();
    private LinkedHashMap statementContexts = new LinkedHashMap();
    private transient Map namedContextCache;

    public ContextRegistry() {
        this.methodContexts.putAll(reservedMethodContexts);
    }

    public int addMethodContext(MethodRegexpContext ctx) throws CloverException {
        MethodRegexpContext context = new MethodRegexpContext(ctx);
        this.checkForReservedName(context);
        int index = -1;
        index = this.removeExistingContext(context, this.statementContexts, index);
        index = this.removeExistingContext(context, this.methodContexts, index);
        if (index == -1) {
            index = this.nextIndex++;
        }
        context.setIndex(index);
        Logger.getInstance().debug("adding method context id=" + index + ", name=" + context.getName());
        ContextRegistry.addContext(this.methodContexts, context);
        return index;
    }

    private int removeExistingContext(NamedContext context, Map contexts, int index) {
        NamedContext existingContext = (NamedContext)contexts.get(context.getName());
        if (existingContext != null) {
            index = existingContext.getIndex();
            contexts.remove(context.getName());
            this.getCache().clear();
        }
        return index;
    }

    public int addStatementContext(StatementRegexpContext ctx) throws CloverException {
        StatementRegexpContext context = new StatementRegexpContext(ctx);
        this.checkForReservedName(context);
        int index = -1;
        index = this.removeExistingContext(context, this.methodContexts, index);
        index = this.removeExistingContext(context, this.statementContexts, index);
        if (index == -1) {
            index = this.nextIndex++;
        }
        context.setIndex(index);
        ContextRegistry.addContext(this.statementContexts, context);
        return index;
    }

    public List getMethodContexts() {
        return new ArrayList(this.methodContexts.values());
    }

    public List getStatementContexts() {
        return new ArrayList(this.statementContexts.values());
    }

    public List getReservedContexts() {
        return new ArrayList(reservedContexts.values());
    }

    public List getReservedMethodContexts() {
        return new ArrayList(reservedMethodContexts.values());
    }

    public ContextSet createContextSetFilter(String spec) {
        return this.createContextSetFilter(spec, false);
    }

    public ContextSet createContextSetFilter(String spec, boolean invert) {
        ContextSet result = new ContextSet(this.nextIndex);
        StringTokenizer toks = new StringTokenizer(spec, ", ");
        while (toks.hasMoreTokens()) {
            String filter = toks.nextToken();
            NamedContext context = this.getContext(filter);
            if (context != null) {
                result.set(context.getIndex());
                continue;
            }
            Logger.getInstance().warn("Ignoring unknown context filter \"" + filter + "\"");
        }
        if (invert) {
            result.flip(0, this.nextIndex);
        }
        result.set(0);
        return result;
    }

    public NamedContext getContext(String name) {
        NamedContext result = (NamedContext)reservedContexts.get(name);
        if (result == null) {
            result = (NamedContext)reservedMethodContexts.get(name);
        }
        if (result == null) {
            result = (NamedContext)this.methodContexts.get(name);
        }
        if (result == null) {
            result = (NamedContext)this.statementContexts.get(name);
        }
        return result;
    }

    public String getContextsAsString(ContextSet set) {
        if (this.getCache().containsKey(set)) {
            return (String)this.getCache().get(set);
        }
        NamedContext[] contexts = this.getContexts(set);
        StringBuffer contextString = new StringBuffer();
        String sep = "";
        for (int j = 0; j < contexts.length; ++j) {
            NamedContext context = contexts[j];
            contextString.append(sep);
            contextString.append(context.getName());
            sep = ", ";
        }
        this.getCache().put(set, contextString.toString());
        return contextString.toString();
    }

    private synchronized Map getCache() {
        if (this.namedContextCache == null) {
            this.namedContextCache = new HashMap();
        }
        return this.namedContextCache;
    }

    public NamedContext[] getContexts(ContextSet ctxSet) {
        ArrayList reservedList = new ArrayList(reservedContexts.values());
        ArrayList reservedMethodList = new ArrayList(reservedMethodContexts.values());
        List methodList = this.getMethodContexts();
        List statementList = this.getStatementContexts();
        ArrayList contexts = new ArrayList();
        int i = ctxSet.nextSetBit(0);
        while (i >= 0) {
            this.collectContextAt(reservedList, i, contexts);
            this.collectContextAt(reservedMethodList, i, contexts);
            this.collectContextAt(methodList, i, contexts);
            this.collectContextAt(statementList, i, contexts);
            i = ctxSet.nextSetBit(i + 1);
        }
        NamedContext[] namedContexts = contexts.toArray(new NamedContext[0]);
        return namedContexts;
    }

    private void collectContextAt(List reservedList, int i, List contexts) {
        Iterator iterator = reservedList.iterator();
        while (iterator.hasNext()) {
            NamedContext namedContext = (NamedContext)iterator.next();
            if (namedContext.getIndex() != i) continue;
            contexts.add(namedContext);
            break;
        }
    }

    private static void addContext(Map map, NamedContext context) {
        map.put(context.getName(), context);
    }

    public static boolean isReservedName(String name) {
        return reservedNames.contains(name);
    }

    private void checkForReservedName(NamedContext context) throws CloverException {
        if (ContextRegistry.isReservedName(context.getName())) {
            throw new CloverException("The name \"" + context.getName() + "\" is already in use by one of the builtin contexts");
        }
    }

    static {
        ContextRegistry.addContext(reservedContexts, new SimpleContext(0, "Source Directive"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(1, "static"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(3, "constructor"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(4, "method"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(5, "switch"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(6, "while"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(7, "do"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(8, "for"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(9, "if"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(10, "else"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(11, "try"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(12, "catch"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(13, "finally"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(14, "sync"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(15, "assert"));
        ContextRegistry.addContext(reservedContexts, new SimpleContext(16, "@deprecated"));
        ContextRegistry.addContext(reservedMethodContexts, new MethodRegexpContext(17, "private", Pattern.compile("(.* )?private .*")));
        ContextRegistry.addContext(reservedMethodContexts, new MethodRegexpContext(18, "property", Pattern.compile("(.* )?public .*(get|set|is)[A-Z0-9].*"), 1){

            public boolean matches(FileStructureInfo.MethodMarker methodMarker) {
                if (!super.matches(methodMarker)) {
                    return false;
                }
                MethodInfo info = methodMarker.getMethod();
                String name = info.getSignature().getName();
                String[] params = info.getSignature().getParamTypes();
                if (name.startsWith("get") || name.startsWith("is")) {
                    return params == null || params.length == 0;
                }
                return params != null && params.length == 1;
            }
        });
        reservedNames.addAll(reservedContexts.keySet());
        reservedNames.addAll(reservedMethodContexts.keySet());
    }
}

