/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.FOSFactory;
import com.cenqua.clover.Logger;
import com.cenqua.clover.util.CloverUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class CoverageRecording {
    private static Class[] REQUIRED_CLASSES = new Class[]{class$java$io$IOException == null ? (class$java$io$IOException = CoverageRecording.class$("java.io.IOException")) : class$java$io$IOException, class$java$io$DataOutputStream == null ? (class$java$io$DataOutputStream = CoverageRecording.class$("java.io.DataOutputStream")) : class$java$io$DataOutputStream, class$java$io$OutputStream == null ? (class$java$io$OutputStream = CoverageRecording.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$io$FileNotFoundException == null ? (class$java$io$FileNotFoundException = CoverageRecording.class$("java.io.FileNotFoundException")) : class$java$io$FileNotFoundException, class$java$io$BufferedOutputStream == null ? (class$java$io$BufferedOutputStream = CoverageRecording.class$("java.io.BufferedOutputStream")) : class$java$io$BufferedOutputStream, class$java$io$FileOutputStream == null ? (class$java$io$FileOutputStream = CoverageRecording.class$("java.io.FileOutputStream")) : class$java$io$FileOutputStream, class$java$util$zip$Deflater == null ? (class$java$util$zip$Deflater = CoverageRecording.class$("java.util.zip.Deflater")) : class$java$util$zip$Deflater, class$java$util$zip$DeflaterOutputStream == null ? (class$java$util$zip$DeflaterOutputStream = CoverageRecording.class$("java.util.zip.DeflaterOutputStream")) : class$java$util$zip$DeflaterOutputStream, class$com$cenqua$clover$FOSFactory == null ? (class$com$cenqua$clover$FOSFactory = CoverageRecording.class$("com.cenqua.clover.FOSFactory")) : class$com$cenqua$clover$FOSFactory};
    public static final String ALT_SUFFIX = ".1";
    public static final int FMT_INTEGER = 0;
    public static final int FMT_INTEGER_EXTRA = 1;
    private static final boolean USE_RLE_COMPRESSION = true;
    public long dbVersion;
    public long writeTS;
    public int format;
    public int[] elements;
    public long coverageSum;
    public String type;
    public String method;
    private int exitStatus = -1;
    private String stackTrace = null;
    private String exitMessage;
    private static final int RUN_MARKER = -1;
    private static final int RUN_THRESHOLD = 3;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$io$DataOutputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$io$FileNotFoundException;
    static /* synthetic */ Class class$java$io$BufferedOutputStream;
    static /* synthetic */ Class class$java$io$FileOutputStream;
    static /* synthetic */ Class class$java$util$zip$Deflater;
    static /* synthetic */ Class class$java$util$zip$DeflaterOutputStream;
    static /* synthetic */ Class class$com$cenqua$clover$FOSFactory;

    private CoverageRecording() {
    }

    private void readHeader(DataInputStream in) throws IOException {
        this.dbVersion = in.readLong();
        this.writeTS = in.readLong();
        this.format = in.readInt();
    }

    private void readData(DataInputStream in, CoverageDataSpec spec) throws IOException {
        if (this.format == 1) {
            this.type = in.readUTF().replace('$', '.');
            this.method = in.readUTF();
            this.exitStatus = in.readInt();
            if (this.exitStatus == 0) {
                this.exitMessage = in.readUTF();
                this.stackTrace = CloverUtils.transformStackTrace(in.readUTF(), spec.isFilterTraces());
            }
        }
        this.readIntData(in);
    }

    private void readIntData(DataInputStream in) throws IOException {
        int elementCount = in.readInt();
        this.elements = new int[elementCount];
        this.coverageSum = 0L;
        byte[] data = new byte[elementCount * 4];
        int read = in.read(data);
        try {
            int j = 0;
            int i = 0;
            while (i < elementCount) {
                int m;
                if ((m = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF) == -1) {
                    int c = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF;
                    int v = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF;
                    Arrays.fill(this.elements, i, i + c, v);
                    i += c;
                    this.coverageSum += (long)(c * v);
                    continue;
                }
                this.elements[i++] = m;
                this.coverageSum += (long)m;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Recording corrupt");
        }
    }

    public static CoverageRecording readFromDisk(File file, CoverageDataSpec spec) throws IOException {
        return CoverageRecording.readFromDisk(file.getParentFile(), file.getName(), spec);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static CoverageRecording readFromDisk(File dir, String file, CoverageDataSpec spec) throws IOException {
        IOException lastError;
        CoverageRecording altRec;
        CoverageRecording rec;
        FilterInputStream altIn;
        DataInputStream in;
        File alt;
        File inf;
        block30: {
            block29: {
                inf = new File(dir, file);
                alt = new File(dir, file + ALT_SUFFIX);
                in = null;
                altIn = null;
                rec = null;
                altRec = null;
                lastError = null;
                try {
                    in = new DataInputStream(CoverageRecording.createInflaterInputStream(inf));
                    rec = new CoverageRecording();
                    rec.readHeader(in);
                    Logger.getInstance().debug("Read header for " + inf);
                }
                catch (IOException e) {
                    rec = null;
                    lastError = e;
                    Logger.getInstance().verbose("Error reading header of " + inf + ": " + e + ", skipped.");
                    if (alt.exists()) break block29;
                    throw e;
                }
            }
            if (alt.exists()) {
                try {
                    altIn = new DataInputStream(CoverageRecording.createInflaterInputStream(alt));
                    altRec = new CoverageRecording();
                    altRec.readHeader((DataInputStream)altIn);
                    Logger.getInstance().debug("Read header for " + alt);
                }
                catch (IOException e) {
                    altRec = null;
                    lastError = e;
                    Logger.getInstance().verbose("Error reading header of " + alt + ": " + e + ", skipped.");
                    if (rec != null) break block30;
                    throw e;
                }
            }
        }
        if (altRec == null || rec != null && altRec.writeTS <= rec.writeTS) break block36;
        super.readData((DataInputStream)altIn, spec);
        Logger.getInstance().debug("Read data for " + alt);
        CoverageRecording e = altRec;
        Object var13_15 = null;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e22) {
            // empty catch block
        }
        try {
            if (altIn != null) {
                altIn.close();
            }
        }
        catch (IOException e22) {
            // empty catch block
        }
        {
            block36: {
                return e;
                catch (IOException e3) {
                    lastError = e3;
                    Logger.getInstance().verbose("Error reading data of " + alt + ": " + e3 + ", skipped.");
                }
            }
            if (rec == null) break block33;
            rec.readData(in, spec);
            Logger.getInstance().debug("Read data for " + inf);
            e = rec;
        }
        Object var13_16 = null;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e22) {
            // empty catch block
        }
        try {
            if (altIn != null) {
                altIn.close();
            }
        }
        catch (IOException e22) {
            // empty catch block
        }
        {
            block33: {
                return e;
                catch (IOException e2) {
                    lastError = e2;
                    Logger.getInstance().verbose("Error reading data of " + inf + ": " + e2 + ", skipped.");
                    if (altRec == null) break block33;
                    altRec.readData((DataInputStream)altIn, spec);
                    Logger.getInstance().debug("Read data for " + alt);
                    CoverageRecording coverageRecording = altRec;
                    Object var13_17 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                    try {
                        if (altIn != null) {
                            altIn.close();
                        }
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                    return coverageRecording;
                }
            }
            throw new IOException(lastError.getClass().getName());
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e22) {
                // empty catch block
            }
            try {
                if (altIn != null) {
                    altIn.close();
                }
            }
            catch (IOException e22) {}
            throw throwable;
        }
    }

    public boolean hasResult() {
        return this.exitStatus != -1;
    }

    public boolean isResultPassed() {
        return this.exitStatus == 1;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public static void flushRecordingToDisk(String dbname, long dbversion, long writeTS, int[] elements) throws IOException {
        CoverageRecording.flushRecordingToDisk(dbname, null, null, dbversion, writeTS, -1, null, null, elements);
    }

    public static void flushRecordingToDisk(String dbname, Class type, String method, long dbversion, long writeTS, int exitStatus, String exitMessage, String stackTrace, int[] elements) throws IOException {
        DataOutputStream out = new DataOutputStream(CoverageRecording.createDeflateOutputStream(dbname));
        out.writeLong(dbversion);
        out.writeLong(writeTS);
        if (type == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeUTF(type.getName());
            out.writeUTF(method);
            out.writeInt(exitStatus);
            if (exitStatus == 0) {
                CoverageRecording.writeStringData(exitMessage, out);
                CoverageRecording.writeStringData(stackTrace, out);
            }
        }
        out.writeInt(elements.length);
        CoverageRecording.rleCompress(out, elements);
        out.flush();
        out.close();
    }

    private static void writeStringData(String str, DataOutputStream out) throws IOException {
        if (str == null) {
            str = "";
        }
        out.writeUTF(str);
    }

    public static OutputStream createDeflateOutputStream(String dbName) throws FileNotFoundException {
        return new BufferedOutputStream(new DeflaterOutputStream((OutputStream)FOSFactory.newFOS(dbName), new Deflater(1), 8192));
    }

    public static InputStream createInflaterInputStream(File inf) throws FileNotFoundException {
        return new BufferedInputStream(new InflaterInputStream(new BufferedInputStream(new FileInputStream(inf))));
    }

    private static void rleCompress(DataOutputStream out, int[] elements) throws IOException {
        int ints = 0;
        int i = 0;
        boolean inRun = false;
        int runCount = 0;
        int runValue = 0;
        while (i < elements.length) {
            if (!inRun) {
                boolean startRun = true;
                runValue = elements[i];
                for (int j = 1; j < 3; ++j) {
                    if (i + j < elements.length && runValue == elements[i + j]) continue;
                    startRun = false;
                    break;
                }
                if (startRun) {
                    runCount = 3;
                    inRun = true;
                    i += runCount;
                    continue;
                }
                out.writeInt(elements[i++]);
                ++ints;
                continue;
            }
            if (runValue == elements[i]) {
                ++runCount;
                ++i;
                continue;
            }
            out.writeInt(-1);
            out.writeInt(runCount);
            out.writeInt(runValue);
            inRun = false;
            ints += 3;
        }
        if (inRun) {
            out.writeInt(-1);
            out.writeInt(runCount);
            out.writeInt(runValue);
            ints += 3;
        }
        Logger.getInstance().debug("[wrote " + elements.length + " elements as " + ints * 4 + " bytes (RLE)]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

