/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.com.cenqua.license.LicenseDecoder;
import com.cenqua.clover.CloverLicense;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.util.ClassPathUtil;
import com.cenqua.clover.util.format.ConsoleFormatter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CloverStartup {
    private static LicenseLoader licenseLoader = new LicenseFileLoader();
    private static final long MAINT_SLACK = 604800000L;
    static /* synthetic */ Class class$com$cenqua$clover$CloverStartup;

    public static void loadLicense(Logger log) {
        CloverStartup.loadLicense(log, true);
    }

    public static void loadLicense(Logger log, boolean fail) {
        long buildDate;
        CloverStartup.logVersionInfo(log);
        CloverLicense license = null;
        String licenseCert = System.getProperty("clover.license.cert");
        if (licenseCert != null) {
            try {
                license = new CloverLicense(LicenseDecoder.decodeFromCert(licenseCert));
            }
            catch (IOException e) {
                log.error("Invalid license: " + e.getMessage());
            }
        } else {
            license = licenseLoader.loadLicense(log);
        }
        if (license == null) {
            CloverStartup.terminate("Invalid or missing License.", " Please visit http://my.atlassian.com to obtain a valid license.");
            if (fail) {
                throw new RuntimeException(CloverLicenseInfo.TERMINATION_STMT + "." + CloverLicenseInfo.CONTACT_INFO_STMT);
            }
            return;
        }
        if (license.isTerminated()) {
            if (fail) {
                throw new RuntimeException(license.getTerminationStatement() + "." + license.getContactInfoStatement());
            }
            CloverStartup.terminate(null, null);
        } else {
            CloverLicenseInfo.TERMINATED = false;
        }
        if (!license.isVersionSupported("2.3.1")) {
            CloverStartup.terminate("Your license is only valid for Clover " + license.getSupportedVersions() + ". It is not valid for Clover " + "2.3.1", " Please visit http://my.atlassian.com to obtain a new license or upgrade an existing license.");
            if (fail) {
                throw new RuntimeException(CloverLicenseInfo.TERMINATION_STMT + "." + CloverLicenseInfo.CONTACT_INFO_STMT);
            }
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("MMMM dd yyyy", Locale.US);
        try {
            buildDate = df.parse("May 22 2008").getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Internal Error: could not determine build date.");
        }
        if (license.maintenanceExpires() && buildDate > license.getMaintExpiry() + 604800000L) {
            CloverStartup.terminate("Clover upgrades for your license ended " + df.format(new Date(license.getMaintExpiry())) + ", and this version of Clover was built " + "May 22 2008", " Please visit http://www.atlassian.com/clover/renew for information on upgrading your license.");
            if (fail) {
                throw new RuntimeException(CloverLicenseInfo.TERMINATION_STMT + "." + CloverLicenseInfo.CONTACT_INFO_STMT);
            }
            return;
        }
        CloverLicenseInfo.NAME = license.getLicenseName();
        CloverLicenseInfo.OWNER_STMT = license.getOwnerStatement();
        CloverLicenseInfo.PUBLIC_ID = license.getPublicID();
        CloverLicenseInfo.VERBOSE = license.isVerbose();
        CloverLicenseInfo.CONTACT_INFO_STMT = license.getContactInfoStatement();
        CloverLicenseInfo.PRE_EXPIRY_STMT = license.getPreExpiryStatement();
        CloverLicenseInfo.POST_EXPIRY_STMT = license.getPostExpiryStatement();
        CloverLicenseInfo.EXPIRED = license.isExpired();
        CloverLicenseInfo.EXPIRES = license.expires();
        CloverLicenseInfo.ALLOWED_PKG_PREFIXES = license.getAllowedPkgPrefixes();
        CloverLicenseInfo.DAYS_REMAINING = license.getDaysTillExpiry();
        CloverStartup.evaluateDaysLeft(CloverLicenseInfo.DAYS_REMAINING);
        long l = CloverLicenseInfo.PERMS = CloverLicenseInfo.TERMINATED ? 0L : license.getFeaturesSupported();
        if (!CloverLicenseInfo.EXPIRED) {
            log.info(ConsoleFormatter.format(CloverLicenseInfo.OWNER_STMT));
            if (CloverLicenseInfo.VERBOSE) {
                log.info(ConsoleFormatter.format(CloverLicenseInfo.PRE_EXPIRY_STMT));
            }
        } else {
            log.info(ConsoleFormatter.format(CloverLicenseInfo.OWNER_STMT));
            log.info(ConsoleFormatter.format(CloverLicenseInfo.POST_EXPIRY_STMT));
            log.info(ConsoleFormatter.format(CloverLicenseInfo.CONTACT_INFO_STMT));
        }
    }

    private static void terminate(String terminationStatement, String contactInfoStatement) {
        CloverLicenseInfo.TERMINATED = true;
        CloverLicenseInfo.EXPIRED = true;
        CloverLicenseInfo.EXPIRES = true;
        CloverLicenseInfo.PERMS = 0L;
        CloverLicenseInfo.NAME = null;
        CloverLicenseInfo.OWNER_STMT = null;
        CloverLicenseInfo.PUBLIC_ID = null;
        CloverLicenseInfo.VERBOSE = false;
        CloverLicenseInfo.CONTACT_INFO_STMT = null;
        CloverLicenseInfo.PRE_EXPIRY_STMT = null;
        CloverLicenseInfo.POST_EXPIRY_STMT = null;
        CloverLicenseInfo.ALLOWED_PKG_PREFIXES = null;
        CloverLicenseInfo.TERMINATION_STMT = terminationStatement;
        CloverLicenseInfo.CONTACT_INFO_STMT = contactInfoStatement;
    }

    public static void logVersionInfo(Logger log) {
        log.info("Clover Version 2.3.1, built on May 22 2008 (build-721)");
        String loadedFrom = ClassPathUtil.getCloverJarPath();
        if (loadedFrom != null) {
            log.info("Loaded from: " + loadedFrom);
        } else {
            log.debug("Couldn't determine path we were loaded from.");
        }
    }

    public static void permsCheck(long feature) {
        if (!CloverStartup.hasPermission(feature)) {
            throw new RuntimeException("Sorry, you are not licensed to use the requested feature.");
        }
    }

    public static boolean hasPermission(long feature) {
        return !CloverLicenseInfo.TERMINATED && (CloverLicenseInfo.PERMS & feature) != 0L;
    }

    public static void setLicenseLoader(LicenseLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("CloverStartup does not support a 'null' LicenseLoader.");
        }
        licenseLoader = loader;
    }

    private static void evaluateDaysLeft(long daysLeft) {
        if (daysLeft < 0L) {
            daysLeft = 0L;
        }
        String target = "$daysleft";
        StringBuffer preExpBuf = new StringBuffer();
        int length = CloverLicenseInfo.PRE_EXPIRY_STMT.length();
        int i = 0;
        while (i < length) {
            char c = CloverLicenseInfo.PRE_EXPIRY_STMT.charAt(i);
            if (c == '$' && CloverLicenseInfo.PRE_EXPIRY_STMT.substring(i).toLowerCase().startsWith(target)) {
                preExpBuf.append(daysLeft);
                i += target.length();
                continue;
            }
            preExpBuf.append(c);
            ++i;
        }
        CloverLicenseInfo.PRE_EXPIRY_STMT = preExpBuf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class LicenseFileLoader
    implements LicenseLoader {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloverLicense loadLicense(Logger log) {
            File licenseFile = null;
            String licenseFilename = System.getProperty("clover.license.path");
            if (licenseFilename != null) {
                licenseFile = new File(licenseFilename);
            } else {
                String cloverJarPath = ClassPathUtil.getCloverJarPath();
                if (cloverJarPath != null) {
                    File parentDir = new File(cloverJarPath).getParentFile();
                    licenseFile = new File(parentDir, "clover.license");
                    licenseFilename = licenseFile.getAbsolutePath();
                } else {
                    log.verbose("Couldn't determine Clover's jar path.");
                }
            }
            InputStream in = null;
            if (licenseFile != null && licenseFile.exists() && licenseFile.isFile()) {
                try {
                    in = new BufferedInputStream(new FileInputStream(licenseFile));
                    log.verbose("Loading license from: " + licenseFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.verbose("License at '" + licenseFile + "' could not be opened for reading.");
                }
            } else {
                log.verbose("License not found at '" + licenseFilename + "'");
            }
            if (in == null) {
                log.verbose("Looking for license on the classpath");
                in = (class$com$cenqua$clover$CloverStartup == null ? (class$com$cenqua$clover$CloverStartup = CloverStartup.class$("com.cenqua.clover.CloverStartup")) : class$com$cenqua$clover$CloverStartup).getResourceAsStream("/clover.license");
            }
            if (in != null) {
                CloverLicense e;
                try {
                    e = new CloverLicense(LicenseDecoder.decode(in));
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        log.error("Invalid license: " + e2.getMessage());
                    }
                }
                in.close();
                return e;
            } else {
                log.error("No license file found.");
            }
            return null;
        }
    }

    public static interface LicenseLoader {
        public static final String LICENSE_FILE_NAME = "clover.license";

        public CloverLicense loadLicense(Logger var1);
    }
}

