/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.Instrumenter;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.SourceScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CloverInstr {
    private InstrumentationConfig cfg;
    private File inDir;
    private File outDir;
    private List srcFiles = new ArrayList();
    private Logger log = Logger.getInstance();
    static /* synthetic */ Class class$com$cenqua$clover$CloverInstr;

    private CloverInstr() {
    }

    public static void main(String[] args) {
        System.exit(CloverInstr.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        CloverInstr instr = new CloverInstr();
        if (!instr.processArgs(args)) {
            return 1;
        }
        return instr.execute();
    }

    public int execute() {
        this.log = Logger.getInstance();
        Instrumenter instr = new Instrumenter(this.log, this.cfg);
        try {
            instr.startInstrumentation();
        }
        catch (CloverException e) {
            this.log.error("Could not initialise Clover: " + e.getMessage());
            return 1;
        }
        try {
            if (this.inDir != null) {
                this.srcFiles.addAll(this.scanSrcDir(this.inDir));
            }
            Iterator it = this.srcFiles.iterator();
            while (it.hasNext()) {
                String src = (String)it.next();
                instr.instrument(new File(src), this.outDir);
            }
            instr.endInstrumentation();
        }
        catch (Exception e) {
            this.log.error("Instrumentation error", e);
            return 1;
        }
        return 0;
    }

    private List scanSrcDir(final File dir) throws IOException {
        final ArrayList files = new ArrayList();
        SourceScanner scanner = new SourceScanner(dir, ".*\\.java");
        scanner.visit(new SourceScanner.Visitor(){

            public void common(String path) throws IOException {
                files.add(new File(dir, FileUtils.getNormalizedPath(path)).getAbsolutePath());
            }

            public void onlyInSrc(String path) throws IOException {
                files.add(new File(dir, FileUtils.getNormalizedPath(path)).getAbsolutePath());
            }

            public void onlyInDest(String path) {
            }
        });
        return files;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println("  USAGE: " + (class$com$cenqua$clover$CloverInstr == null ? (class$com$cenqua$clover$CloverInstr = CloverInstr.class$("com.cenqua.clover.CloverInstr")) : class$com$cenqua$clover$CloverInstr).getName() + " [OPTIONS] PARAMS [FILES...]");
        System.err.println();
        System.err.println("  PARAMS:");
        System.err.println("    -s, --srcdir <dir>\t\t Directory containing source files to be instrumented. If omitted");
        System.err.println("\t\t\t\t individual source files should be specified on the command line.");
        System.err.println();
        System.err.println("    -d, --destdir <dir>\t\t Directory where Clover should place the instrumented sources.");
        System.err.println();
        System.err.println();
        System.err.println("  OPTIONS:");
        System.err.println("    -i, --initstring <file>\t Clover initstring. This is the path to the dbfile that");
        System.err.println("\t\t\t\t will be used to construct/update to store coverage data.");
        System.err.println();
        System.err.println("    -r, --relative\t If specified, the initstring is treated as a relative path, ");
        System.err.println("\t\t\t\t rather than being converted to an absolute path.");
        System.err.println("\t\t\t\t This is useful for distributed testing environments.");
        System.err.println();
        System.err.println("    -p, --flushpolicy <policy>\t Set the flushpolicy Clover will use during coverage recording.");
        System.err.println("\t\t\t\t legal values are \"directed\",\"interval\",\"threaded\". Default is \"directed\". If");
        System.err.println("\t\t\t\t either \"interval\" or \"threaded\" policies is used, the flushinterval must also be set");
        System.err.println("\t\t\t\t using the -f option.");
        System.err.println("    -f, --flushinterval <int>\t Set the interval between flushes (in millisecs). Only applies to");
        System.err.println("\t\t\t\t \"interval\" or \"threaded\" flush policies.");
        System.err.println("    -e, --encoding <encoding>\t Set the File encoding to use when reading source files.");
        System.err.println();
        System.err.println("    --instrumentation <string>\t Set the instrumentation strategy. Valid values are \"field\" and");
        System.err.println("\t\t\t\t \"class\". Default is \"class\".");
        System.err.println();
        System.err.println("    --source <level>\t\t Set the language level for Clover to use when parsing files.");
        System.err.println();
        System.err.println("    --recordTestResults <true|false> \t If set to false, Clover will not record test results.");
        System.err.println();
        System.err.println("    --dontFullyQualifyJavaLang \t\t If set, then java.lang will not be used in instrumented source.");
        System.err.println();
        System.err.println("    -v, --verbose\t\t Enable verbose logging.");
    }

    private boolean processArgs(String[] args) {
        this.cfg = new InstrumentationConfig();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    this.cfg.setInitstring(args[++i]);
                    continue;
                }
                if (args[i].equals("-r") || args[i].equals("--relative")) {
                    this.cfg.setRelative(true);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--srcdir")) {
                    this.inDir = new File(args[++i]).getAbsoluteFile();
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--destdir")) {
                    this.outDir = new File(args[++i]).getAbsoluteFile();
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--encoding")) {
                    this.cfg.setEncoding(args[++i]);
                    continue;
                }
                if (args[i].equals("--recordTestResults")) {
                    this.cfg.setTestRewriting(Boolean.valueOf(args[++i]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("--dontFullyQualifyJavaLang")) {
                    this.cfg.setFullyQualifyJavaLang(false);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--flushpolicy")) {
                    String policy = args[++i];
                    try {
                        this.cfg.setFlushPolicyFromString(policy);
                        continue;
                    }
                    catch (CloverException e) {
                        CloverInstr.usage(e.getMessage());
                        return false;
                    }
                }
                if (args[i].equals("-f") || args[i].equals("--flushinterval")) {
                    ++i;
                    try {
                        this.cfg.setFlushInterval(Integer.parseInt(args[i]));
                        if (this.cfg.getFlushInterval() > 0) continue;
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException e) {
                        CloverInstr.usage("expecting a positive integer value for flush interval");
                        return false;
                    }
                }
                if (args[i].equals("-u") || args[i].equals("--useclass")) {
                    ++i;
                    this.log.warn("the useclass parameter has been deprecated and will be ignored.");
                    continue;
                }
                if (args[i].equals("-jdk14")) {
                    this.cfg.setSourceLevel("1.4");
                    Logger.getInstance().warn("-jdk14 is deprecated. Please use --source instead.");
                    continue;
                }
                if (args[i].equals("-jdk15")) {
                    this.cfg.setSourceLevel("1.5");
                    Logger.getInstance().warn("-jdk15 is deprecated. Please use --source instead.");
                    continue;
                }
                if (args[i].equals("--source")) {
                    this.cfg.setSourceLevel(args[++i]);
                    continue;
                }
                if (args[i].equals("--instrumentation")) {
                    String instr = args[++i];
                    this.cfg.setInstrStrategy(instr);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (!args[i].endsWith(".java")) continue;
                this.srcFiles.add(args[i]);
            }
            if (this.cfg.getInitString() == null) {
                try {
                    this.cfg.createDefaultInitStringDir();
                }
                catch (CloverException e) {
                    CloverInstr.usage("No --initstring value supplied, and default location could not be created: " + e.getMessage());
                    return false;
                }
            }
            if (this.inDir == null && this.srcFiles.size() == 0) {
                CloverInstr.usage("No source files specified");
                return false;
            }
            if (this.outDir == null) {
                CloverInstr.usage("No Destination dir specified");
                return false;
            }
            if ((this.cfg.getFlushPolicy() == 1 || this.cfg.getFlushPolicy() == 2) && this.cfg.getFlushInterval() == 0) {
                CloverInstr.usage("When using either \"interval\" or \"threaded\" flushpolicy, a flushinterval must be specified.");
                return false;
            }
            if (this.inDir != null) {
                if (this.inDir.equals(this.outDir)) {
                    CloverInstr.usage("Srcdir and destdir cannot be the same.");
                    return false;
                }
                for (File outParent = this.outDir.getParentFile(); outParent != null; outParent = outParent.getParentFile()) {
                    if (!outParent.equals(this.inDir)) continue;
                    CloverInstr.usage("Cannot specify a destdir that is a nested dir of the srcdir.");
                    return false;
                }
                if (this.cfg.getFlushPolicy() == 0 && this.cfg.getFlushInterval() != 0) {
                    this.log.warn("ignoring flushinterval since flushpolicy is directed. To specify interval flushing, use -p interval.");
                }
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CloverInstr.usage("Missing a parameter.");
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

