/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.util.introspection;

import clover.org.apache.velocity.runtime.log.Log;
import clover.org.apache.velocity.util.introspection.ClassMap;
import clover.org.apache.velocity.util.introspection.IntrospectorCache;
import clover.org.apache.velocity.util.introspection.IntrospectorCacheImpl;
import clover.org.apache.velocity.util.introspection.IntrospectorCacheListener;
import clover.org.apache.velocity.util.introspection.MethodMap;
import java.lang.reflect.Method;

public abstract class IntrospectorBase
implements IntrospectorCacheListener {
    protected final Log log;
    private final IntrospectorCache introspectorCache;

    protected IntrospectorBase(Log log) {
        this.log = log;
        this.introspectorCache = new IntrospectorCacheImpl(log);
        this.introspectorCache.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class c, String name, Object[] params) throws IllegalArgumentException, MethodMap.AmbiguousException {
        IntrospectorCache ic;
        if (c == null) {
            throw new IllegalArgumentException("class object is null!");
        }
        if (params == null) {
            throw new IllegalArgumentException("params object is null!");
        }
        ClassMap classMap = null;
        IntrospectorCache introspectorCache = ic = this.getIntrospectorCache();
        synchronized (introspectorCache) {
            classMap = ic.get(c);
            if (classMap == null) {
                classMap = ic.put(c);
            }
        }
        return classMap.findMethod(name, params);
    }

    protected IntrospectorCache getIntrospectorCache() {
        return this.introspectorCache;
    }

    protected void clearCache() {
        this.getIntrospectorCache().clear();
    }

    protected ClassMap createClassMap(Class c) {
        return this.getIntrospectorCache().put(c);
    }

    protected ClassMap lookupClassMap(Class c) {
        return this.getIntrospectorCache().get(c);
    }

    public void triggerClear() {
    }

    public void triggerGet(Class c, ClassMap classMap) {
    }

    public void triggerPut(Class c, ClassMap classMap) {
    }
}

