/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.bytes.ByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractReference2ByteSortedMap;
import clover.it.unimi.dsi.fastutil.objects.AbstractReferenceSortedSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import clover.it.unimi.dsi.fastutil.objects.Reference2ByteMap;
import clover.it.unimi.dsi.fastutil.objects.Reference2ByteSortedMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSet;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Reference2ByteLinkedOpenHashMap
extends AbstractReference2ByteSortedMap
implements Serializable,
Cloneable,
Hash,
Reference2ByteSortedMap {
    protected transient Object[] key;
    protected transient byte[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ReferenceSet keys;
    protected volatile transient ByteCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Reference2ByteLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new byte[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Reference2ByteLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Reference2ByteLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Reference2ByteLinkedOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2ByteLinkedOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Reference2ByteLinkedOpenHashMap(Reference2ByteMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Reference2ByteLinkedOpenHashMap(Reference2ByteMap m) {
        this(m, 0.75f);
    }

    public Reference2ByteLinkedOpenHashMap(Object[] k, byte[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Reference2ByteLinkedOpenHashMap(Object[] k, byte[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public byte put(Object k, byte v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            byte oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        byte v = (Byte)ov;
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            byte oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Byte(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(byte v) {
        byte[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public Object firstKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public Object lastKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public Comparator comparator() {
        return null;
    }

    public SortedMap tailMap(Object from) {
        throw new UnsupportedOperationException();
    }

    public SortedMap headMap(Object to) {
        throw new UnsupportedOperationException();
    }

    public SortedMap subMap(Object from, Object to) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public byte getByte(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public byte removeByte(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : new Byte(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return new Byte(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Reference2ByteLinkedOpenHashMap.this.findKey(e.getKey());
                    return i >= 0 && Reference2ByteLinkedOpenHashMap.this.value[i] == (Byte)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Reference2ByteLinkedOpenHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Reference2ByteLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Reference2ByteLinkedOpenHashMap.this.count;
                }

                public void clear() {
                    Reference2ByteLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                public ByteIterator byteIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Reference2ByteLinkedOpenHashMap.this.count;
                }

                public boolean contains(byte v) {
                    return Reference2ByteLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Reference2ByteLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int n = PRIMES[newP];
        Object[] objectArray = this.key;
        Object[] objectArray2 = new Object[n];
        byte[] byArray = this.value;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = this.state;
        byte[] newN = new byte[n];
        int[] key = this.link;
        int[] newKey = new int[n];
        this.first = -1;
        while (j-- != 0) {
            while (byArray3[i] != -1) {
                ++i;
            }
            Object value = objectArray[i];
            byte newValue = byArray[i];
            int state = System.identityHashCode(value) & Integer.MAX_VALUE;
            int newState = state % n;
            int link = state % (n - 2) + 1;
            if (newN[newState] != 0) {
                link = state % (n - 2) + 1;
                while (newN[newState = (newState + link) % n] != 0) {
                }
            }
            newN[newState] = -1;
            h1[newState] = value;
            k[newState] = newValue;
            int newLink = i;
            i = key[i] ^ prev;
            prev = newLink;
            if (this.first != -1) {
                int n2 = newPrev;
                newKey[n2] = newKey[n2] ^ newState;
                newKey[newState] = newPrev;
                newPrev = newState;
                continue;
            }
            newPrev = this.first = newState;
            newKey[newState] = -1;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = objectArray2;
        this.value = byArray2;
        this.state = newN;
        this.link = newKey;
        this.last = newPrev;
        if (newPrev != -1) {
            int n3 = newPrev;
            newKey[n3] = ~newKey[n3];
        }
    }

    public Object clone() {
        Reference2ByteLinkedOpenHashMap c;
        try {
            c = (Reference2ByteLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            if (this != this.key[t]) {
                j = System.identityHashCode(this.key[t]);
            }
            h += (j ^= this.value[t]);
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        byte[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeObject(key[j]);
            s.writeByte(value[j]);
        }
    }

    private void checkTable() {
        Object k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        ObjectBidirectionalIterator i = (ObjectBidirectionalIterator)this.keySet().iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.next();
            if (!this.containsKey(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = ((ReferenceSortedSet)this.keySet()).iterator(this.lastKey());
            while (n-- != 0) {
                k = i.previous();
                if (!this.containsKey(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new byte[n];
        byte[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            void h1;
            void k2i;
            Object object = s.readObject();
            byte by = s.readByte();
            int n2 = System.identityHashCode(object) & Integer.MAX_VALUE;
            int k = n2 % n;
            if (state[k] != 0) {
                int v = n2 % (n - 2) + 1;
                while (state[k = (k + v) % n] != 0) {
                }
            }
            state[k] = -1;
            key[k] = k2i;
            value[k] = h1;
            if (this.first != -1) {
                int n3 = prev;
                link[n3] = link[n3] ^ k;
                link[k] = prev;
                prev = k;
                continue;
            }
            prev = this.first = k;
            link[k] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n4 = prev;
            link[n4] = ~link[n4];
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteListIterator {
        public byte previousByte() {
            return Reference2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Object previous() {
            return new Byte(Reference2ByteLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        public byte nextByte() {
            return Reference2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Byte(Reference2ByteLinkedOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(byte v) {
            throw new UnsupportedOperationException();
        }

        public void add(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractReferenceSortedSet
    implements ReferenceSortedSet {
        private KeySet() {
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            return new KeyIterator(from);
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Reference2ByteLinkedOpenHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Reference2ByteLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Reference2ByteLinkedOpenHashMap.this.count;
            Reference2ByteLinkedOpenHashMap.this.remove(k);
            return Reference2ByteLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Reference2ByteLinkedOpenHashMap.this.clear();
        }

        public Object first() {
            if (Reference2ByteLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Reference2ByteLinkedOpenHashMap.this.key[Reference2ByteLinkedOpenHashMap.this.first];
        }

        public Object last() {
            if (Reference2ByteLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Reference2ByteLinkedOpenHashMap.this.key[Reference2ByteLinkedOpenHashMap.this.last];
        }

        public Comparator comparator() {
            return null;
        }

        public final SortedSet tailSet(Object from) {
            throw new UnsupportedOperationException();
        }

        public final SortedSet headSet(Object to) {
            throw new UnsupportedOperationException();
        }

        public final SortedSet subSet(Object from, Object to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator {
        public KeyIterator(Object k) {
            super(k);
        }

        public Object previous() {
            return Reference2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public KeyIterator() {
        }

        public Object next() {
            return Reference2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Reference2ByteLinkedOpenHashMap.this.first;
        }

        MapIterator(Object from) {
            if (Reference2ByteLinkedOpenHashMap.this.key[Reference2ByteLinkedOpenHashMap.this.last] == from) {
                this.prev = Reference2ByteLinkedOpenHashMap.this.last;
                this.index = Reference2ByteLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Reference2ByteLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Reference2ByteLinkedOpenHashMap.this.first;
                while (Reference2ByteLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = Reference2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = Reference2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public Object previous() {
            return new MapEntry(this.previousEntry());
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Reference2ByteLinkedOpenHashMap.this.state[this.curr] = 1;
            Reference2ByteLinkedOpenHashMap.this.key[this.curr] = HashCommon.REMOVED;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Reference2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Reference2ByteLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Reference2ByteLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Reference2ByteLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Reference2ByteLinkedOpenHashMap.this.link[n] = Reference2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Reference2ByteLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Reference2ByteLinkedOpenHashMap.this.link[n] = Reference2ByteLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Reference2ByteMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Reference2ByteLinkedOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Byte(Reference2ByteLinkedOpenHashMap.this.value[this.index]);
        }

        public byte getByteValue() {
            return Reference2ByteLinkedOpenHashMap.this.value[this.index];
        }

        public byte setValue(byte v) {
            byte oldValue = Reference2ByteLinkedOpenHashMap.this.value[this.index];
            Reference2ByteLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Byte(this.setValue((Byte)v));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2ByteLinkedOpenHashMap.this.key[this.index] == e.getKey() && Reference2ByteLinkedOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(Reference2ByteLinkedOpenHashMap.this.key[this.index]) ^ Reference2ByteLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Reference2ByteLinkedOpenHashMap.this.key[this.index] + "->" + Reference2ByteLinkedOpenHashMap.this.value[this.index];
        }
    }
}

