/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollections;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterators;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ObjectSets {
    private ObjectSets() {
    }

    public static ObjectSet singleton(Object element) {
        return new Singleton(element);
    }

    public static ObjectSet synchronize(ObjectSet s) {
        return new SynchronizedSet(s);
    }

    public static ObjectSet synchronize(ObjectSet s, Object sync) {
        return new SynchronizedSet(s, sync);
    }

    public static ObjectSet unmodifiable(ObjectSet s) {
        return new UnmodifiableSet(s);
    }

    public static class UnmodifiableSet
    extends ObjectCollections.UnmodifiableCollection
    implements ObjectSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(ObjectSet s) {
            super(s);
        }

        public boolean remove(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }
    }

    public static class SynchronizedSet
    extends ObjectCollections.SynchronizedCollection
    implements ObjectSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(ObjectSet s, Object sync) {
            super(s, sync);
        }

        protected SynchronizedSet(ObjectSet s) {
            super(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return ((ObjectSet)this.collection).remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }
    }

    public static class Singleton
    extends AbstractObjectSet
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object element;

        protected Singleton(Object element) {
            this.element = element;
        }

        public boolean add(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object k) {
            return k == null ? this.element == null : k.equals(this.element);
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            Object[] a = new Object[]{this.element};
            return a;
        }

        public ObjectIterator objectIterator() {
            return ObjectIterators.wrap(this.toArray());
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }
    }
}

