/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import clover.it.unimi.dsi.fastutil.chars.CharCollection;
import clover.it.unimi.dsi.fastutil.chars.CharIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObject2CharMap;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.Object2CharMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Object2CharOpenCustomHashMap
extends AbstractObject2CharMap
implements Serializable,
Cloneable,
Hash,
Object2CharMap {
    protected transient Object[] key;
    protected transient char[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ObjectSet keys;
    protected volatile transient CharCollection values;
    protected transient int growthFactor = 16;
    protected Hash.Strategy strategy;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2CharOpenCustomHashMap(int n, float f, Hash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new char[this.free];
        this.state = new byte[this.free];
    }

    public Object2CharOpenCustomHashMap(int n, Hash.Strategy strategy) {
        this(n, 0.75f, strategy);
    }

    public Object2CharOpenCustomHashMap(Hash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2CharOpenCustomHashMap(Map m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2CharOpenCustomHashMap(Map m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2CharOpenCustomHashMap(Object2CharMap m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll((Map)m);
    }

    public Object2CharOpenCustomHashMap(Object2CharMap m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2CharOpenCustomHashMap(Object[] k, char[] v, float f, Hash.Strategy strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2CharOpenCustomHashMap(Object[] k, char[] v, Hash.Strategy strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy strategy() {
        return this.strategy;
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public char put(Object k, char v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            char oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        char v = ((Character)ov).charValue();
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            char oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Character(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(char v) {
        char[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public char getChar(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public char removeChar(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : new Character(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return new Character(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2CharOpenCustomHashMap.this.findKey(e.getKey());
                    return i >= 0 && Object2CharOpenCustomHashMap.this.value[i] == ((Character)e.getValue()).charValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2CharOpenCustomHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Object2CharOpenCustomHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Object2CharOpenCustomHashMap.this.count;
                }

                public void clear() {
                    Object2CharOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                public CharIterator charIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2CharOpenCustomHashMap.this.count;
                }

                public boolean contains(char v) {
                    return Object2CharOpenCustomHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2CharOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int n = PRIMES[newP];
        Object[] objectArray = this.key;
        Object[] objectArray2 = new Object[n];
        char[] cArray = this.value;
        char[] cArray2 = new char[n];
        byte[] newN = this.state;
        byte[] key = new byte[n];
        while (j-- != 0) {
            void k2i;
            void k;
            while (newN[i] != -1) {
                ++i;
            }
            Object newKey = objectArray[i];
            void value = k[i];
            int newValue = this.strategy.hashCode(newKey) & Integer.MAX_VALUE;
            int state = newValue % k2i;
            int newState = newValue % (k2i - 2) + 1;
            if (key[state] != 0) {
                newState = newValue % (k2i - 2) + 1;
                while (key[state = (state + newState) % k2i] != 0) {
                }
            }
            key[state] = -1;
            h2[state] = newKey;
            v[state] = value;
            ++i;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = objectArray2;
        this.value = cArray2;
        this.state = key;
    }

    public Object clone() {
        Object2CharOpenCustomHashMap c;
        try {
            c = (Object2CharOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.strategy = this.strategy;
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            if (this != this.key[t]) {
                j = this.strategy.hashCode(this.key[t]);
            }
            h += (j ^= this.value[t]);
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        char[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeObject(key[j]);
            s.writeChar(value[j]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new char[n];
        char[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            void h1;
            void k2i;
            Object object = s.readObject();
            char c = s.readChar();
            int n2 = this.strategy.hashCode(object) & Integer.MAX_VALUE;
            int k = n2 % n;
            if (state[k] != 0) {
                int v = n2 % (n - 2) + 1;
                while (state[k = (k + v) % n] != 0) {
                }
            }
            state[k] = -1;
            key[k] = k2i;
            value[k] = h1;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements CharIterator {
        public char nextChar() {
            return Object2CharOpenCustomHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Character(Object2CharOpenCustomHashMap.this.value[this.nextEntry()]);
        }

        public void set(char v) {
            throw new UnsupportedOperationException();
        }

        public void add(char v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractObjectSet {
        private KeySet() {
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Object2CharOpenCustomHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Object2CharOpenCustomHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Object2CharOpenCustomHashMap.this.count;
            Object2CharOpenCustomHashMap.this.remove(k);
            return Object2CharOpenCustomHashMap.this.count != oldCount;
        }

        public void clear() {
            Object2CharOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator {
        public Object next() {
            return Object2CharOpenCustomHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Object2CharOpenCustomHashMap.this.count;
            byte[] state = Object2CharOpenCustomHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Object2CharOpenCustomHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Object2CharOpenCustomHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Object2CharOpenCustomHashMap.this.state[this.last] = 1;
            Object2CharOpenCustomHashMap.this.key[this.last] = HashCommon.REMOVED;
            --Object2CharOpenCustomHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Object2CharMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Object2CharOpenCustomHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Character(Object2CharOpenCustomHashMap.this.value[this.index]);
        }

        public char getCharValue() {
            return Object2CharOpenCustomHashMap.this.value[this.index];
        }

        public char setValue(char v) {
            char oldValue = Object2CharOpenCustomHashMap.this.value[this.index];
            Object2CharOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Character(this.setValue(((Character)v).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2CharOpenCustomHashMap.this.strategy.equals(Object2CharOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2CharOpenCustomHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return Object2CharOpenCustomHashMap.this.strategy.hashCode(Object2CharOpenCustomHashMap.this.key[this.index]) ^ Object2CharOpenCustomHashMap.this.value[this.index];
        }

        public String toString() {
            return Object2CharOpenCustomHashMap.this.key[this.index] + "->" + Object2CharOpenCustomHashMap.this.value[this.index];
        }
    }
}

