/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.LongArrays;
import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongIterators;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongOpenHashSet
extends AbstractLongSet
implements Serializable,
Cloneable,
Hash,
LongSet {
    protected transient long[] key;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public LongOpenHashSet(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new long[this.free];
        this.state = new byte[this.free];
    }

    public LongOpenHashSet(int n) {
        this(n, 0.75f);
    }

    public LongOpenHashSet() {
        this(16, 0.75f);
    }

    public LongOpenHashSet(Collection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public LongOpenHashSet(Collection c) {
        this(c, 0.75f);
    }

    public LongOpenHashSet(LongCollection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public LongOpenHashSet(LongCollection c) {
        this(c, 0.75f);
    }

    public LongOpenHashSet(LongIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextLong());
        }
    }

    public LongOpenHashSet(LongIterator i) {
        this(i, 0.75f);
    }

    public LongOpenHashSet(Iterator i, float f) {
        this(LongIterators.asLongIterator(i), f);
    }

    public LongOpenHashSet(Iterator i) {
        this(LongIterators.asLongIterator(i));
    }

    public LongOpenHashSet(long[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        LongArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public LongOpenHashSet(long[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public LongOpenHashSet(long[] a, float f) {
        this(a, 0, a.length, f);
    }

    public LongOpenHashSet(long[] a) {
        this(a, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public boolean add(long k) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            return false;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return true;
    }

    public boolean remove(long k) {
        int i = this.findKey(k);
        if (i < 0) {
            return false;
        }
        this.state[i] = 1;
        --this.count;
        return true;
    }

    public boolean contains(long k) {
        return this.findKey(k) >= 0;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
    }

    public LongIterator longIterator() {
        return new SetIterator();
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int n = PRIMES[newP];
        long[] lArray = this.key;
        long[] lArray2 = new long[n];
        byte[] byArray = this.state;
        byte[] byArray2 = new byte[n];
        while (j-- != 0) {
            void k2i;
            while (byArray[i] != -1) {
                ++i;
            }
            long newN = lArray[i];
            int newKey = HashCommon.long2int(newN) & Integer.MAX_VALUE;
            int state = newKey % k2i;
            if (byArray2[state] != 0) {
                int newState = newKey % (k2i - 2) + 1;
                while (byArray2[state = (state + newState) % k2i] != 0) {
                }
            }
            byArray2[state] = -1;
            lArray2[state] = newN;
            ++i;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = lArray2;
        this.state = byArray2;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object clone() {
        LongOpenHashSet c;
        try {
            c = (LongOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (long[])this.key.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            h += HashCommon.long2int(this.key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        LongIterator i = this.longIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            s.writeLong(i.nextLong());
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.contains(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new long[n];
        long[] key = this.key;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            void k2i;
            long l = s.readLong();
            int n2 = HashCommon.long2int(l) & Integer.MAX_VALUE;
            int k = n2 % n;
            if (state[k] != 0) {
                int n3 = n2 % (n - 2) + 1;
                while (state[k = (k + n3) % n] != 0) {
                }
            }
            state[k] = -1;
            key[k] = k2i;
        }
    }

    private class SetIterator
    extends AbstractLongIterator {
        int pos = 0;
        int last = -1;
        int c;

        private SetIterator() {
            this.c = LongOpenHashSet.this.count;
            byte[] state = LongOpenHashSet.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < LongOpenHashSet.this.state.length;
        }

        /*
         * WARNING - void declaration
         */
        public long nextLong() {
            byte[] byArray = LongOpenHashSet.this.state;
            int n = byArray.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            long state = LongOpenHashSet.this.key[this.last];
            if (--this.c != 0) {
                void retVal;
                do {
                    ++this.pos;
                } while (this.pos < n && retVal[this.pos] != -1);
            }
            return state;
        }

        public void remove() {
            if (this.last == -1 || LongOpenHashSet.this.state[this.last] != -1) {
                throw new IllegalStateException();
            }
            LongOpenHashSet.this.state[this.last] = 1;
            --LongOpenHashSet.this.count;
        }
    }
}

