/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.AbstractIndirectPriorityQueue;
import clover.it.unimi.dsi.fastutil.ints.IntArrays;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import clover.it.unimi.dsi.fastutil.longs.LongSemiIndirectHeaps;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class LongHeapSemiIndirectPriorityQueue
extends AbstractIndirectPriorityQueue {
    protected long[] refArray;
    protected int[] heap = IntArrays.EMPTY_ARRAY;
    protected int size;
    protected LongComparator c;

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int capacity, LongComparator c) {
        if (capacity > 0) {
            this.heap = new int[capacity];
        }
        this.refArray = refArray;
        this.c = c;
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, LongComparator c) {
        this(refArray, refArray.length, c);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray) {
        this(refArray, refArray.length, null);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a, int size, LongComparator c) {
        this(refArray, 0, c);
        this.heap = a;
        this.size = size;
        LongSemiIndirectHeaps.makeHeap(refArray, a, size, c);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a, LongComparator c) {
        this(refArray, a, a.length, c);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public LongHeapSemiIndirectPriorityQueue(long[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    protected final void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    protected void ensureElement(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.refArray.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is larger than or equal to reference array size (" + this.refArray.length + ")");
        }
    }

    public void enqueue(int x) {
        this.ensureElement(x);
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow((int[])this.heap, (int)(this.size + 1));
        }
        this.heap[this.size++] = x;
        LongSemiIndirectHeaps.upHeap(this.refArray, this.heap, this.size, this.size - 1, this.c);
    }

    public int dequeue() {
        this.ensureNonEmpty();
        int result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            LongSemiIndirectHeaps.downHeap(this.refArray, this.heap, this.size, 0, this.c);
        }
        return result;
    }

    public int first() {
        this.ensureNonEmpty();
        return this.heap[0];
    }

    public void changed() {
        this.ensureNonEmpty();
        LongSemiIndirectHeaps.downHeap(this.refArray, this.heap, this.size, 0, this.c);
    }

    public void allChanged() {
        LongSemiIndirectHeaps.makeHeap(this.refArray, this.heap, this.size, this.c);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = IntArrays.trim((int[])this.heap, (int)this.size);
    }

    public Comparator comparator() {
        return this.c;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(this.refArray[this.heap[i]]);
        }
        s.append("]");
        return s.toString();
    }
}

