/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLong2FloatMap;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2FloatMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Long2FloatOpenHashMap
extends AbstractLong2FloatMap
implements Serializable,
Cloneable,
Hash,
Long2FloatMap {
    protected transient long[] key;
    protected transient float[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient LongSet keys;
    protected volatile transient FloatCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Long2FloatOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new long[this.free];
        this.value = new float[this.free];
        this.state = new byte[this.free];
    }

    public Long2FloatOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Long2FloatOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2FloatOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2FloatOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Long2FloatOpenHashMap(Long2FloatMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Long2FloatOpenHashMap(Long2FloatMap m) {
        this(m, 0.75f);
    }

    public Long2FloatOpenHashMap(long[] k, float[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2FloatOpenHashMap(long[] k, float[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public float put(long k, float v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            float oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        float v = ((Float)ov).floatValue();
        long k = (Long)ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            float oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Float(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(float v) {
        float[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
    }

    public boolean containsKey(long k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public float get(long k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public float remove(long k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey((Long)ok);
        return i < 0 ? null : new Float(this.value[i]);
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return new Float(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Long2FloatOpenHashMap.this.findKey((Long)e.getKey());
                    return i >= 0 && Long2FloatOpenHashMap.this.value[i] == ((Float)e.getValue()).floatValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Long2FloatOpenHashMap.this.findKey((Long)e.getKey());
                    if (i >= 0) {
                        Long2FloatOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Long2FloatOpenHashMap.this.count;
                }

                public void clear() {
                    Long2FloatOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                public FloatIterator floatIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Long2FloatOpenHashMap.this.count;
                }

                public boolean contains(float v) {
                    return Long2FloatOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Long2FloatOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int n = PRIMES[newP];
        long[] lArray = this.key;
        long[] lArray2 = new long[n];
        float[] fArray = this.value;
        float[] fArray2 = new float[n];
        byte[] byArray = this.state;
        byte[] newN = new byte[n];
        while (j-- != 0) {
            void k2i;
            void k;
            while (byArray[i] != -1) {
                ++i;
            }
            long key = lArray[i];
            void value = k[i];
            int newValue = HashCommon.long2int(key) & Integer.MAX_VALUE;
            int state = newValue % k2i;
            int newState = newValue % (k2i - 2) + 1;
            if (newN[state] != 0) {
                newState = newValue % (k2i - 2) + 1;
                while (newN[state = (state + newState) % k2i] != 0) {
                }
            }
            newN[state] = -1;
            h2[state] = key;
            fArray2[state] = value;
            ++i;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = lArray2;
        this.value = fArray2;
        this.state = newN;
    }

    public Object clone() {
        Long2FloatOpenHashMap c;
        try {
            c = (Long2FloatOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (long[])this.key.clone();
        c.value = (float[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            j = HashCommon.long2int(this.key[t]);
            h += (j ^= HashCommon.float2int(this.value[t]));
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        float[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeLong(key[j]);
            s.writeFloat(value[j]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new long[n];
        long[] key = this.key;
        this.value = new float[n];
        float[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            void k2i;
            long l = s.readLong();
            float f = s.readFloat();
            int k = HashCommon.long2int(l) & Integer.MAX_VALUE;
            int n2 = k % n;
            if (state[n2] != 0) {
                int v = k % (n - 2) + 1;
                while (state[n2 = (n2 + v) % n] != 0) {
                }
            }
            state[n2] = -1;
            key[n2] = k2i;
            value[n2] = f;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements FloatIterator {
        public float nextFloat() {
            return Long2FloatOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Float(Long2FloatOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(float v) {
            throw new UnsupportedOperationException();
        }

        public void add(float v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        public LongIterator longIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Long2FloatOpenHashMap.this.count;
        }

        public boolean contains(long k) {
            return Long2FloatOpenHashMap.this.containsKey(k);
        }

        public boolean remove(long k) {
            int oldCount = Long2FloatOpenHashMap.this.count;
            Long2FloatOpenHashMap.this.remove(k);
            return Long2FloatOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Long2FloatOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongIterator {
        public long nextLong() {
            return Long2FloatOpenHashMap.this.key[this.nextEntry()];
        }

        public Object next() {
            return new Long(Long2FloatOpenHashMap.this.key[this.nextEntry()]);
        }

        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        public void add(long k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Long2FloatOpenHashMap.this.count;
            byte[] state = Long2FloatOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Long2FloatOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Long2FloatOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Long2FloatOpenHashMap.this.state[this.last] = 1;
            --Long2FloatOpenHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Long2FloatMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return new Long(Long2FloatOpenHashMap.this.key[this.index]);
        }

        public long getLongKey() {
            return Long2FloatOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Float(Long2FloatOpenHashMap.this.value[this.index]);
        }

        public float getFloatValue() {
            return Long2FloatOpenHashMap.this.value[this.index];
        }

        public float setValue(float v) {
            float oldValue = Long2FloatOpenHashMap.this.value[this.index];
            Long2FloatOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Float(this.setValue(((Float)v).floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2FloatOpenHashMap.this.key[this.index] == (Long)e.getKey() && Long2FloatOpenHashMap.this.value[this.index] == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return HashCommon.long2int(Long2FloatOpenHashMap.this.key[this.index]) ^ HashCommon.float2int(Long2FloatOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Long2FloatOpenHashMap.this.key[this.index] + "->" + Long2FloatOpenHashMap.this.value[this.index];
        }
    }
}

