/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatIterator;
import clover.it.unimi.dsi.fastutil.floats.FloatListIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLong2FloatSortedMap;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import clover.it.unimi.dsi.fastutil.longs.Long2FloatMap;
import clover.it.unimi.dsi.fastutil.longs.Long2FloatSortedMap;
import clover.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongListIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import clover.it.unimi.dsi.fastutil.longs.LongSortedSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Long2FloatAVLTreeMap
extends AbstractLong2FloatSortedMap
implements Serializable,
Cloneable,
Long2FloatSortedMap {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected volatile transient ObjectSet entries;
    protected volatile transient LongSet keys;
    protected volatile transient FloatCollection values;
    protected transient boolean modified;
    protected Comparator storedComparator;
    protected transient LongComparator actualComparator;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;

    public Long2FloatAVLTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof LongComparator ? (LongComparator)this.storedComparator : new LongComparator(){

            public int compare(long k1, long k2) {
                return Long2FloatAVLTreeMap.this.storedComparator.compare(new Long(k1), new Long(k2));
            }

            public int compare(Object ok1, Object ok2) {
                return Long2FloatAVLTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Long2FloatAVLTreeMap(Comparator c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public Long2FloatAVLTreeMap(Map m) {
        this();
        this.putAll(m);
    }

    public Long2FloatAVLTreeMap(SortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    public Long2FloatAVLTreeMap(Long2FloatMap m) {
        this();
        this.putAll((Map)m);
    }

    public Long2FloatAVLTreeMap(Long2FloatSortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    public Long2FloatAVLTreeMap(long[] k, float[] v, Comparator c) {
        this(c);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2FloatAVLTreeMap(long[] k, float[] v) {
        this(k, v, null);
    }

    final int compare(long k1, long k2) {
        return this.actualComparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(long k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(long k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[48];
    }

    public float put(long k, float v) {
        this.modified = false;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k, v);
            this.tree = this.firstEntry;
            this.modified = true;
        } else {
            int cmp;
            Entry p = this.tree;
            Entry q = null;
            Entry y = this.tree;
            Entry z = null;
            Entry e = null;
            Entry w = null;
            boolean bl = false;
            while (true) {
                int i;
                if ((i = this.compare(k, p.key)) == 0) {
                    float oldValue = p.value;
                    p.value = v;
                    return oldValue;
                }
                if ((byte)p.info != 0) {
                    cmp = 0;
                    z = q;
                    y = p;
                }
                if (this.dirPath[cmp++] = i > 0) {
                    if (p.succ()) {
                        ++this.count;
                        e = new Entry(k, v);
                        this.modified = true;
                        if (p.right == null) {
                            this.lastEntry = e;
                        }
                        e.left = p;
                        e.right = p.right;
                        p.right(e);
                        break;
                    }
                    q = p;
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    e = new Entry(k, v);
                    this.modified = true;
                    if (p.left == null) {
                        this.firstEntry = e;
                    }
                    e.right = p;
                    e.left = p.left;
                    p.left(e);
                    break;
                }
                q = p;
                p = p.left;
            }
            p = y;
            cmp = 0;
            while (p != e) {
                if (this.dirPath[cmp]) {
                    p.incBalance();
                } else {
                    p.decBalance();
                }
                p = this.dirPath[cmp++] ? p.right : p.left;
            }
            if ((byte)y.info == -2) {
                Entry x = y.left;
                if ((byte)x.info == -1) {
                    w = x;
                    if (x.succ()) {
                        x.succ(false);
                        y.pred(x);
                    } else {
                        y.left = x.right;
                    }
                    x.right = y;
                    x.balance(0);
                    y.balance(0);
                } else {
                    w = x.right;
                    x.right = w.left;
                    w.left = x;
                    y.left = w.right;
                    w.right = y;
                    if ((byte)w.info == -1) {
                        x.balance(0);
                        y.balance(1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(-1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        x.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        y.pred(w);
                        w.succ(false);
                    }
                }
            } else if ((byte)y.info == 2) {
                Entry x = y.right;
                if ((byte)x.info == 1) {
                    w = x;
                    if (x.pred()) {
                        x.pred(false);
                        y.succ(x);
                    } else {
                        y.right = x.left;
                    }
                    x.left = y;
                    x.balance(0);
                    y.balance(0);
                } else {
                    w = x.left;
                    x.left = w.right;
                    w.right = x;
                    y.right = w.left;
                    w.left = y;
                    if ((byte)w.info == 1) {
                        x.balance(0);
                        y.balance(-1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        y.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        x.pred(w);
                        w.succ(false);
                    }
                }
            } else {
                return this.defRetValue;
            }
            if (z == null) {
                this.tree = w;
            } else if (z.left == y) {
                z.left = w;
            } else {
                z.right = w;
            }
        }
        return this.defRetValue;
    }

    private Entry parent(Entry e) {
        Entry x;
        if (e == this.tree) {
            return null;
        }
        Entry y = x = e;
        while (true) {
            if (x.succ()) {
                Entry p = x.right;
                if (p == null || p.left != e) {
                    while (!y.pred()) {
                        y = y.left;
                    }
                    p = y.left;
                }
                return p;
            }
            if (y.pred()) {
                Entry p = y.left;
                if (p == null || p.right != e) {
                    while (!x.succ()) {
                        x = x.right;
                    }
                    p = x.right;
                }
                return p;
            }
            y = y.left;
            x = x.right;
        }
    }

    public float remove(long k) {
        Entry cmp;
        int dir;
        this.modified = false;
        if (this.tree == null) {
            return this.defRetValue;
        }
        Entry entry = this.tree;
        Entry p = null;
        boolean q = false;
        while ((dir = this.compare(k, entry.key)) != 0) {
            q = dir > 0;
            if (q) {
                p = cmp;
                if ((cmp = cmp.right()) != null) continue;
                return this.defRetValue;
            }
            p = cmp;
            if ((cmp = cmp.left()) != null) continue;
            return this.defRetValue;
        }
        if (cmp.left == null) {
            this.firstEntry = cmp.next();
        }
        if (cmp.right == null) {
            this.lastEntry = cmp.prev();
        }
        if (cmp.succ()) {
            if (cmp.pred()) {
                if (p != null) {
                    if (q) {
                        p.succ(cmp.right);
                    } else {
                        p.pred(cmp.left);
                    }
                } else {
                    this.tree = q ? cmp.right : cmp.left;
                }
            } else {
                cmp.prev().right = cmp.right;
                if (p != null) {
                    if (q) {
                        p.right = cmp.left;
                    } else {
                        p.left = cmp.left;
                    }
                } else {
                    this.tree = cmp.left;
                }
            }
        } else {
            Entry r = cmp.right;
            if (r.pred()) {
                r.left = cmp.left;
                r.pred(cmp.pred());
                if (!r.pred()) {
                    r.prev().right = r;
                }
                if (p != null) {
                    if (q) {
                        p.right = r;
                    } else {
                        p.left = r;
                    }
                } else {
                    this.tree = r;
                }
                r.balance((byte)cmp.info);
                p = r;
                q = true;
            } else {
                Entry s;
                while (!(s = r.left).pred()) {
                    r = s;
                }
                if (s.succ()) {
                    r.pred(s);
                } else {
                    r.left = s.right;
                }
                s.left = cmp.left;
                if (!cmp.pred()) {
                    cmp.prev().right = s;
                    s.pred(false);
                }
                s.right = cmp.right;
                s.succ(false);
                if (p != null) {
                    if (q) {
                        p.right = s;
                    } else {
                        p.left = s;
                    }
                } else {
                    this.tree = s;
                }
                s.balance((byte)cmp.info);
                p = r;
                q = false;
            }
        }
        while (p != null) {
            Entry w;
            Entry x;
            Entry y = p;
            p = this.parent(y);
            if (!q) {
                q = p != null && p.left != y;
                y.incBalance();
                if ((byte)y.info == 1) break;
                if ((byte)y.info != 2) continue;
                x = y.right;
                if ((byte)x.info == -1) {
                    w = x.left;
                    x.left = w.right;
                    w.right = x;
                    y.right = w.left;
                    w.left = y;
                    if ((byte)w.info == 1) {
                        x.balance(0);
                        y.balance(-1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        y.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        x.pred(w);
                        w.succ(false);
                    }
                    if (p != null) {
                        if (q) {
                            p.right = w;
                            continue;
                        }
                        p.left = w;
                        continue;
                    }
                    this.tree = w;
                    continue;
                }
                if (p != null) {
                    if (q) {
                        p.right = x;
                    } else {
                        p.left = x;
                    }
                } else {
                    this.tree = x;
                }
                if ((byte)x.info == 0) {
                    y.right = x.left;
                    x.left = y;
                    x.balance(-1);
                    y.balance(1);
                    break;
                }
                if (x.pred()) {
                    y.succ(true);
                    x.pred(false);
                } else {
                    y.right = x.left;
                }
                x.left = y;
                y.balance(0);
                x.balance(0);
                continue;
            }
            q = p != null && p.left != y;
            y.decBalance();
            if ((byte)y.info == -1) break;
            if ((byte)y.info != -2) continue;
            x = y.left;
            if ((byte)x.info == 1) {
                w = x.right;
                x.right = w.left;
                w.left = x;
                y.left = w.right;
                w.right = y;
                if ((byte)w.info == -1) {
                    x.balance(0);
                    y.balance(1);
                } else if ((byte)w.info == 0) {
                    x.balance(0);
                    y.balance(0);
                } else {
                    x.balance(-1);
                    y.balance(0);
                }
                w.balance(0);
                if (w.pred()) {
                    x.succ(w);
                    w.pred(false);
                }
                if (w.succ()) {
                    y.pred(w);
                    w.succ(false);
                }
                if (p != null) {
                    if (q) {
                        p.right = w;
                        continue;
                    }
                    p.left = w;
                    continue;
                }
                this.tree = w;
                continue;
            }
            if (p != null) {
                if (q) {
                    p.right = x;
                } else {
                    p.left = x;
                }
            } else {
                this.tree = x;
            }
            if ((byte)x.info == 0) {
                y.left = x.right;
                x.right = y;
                x.balance(1);
                y.balance(-1);
                break;
            }
            if (x.succ()) {
                y.pred(true);
                x.succ(false);
            } else {
                y.left = x.right;
            }
            x.right = y;
            y.balance(0);
            x.balance(0);
        }
        this.modified = true;
        --this.count;
        return cmp.value;
    }

    public Object put(Object ok, Object ov) {
        float oldValue = this.put((Long)ok, ((Float)ov).floatValue());
        return this.modified ? null : new Float(oldValue);
    }

    public Object remove(Object ok) {
        float oldValue = this.remove((Long)ok);
        return this.modified ? new Float(oldValue) : null;
    }

    public boolean containsValue(float v) {
        TreeIterator i = new TreeIterator();
        while (i.hasNext()) {
            float ev = ((Entry)i.next()).value;
            if (ev != v) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    public boolean containsKey(long k) {
        return this.findKey(k) != null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public float get(long k) {
        Entry e = this.findKey(k);
        return e == null ? this.defRetValue : e.value;
    }

    public Object get(Object ok) {
        Entry e = this.findKey((Long)ok);
        return e == null ? null : e.getValue();
    }

    public long firstLongKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    public long lastLongKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    public Object firstKey() {
        return new Long(this.firstLongKey());
    }

    public Object lastKey() {
        return new Long(this.lastLongKey());
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new TreeIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Long2FloatAVLTreeMap.this.findKey((Long)e.getKey());
                    return ((Object)e).equals(f);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Long2FloatAVLTreeMap.this.findKey((Long)e.getKey());
                    if (f != null) {
                        Long2FloatAVLTreeMap.this.remove(f.key);
                    }
                    return f != null;
                }

                public int size() {
                    return Long2FloatAVLTreeMap.this.count;
                }

                public void clear() {
                    Long2FloatAVLTreeMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            class KeySet
            extends AbstractLongSortedSet {
                KeySet() {
                }

                public LongIterator longIterator() {
                    return new KeyIterator();
                }

                public LongBidirectionalIterator iterator(long from) {
                    return new KeyIterator(from);
                }

                public Comparator comparator() {
                    return Long2FloatAVLTreeMap.this.storedComparator;
                }

                public boolean contains(long k) {
                    return Long2FloatAVLTreeMap.this.containsKey(k);
                }

                public boolean remove(long k) {
                    Long2FloatAVLTreeMap.this.remove(k);
                    return Long2FloatAVLTreeMap.this.modified;
                }

                public int size() {
                    return Long2FloatAVLTreeMap.this.count;
                }

                public void clear() {
                    Long2FloatAVLTreeMap.this.clear();
                }

                public long firstLong() {
                    return Long2FloatAVLTreeMap.this.firstEntry.key;
                }

                public long lastLong() {
                    return Long2FloatAVLTreeMap.this.lastEntry.key;
                }

                public LongSortedSet headSet(long to) {
                    return (LongSortedSet)Long2FloatAVLTreeMap.this.headMap(to).keySet();
                }

                public LongSortedSet tailSet(long from) {
                    return (LongSortedSet)Long2FloatAVLTreeMap.this.tailMap(from).keySet();
                }

                public LongSortedSet subSet(long from, long to) {
                    return (LongSortedSet)Long2FloatAVLTreeMap.this.subMap(from, to).keySet();
                }
            }
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                public FloatIterator floatIterator() {
                    return new ValueIterator();
                }

                public boolean contains(float k) {
                    return Long2FloatAVLTreeMap.this.containsValue(k);
                }

                public int size() {
                    return Long2FloatAVLTreeMap.this.count;
                }

                public void clear() {
                    Long2FloatAVLTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Comparator comparator() {
        return this.storedComparator;
    }

    public Long2FloatSortedMap headMap(long to) {
        return new Submap(0L, true, to, false);
    }

    public Long2FloatSortedMap tailMap(long from) {
        return new Submap(from, false, 0L, true);
    }

    public Long2FloatSortedMap subMap(long from, long to) {
        return new Submap(from, false, to, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        Long2FloatAVLTreeMap c;
        try {
            c = (Long2FloatAVLTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.allocatePaths();
        if (this.count != 0) {
            void q;
            void p;
            Entry entry = new Entry();
            Entry entry2 = new Entry();
            Entry rp = entry;
            p.left(this.tree);
            Entry rq = entry2;
            q.pred(null);
            while (true) {
                Entry e;
                if (!rp.pred()) {
                    e = (Entry)rp.left.clone();
                    e.pred(rq.left);
                    e.succ(rq);
                    rq.left(e);
                    rp = rp.left;
                    rq = rq.left;
                } else {
                    while (rp.succ()) {
                        rp = rp.right;
                        if (rp == null) {
                            rq.right = null;
                            c.firstEntry = c.tree = q.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        rq = rq.right;
                    }
                    rp = rp.right;
                    rq = rq.right;
                }
                if (rp.succ()) continue;
                e = (Entry)rp.right.clone();
                e.succ(rq.right);
                e.pred(rq);
                rq.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        TreeIterator i = new TreeIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            Entry e = (Entry)i.next();
            s.writeLong(e.key);
            s.writeFloat(e.value);
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readLong(), s.readFloat());
            top.pred(pred);
            top.succ(succ);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readLong(), s.readFloat());
            top.right(new Entry(s.readLong(), s.readFloat()));
            top.right.pred(top);
            top.balance(1);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readLong();
        top.value = s.readFloat();
        top.right(this.readTree(s, rightN, top, succ));
        if (n == (n & -n)) {
            top.balance(1);
        }
        return top;
    }

    private static int checkTree(Entry e) {
        if (e == null) {
            return 0;
        }
        int leftN = Long2FloatAVLTreeMap.checkTree(e.left());
        int rightN = Long2FloatAVLTreeMap.checkTree(e.right());
        if (leftN + e.balance() != rightN) {
            throw new AssertionError((Object)("Mismatch between left tree size (" + leftN + "), right tree size (" + rightN + ") and balance (" + e.balance() + ")"));
        }
        return Math.max(leftN, rightN) + 1;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private final class Submap
    extends AbstractLong2FloatSortedMap
    implements Serializable,
    Long2FloatSortedMap {
        long from;
        long to;
        boolean bottom;
        boolean top;
        protected volatile transient ObjectSet entries;
        protected volatile transient LongSet keys;
        protected volatile transient FloatCollection values;

        public Submap(long from, boolean bottom, long to, boolean top) {
            if (!bottom && !top && Long2FloatAVLTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Long2FloatAVLTreeMap.this.defRetValue;
        }

        public void clear() {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        final boolean in(long k) {
            return !(!this.bottom && Long2FloatAVLTreeMap.this.compare(k, this.from) < 0 || !this.top && Long2FloatAVLTreeMap.this.compare(k, this.to) >= 0);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSet(){

                    public ObjectIterator objectIterator() {
                        return new SubmapIterator();
                    }

                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Long2FloatAVLTreeMap.this.findKey((Long)e.getKey());
                        return f != null && Submap.this.in(f.key) && ((Object)e).equals(f);
                    }

                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Long2FloatAVLTreeMap.this.findKey((Long)e.getKey());
                        if (f != null && Submap.this.in(f.key)) {
                            Submap.this.remove(f.key);
                        }
                        return f != null;
                    }

                    public int size() {
                        int c = 0;
                        Iterator i = this.iterator();
                        while (i.hasNext()) {
                            ++c;
                            i.next();
                        }
                        return c;
                    }

                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                class KeySet
                extends AbstractLongSortedSet
                implements LongSortedSet {
                    KeySet() {
                    }

                    public LongIterator longIterator() {
                        return new SubmapKeyIterator();
                    }

                    public LongBidirectionalIterator iterator(long from) {
                        return new SubmapKeyIterator(from);
                    }

                    public Comparator comparator() {
                        return ((Submap)Submap.this).Long2FloatAVLTreeMap.this.storedComparator;
                    }

                    public boolean contains(long k) {
                        return Submap.this.containsKey(k);
                    }

                    public boolean remove(long k) {
                        Submap.this.remove(k);
                        return ((Submap)Submap.this).Long2FloatAVLTreeMap.this.modified;
                    }

                    public int size() {
                        return Submap.this.size();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }

                    public long firstLong() {
                        return Submap.this.firstEntry().key;
                    }

                    public long lastLong() {
                        return Submap.this.lastEntry().key;
                    }

                    public LongSortedSet headSet(long to) {
                        return (LongSortedSet)Submap.this.headMap(to).keySet();
                    }

                    public LongSortedSet tailSet(long from) {
                        return (LongSortedSet)Submap.this.tailMap(from).keySet();
                    }

                    public LongSortedSet subSet(long from, long to) {
                        return (LongSortedSet)Submap.this.subMap(from, to).keySet();
                    }
                }
                this.keys = new KeySet();
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractFloatCollection(){

                    public FloatIterator floatIterator() {
                        return new SubmapValueIterator();
                    }

                    public boolean contains(float k) {
                        return Submap.this.containsValue(k);
                    }

                    public int size() {
                        return Submap.this.size();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        public boolean containsKey(long k) {
            return this.in(k) && Long2FloatAVLTreeMap.this.containsKey(k);
        }

        public boolean containsValue(float v) {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                float ev = ((Entry)i.next()).value;
                if (ev != v) continue;
                return true;
            }
            return false;
        }

        public float get(long k) {
            Entry e;
            return this.in(k) && (e = Long2FloatAVLTreeMap.this.findKey(k)) != null ? e.value : this.defRetValue;
        }

        public Object get(Object ok) {
            Entry e;
            return this.in((Long)ok) && (e = Long2FloatAVLTreeMap.this.findKey((Long)ok)) != null ? e.getValue() : null;
        }

        public float put(long k, float v) {
            Long2FloatAVLTreeMap.this.modified = false;
            if (!this.in(k)) {
                throw new IllegalArgumentException("Key (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            float oldValue = Long2FloatAVLTreeMap.this.put(k, v);
            return Long2FloatAVLTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        public Object put(Object ok, Object ov) {
            float oldValue = this.put((Long)ok, ((Float)ov).floatValue());
            return Long2FloatAVLTreeMap.this.modified ? null : new Float(oldValue);
        }

        public float remove(long k) {
            Long2FloatAVLTreeMap.this.modified = false;
            if (!this.in(k)) {
                return this.defRetValue;
            }
            float oldValue = Long2FloatAVLTreeMap.this.remove(k);
            return Long2FloatAVLTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        public Object remove(Object ok) {
            float oldValue = this.remove((Long)ok);
            return Long2FloatAVLTreeMap.this.modified ? new Float(oldValue) : null;
        }

        public int size() {
            SubmapIterator i = new SubmapIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            return n;
        }

        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        public Comparator comparator() {
            return Long2FloatAVLTreeMap.this.storedComparator;
        }

        public Long2FloatSortedMap headMap(long to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Long2FloatAVLTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        public Long2FloatSortedMap tailMap(long from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Long2FloatAVLTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        public Long2FloatSortedMap subMap(long from, long to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                long l = to = Long2FloatAVLTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                long l = from = Long2FloatAVLTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (Long2FloatAVLTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = Long2FloatAVLTreeMap.this.firstEntry;
            } else {
                e = Long2FloatAVLTreeMap.this.locateKey(this.from);
                if (Long2FloatAVLTreeMap.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && Long2FloatAVLTreeMap.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (Long2FloatAVLTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = Long2FloatAVLTreeMap.this.lastEntry;
            } else {
                e = Long2FloatAVLTreeMap.this.locateKey(this.to);
                if (Long2FloatAVLTreeMap.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && Long2FloatAVLTreeMap.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        public long firstLongKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public long lastLongKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Object firstKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        public Object lastKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements FloatListIterator {
            private SubmapValueIterator() {
            }

            public float nextFloat() {
                return this.nextEntry().value;
            }

            public float previousFloat() {
                return this.previousEntry().value;
            }

            public Object next() {
                return new Float(this.nextEntry().value);
            }

            public Object previous() {
                return new Float(this.previousEntry().value);
            }

            public void set(float v) {
                throw new UnsupportedOperationException();
            }

            public void add(float v) {
                throw new UnsupportedOperationException();
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements LongListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(long from) {
                super(from);
            }

            public long nextLong() {
                return this.nextEntry().key;
            }

            public long previousLong() {
                return this.previousEntry().key;
            }

            public Object next() {
                return new Long(this.nextEntry().key);
            }

            public Object previous() {
                return new Long(this.previousEntry().key);
            }

            public void set(long k) {
                throw new UnsupportedOperationException();
            }

            public void add(long k) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(long k) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Long2FloatAVLTreeMap.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Long2FloatAVLTreeMap.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Long2FloatAVLTreeMap.this.locateKey(k);
                if (submap.Long2FloatAVLTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Long2FloatAVLTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Long2FloatAVLTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements FloatListIterator {
        private ValueIterator() {
        }

        public float nextFloat() {
            return this.nextEntry().value;
        }

        public float previousFloat() {
            return this.previousEntry().value;
        }

        public Object next() {
            return new Float(this.nextEntry().value);
        }

        public Object previous() {
            return new Float(this.previousEntry().value);
        }

        public void set(float v) {
            throw new UnsupportedOperationException();
        }

        public void add(float v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements LongListIterator {
        public KeyIterator() {
        }

        public KeyIterator(long k) {
            super(k);
        }

        public long nextLong() {
            return this.nextEntry().key;
        }

        public long previousLong() {
            return this.previousEntry().key;
        }

        public Object next() {
            return new Long(this.nextEntry().key);
        }

        public Object previous() {
            return new Long(this.previousEntry().key);
        }

        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        public void add(long k) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator
    extends AbstractObjectListIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Long2FloatAVLTreeMap.this.firstEntry;
        }

        TreeIterator(long k) {
            this.next = Long2FloatAVLTreeMap.this.locateKey(k);
            if (this.next != null) {
                if (Long2FloatAVLTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        public Object next() {
            return this.nextEntry();
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public Object previous() {
            return this.previousEntry();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Long2FloatAVLTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry
    implements Cloneable,
    Long2FloatMap.Entry {
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        private static final int BALANCE_MASK = 255;
        long key;
        float value;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Object k, Object v) {
            this.key = (Long)k;
            this.value = ((Float)v).floatValue();
            this.info = -1073741824;
        }

        Entry(long k, float v) {
            this.key = k;
            this.value = v;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        int balance() {
            return (byte)this.info;
        }

        void balance(int level) {
            this.info &= 0xFFFFFF00;
            this.info |= level & 0xFF;
        }

        void incBalance() {
            this.info = this.info & 0xFFFFFF00 | (byte)this.info + 1 & 0xFF;
        }

        protected void decBalance() {
            this.info = this.info & 0xFFFFFF00 | (byte)this.info - 1 & 0xFF;
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Float(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Object setValue(Object value) {
            return new Float(this.setValue(((Float)value).floatValue()));
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.value = this.value;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

