/*
 * Decompiled with CFR 0.152.
 */
package clover.edu.emory.mathcs.backport.java.util.concurrent;

import clover.edu.emory.mathcs.backport.java.util.AbstractCollection;
import clover.edu.emory.mathcs.backport.java.util.AbstractMap;
import clover.edu.emory.mathcs.backport.java.util.AbstractSet;
import clover.edu.emory.mathcs.backport.java.util.Collections;
import clover.edu.emory.mathcs.backport.java.util.NavigableMap;
import clover.edu.emory.mathcs.backport.java.util.NavigableSet;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentNavigableMap;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class ConcurrentSkipListMap
extends AbstractMap
implements ConcurrentNavigableMap,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8627078645895051609L;
    private static final Random seedGenerator = new Random();
    private static final Object BASE_HEADER = new Object();
    private volatile transient HeadIndex head;
    private final Comparator comparator;
    private transient int randomSeed;
    private transient KeySet keySet;
    private transient EntrySet entrySet;
    private transient Values values;
    private transient ConcurrentNavigableMap descendingMap;
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;

    final void initialize() {
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.descendingMap = null;
        this.randomSeed = seedGenerator.nextInt() | 0x100;
        this.head = new HeadIndex(new Node(null, BASE_HEADER, null), null, null, 1);
    }

    private synchronized boolean casHead(HeadIndex cmp, HeadIndex val) {
        if (this.head == cmp) {
            this.head = val;
            return true;
        }
        return false;
    }

    private Comparable comparable(Object key) throws ClassCastException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return new ComparableUsingComparator(key, this.comparator);
        }
        return (Comparable)key;
    }

    int compare(Object k1, Object k2) throws ClassCastException {
        Comparator cmp = this.comparator;
        if (cmp != null) {
            return cmp.compare(k1, k2);
        }
        return ((Comparable)k1).compareTo(k2);
    }

    boolean inHalfOpenRange(Object key, Object least, Object fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) >= 0);
    }

    boolean inOpenRange(Object key, Object least, Object fence) {
        if (key == null) {
            throw new NullPointerException();
        }
        return !(least != null && this.compare(key, least) < 0 || fence != null && this.compare(key, fence) > 0);
    }

    private Node findPredecessor(Comparable key) {
        Index q;
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            q = this.head;
            Index r = q.right;
            while (true) {
                Index d;
                if (r != null) {
                    Node n = r.node;
                    Object k = n.key;
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (key.compareTo(k) > 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if ((d = q.down) == null) break block0;
                q = d;
                r = d.right;
            }
            break;
        }
        return q.node;
    }

    /*
     * Unable to fully structure code
     */
    private Node findNode(Comparable key) {
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0) {
                    return n;
                }
                if (c < 0) {
                    return null;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    private Object doGet(Object okey) {
        Object object;
        int c;
        Object k;
        Node n;
        Comparable key = this.comparable(okey);
        Node bound = null;
        Index q = this.head;
        Index r = q.right;
        while (true) {
            if (r != null && (n = r.node) != bound && (k = n.key) != null) {
                c = key.compareTo(k);
                if (c > 0) {
                    q = r;
                    r = r.right;
                    continue;
                }
                if (c == 0) {
                    Object object2 = n.value;
                    return object2 != null ? object2 : this.getUsingFindNode(key);
                }
                bound = n;
            }
            if ((object = q.down) == null) break;
            q = object;
            r = ((Index)object).right;
        }
        n = q.node.next;
        while (n != null) {
            k = n.key;
            if (k != null) {
                c = key.compareTo(k);
                if (c == 0) {
                    object = n.value;
                    return object != null ? object : this.getUsingFindNode(key);
                }
                if (c < 0) break;
            }
            n = n.next;
        }
        return null;
    }

    private Object getUsingFindNode(Comparable key) {
        Node n;
        Object v;
        do {
            if ((n = this.findNode(key)) != null) continue;
            return null;
        } while ((v = n.value) == null);
        return v;
    }

    private Object doPut(Object kkey, Object value, boolean onlyIfAbsent) {
        Node z;
        Comparable key = this.comparable(kkey);
        block0: while (true) {
            Node b = this.findPredecessor(key);
            Node n = b.next;
            while (n != null) {
                Node f = n.next;
                if (n != b.next) continue block0;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c > 0) {
                    b = n;
                    n = f;
                    continue;
                }
                if (c != 0) break;
                if (!onlyIfAbsent && !n.casValue(v, value)) continue block0;
                return v;
            }
            if (b.casNext(n, z = new Node(kkey, value, n))) break;
        }
        int level = this.randomLevel();
        if (level > 0) {
            this.insertIndex(z, level);
        }
        return null;
    }

    private int randomLevel() {
        int x = this.randomSeed;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        this.randomSeed = x;
        if ((x & 0x8001) != 0) {
            return 0;
        }
        int level = 1;
        while (((x >>>= 1) & 1) != 0) {
            ++level;
        }
        return level;
    }

    /*
     * WARNING - void declaration
     */
    private void insertIndex(Node z, int level) {
        HeadIndex h = this.head;
        int max = h.level;
        if (level <= max) {
            Index idx = null;
            for (int i = 1; i <= level; ++i) {
                idx = new Index(z, idx, null);
            }
            this.addIndex(idx, h, level);
        } else {
            void var9_15;
            HeadIndex oldh;
            Index[] idxs;
            block7: {
                void k;
                int oldLevel;
                HeadIndex newh;
                level = max + 1;
                idxs = new Index[level + 1];
                Index idx = null;
                for (int i = 1; i <= level; ++i) {
                    idxs[i] = idx = new Index(z, idx, null);
                }
                do {
                    oldh = this.head;
                    int n = oldh.level;
                    if (level <= n) {
                        oldLevel = level;
                        break block7;
                    }
                    newh = oldh;
                    Node oldbase = oldh.node;
                    for (void j = k + true; j <= level; ++j) {
                        newh = new HeadIndex(oldbase, newh, idxs[j], (int)j);
                    }
                } while (!this.casHead(oldh, newh));
                oldLevel = k;
            }
            this.addIndex(idxs[var9_15], oldh, (int)var9_15);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addIndex(Index idx, HeadIndex h, int indexLevel) {
        insertionLevel = indexLevel;
        key = this.comparable(idx.node.key);
        if (key == null) {
            throw new NullPointerException();
        }
        block0: while (true) {
            j = h.level;
            q = h;
            r = q.right;
            t = idx;
            while (true) {
                if (r != null) {
                    n = r.node;
                    c = key.compareTo(n.key);
                    if (n.value == null) {
                        if (!q.unlink(r)) continue block0;
                        r = q.right;
                        continue;
                    }
                    if (c > 0) {
                        q = r;
                        r = r.right;
                        continue;
                    }
                }
                if (j == insertionLevel) {
                    if (t.indexesDeletedNode()) {
                        this.findNode(key);
                        return;
                    }
                    if (q.link(r, t)) ** break;
                    continue block0;
                    if (--insertionLevel == 0) {
                        if (t.indexesDeletedNode()) {
                            this.findNode(key);
                        }
                        return;
                    }
                }
                if (--j >= insertionLevel && j < indexLevel) {
                    t = t.down;
                }
                q = q.down;
                r = q.right;
            }
            break;
        }
    }

    final Object doRemove(Object okey, Object value) {
        Object v;
        Node f;
        Node n;
        Node b;
        Comparable key = this.comparable(okey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return null;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                int c = key.compareTo(n.key);
                if (c < 0) {
                    return null;
                }
                if (c <= 0) break;
                b = n;
                n = f;
            }
            if (value != null && !value.equals(v)) {
                return null;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(key);
        } else {
            this.findPredecessor(key);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return v;
    }

    private void tryReduceLevel() {
        HeadIndex e;
        HeadIndex d;
        HeadIndex h = this.head;
        if (h.level > 3 && (d = (HeadIndex)h.down) != null && (e = (HeadIndex)d.down) != null && e.right == null && d.right == null && h.right == null && this.casHead(h, d) && h.right != null) {
            this.casHead(d, h);
        }
    }

    Node findFirst() {
        while (true) {
            Node b = this.head.node;
            Node n = b.next;
            if (n == null) {
                return null;
            }
            if (n.value != null) {
                return n;
            }
            n.helpDelete(b, n.next);
        }
    }

    Map.Entry doRemoveFirstEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        while (true) {
            b = this.head.node;
            n = b.next;
            if (n == null) {
                return null;
            }
            f = n.next;
            if (n != b.next) continue;
            v = n.value;
            if (v == null) {
                n.helpDelete(b, f);
                continue;
            }
            if (n.casValue(v, null)) break;
        }
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findFirst();
        }
        this.clearIndexToFirst();
        return new AbstractMap.SimpleImmutableEntry(n.key, v);
    }

    private void clearIndexToFirst() {
        block0: while (true) {
            Index q = this.head;
            do {
                Index r;
                if ((r = q.right) != null && r.indexesDeletedNode() && !q.unlink(r)) continue block0;
            } while ((q = q.down) != null);
            break;
        }
        if (this.head.right == null) {
            this.tryReduceLevel();
        }
    }

    Node findLast() {
        Index q = this.head;
        while (true) {
            Index index;
            if ((index = q.right) != null) {
                if (index.indexesDeletedNode()) {
                    q.unlink(index);
                    q = this.head;
                    continue;
                }
                q = index;
                continue;
            }
            Index r = q.down;
            if (r != null) {
                q = r;
                continue;
            }
            Node b = q.node;
            Node n = b.next;
            while (true) {
                if (n == null) {
                    return b.isBaseHeader() ? null : b;
                }
                Node f = n.next;
                if (n != b.next) break;
                Object v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    break;
                }
                if (v == n || b.value == null) break;
                b = n;
                n = f;
            }
            q = this.head;
        }
    }

    private Node findPredecessorOfLast() {
        Index q;
        block0: while (true) {
            q = this.head;
            while (true) {
                Index r;
                Index index;
                if ((index = q.right) != null) {
                    if (index.indexesDeletedNode()) {
                        q.unlink(index);
                        continue block0;
                    }
                    if (index.node.next != null) {
                        q = index;
                        continue;
                    }
                }
                if ((r = q.down) == null) break block0;
                q = r;
            }
            break;
        }
        return q.node;
    }

    Map.Entry doRemoveLastEntry() {
        Object v;
        Node f;
        Node n;
        Node b;
        block0: while (true) {
            b = this.findPredecessorOfLast();
            n = b.next;
            if (n == null) {
                if (!b.isBaseHeader()) continue;
                return null;
            }
            while (true) {
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v == n || b.value == null) continue block0;
                if (f == null) break;
                b = n;
                n = f;
            }
            if (n.casValue(v, null)) break;
        }
        Object key = n.key;
        Comparable ck = this.comparable(key);
        if (!n.appendMarker(f) || !b.casNext(n, f)) {
            this.findNode(ck);
        } else {
            this.findPredecessor(ck);
            if (this.head.right == null) {
                this.tryReduceLevel();
            }
        }
        return new AbstractMap.SimpleImmutableEntry(key, v);
    }

    /*
     * Unable to fully structure code
     */
    Node findNear(Object kkey, int rel) {
        key = this.comparable(kkey);
        block0: while (true) {
            b = this.findPredecessor(key);
            n = b.next;
            while (true) {
                if (n == null) {
                    return (rel & 2) == 0 || b.isBaseHeader() != false ? null : b;
                }
                f = n.next;
                if (n != b.next) continue block0;
                v = n.value;
                if (v == null) {
                    n.helpDelete(b, f);
                    continue block0;
                }
                if (v != n && b.value != null) ** break;
                continue block0;
                c = key.compareTo(n.key);
                if (c == 0 && (rel & 1) != 0 || c < 0 && (rel & 2) == 0) {
                    return n;
                }
                if (c <= 0 && (rel & 2) != 0) {
                    return b.isBaseHeader() != false ? null : b;
                }
                b = n;
                n = f;
            }
            break;
        }
    }

    AbstractMap.SimpleImmutableEntry getNear(Object key, int rel) {
        Node n;
        AbstractMap.SimpleImmutableEntry e;
        do {
            if ((n = this.findNear(key, rel)) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public ConcurrentSkipListMap() {
        this.comparator = null;
        this.initialize();
    }

    public ConcurrentSkipListMap(Comparator comparator) {
        this.comparator = comparator;
        this.initialize();
    }

    public ConcurrentSkipListMap(Map m) {
        this.comparator = null;
        this.initialize();
        this.putAll(m);
    }

    public ConcurrentSkipListMap(SortedMap m) {
        this.comparator = m.comparator();
        this.initialize();
        this.buildFromSorted(m);
    }

    public Object clone() {
        ConcurrentSkipListMap clone = null;
        try {
            clone = (ConcurrentSkipListMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.initialize();
        clone.buildFromSorted(this);
        return clone;
    }

    private void buildFromSorted(SortedMap map) {
        if (map == null) {
            throw new NullPointerException();
        }
        HeadIndex h = this.head;
        Node basepred = h.node;
        ArrayList<Index> preds = new ArrayList<Index>();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Node z;
            Map.Entry e = it.next();
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            Object k = e.getKey();
            Object v = e.getValue();
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            basepred.next = z = new Node(k, v, null);
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node n = this.findFirst();
        while (n != null) {
            Object v = n.getValidValue();
            if (v != null) {
                s.writeObject(n.key);
                s.writeObject(v);
            }
            n = n.next;
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object k;
        s.defaultReadObject();
        this.initialize();
        HeadIndex h = this.head;
        Node basepred = h.node;
        ArrayList<Index> preds = new ArrayList<Index>();
        for (int i = 0; i <= h.level; ++i) {
            preds.add(null);
        }
        Index q = h;
        for (int i = h.level; i > 0; --i) {
            preds.set(i, q);
            q = q.down;
        }
        while ((k = s.readObject()) != null) {
            Node z;
            Object v = s.readObject();
            if (v == null) {
                throw new NullPointerException();
            }
            Object key = k;
            Object val = v;
            int j = this.randomLevel();
            if (j > h.level) {
                j = h.level + 1;
            }
            basepred.next = z = new Node(key, val, null);
            basepred = z;
            if (j <= 0) continue;
            Index idx = null;
            for (int i = 1; i <= j; ++i) {
                idx = new Index(z, idx, null);
                if (i > h.level) {
                    h = new HeadIndex(h.node, h, idx, i);
                }
                if (i < preds.size()) {
                    ((Index)preds.get((int)i)).right = idx;
                    preds.set(i, idx);
                    continue;
                }
                preds.add(idx);
            }
        }
        this.head = h;
    }

    public boolean containsKey(Object key) {
        return this.doGet(key) != null;
    }

    public Object get(Object key) {
        return this.doGet(key);
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, false);
    }

    public Object remove(Object key) {
        return this.doRemove(key, null);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Node n = this.findFirst();
        while (n != null) {
            Object v = n.getValidValue();
            if (v != null && value.equals(v)) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public int size() {
        long count = 0L;
        Node n = this.findFirst();
        while (n != null) {
            if (n.getValidValue() != null) {
                ++count;
            }
            n = n.next;
        }
        return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
    }

    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    public void clear() {
        this.initialize();
    }

    public Set keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    public NavigableSet navigableKeySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet(this));
    }

    public Collection values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values(this));
    }

    public Set entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this));
    }

    public NavigableMap descendingMap() {
        ConcurrentNavigableMap dm = this.descendingMap;
        return dm != null ? dm : (this.descendingMap = new SubMap(this, null, false, null, false, true));
    }

    public NavigableSet descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        try {
            Map.Entry e;
            Iterator<Object> itr = this.entrySet().iterator();
            while (itr.hasNext()) {
                e = (Map.Entry)itr.next();
                if (e.getValue().equals(m.get(e.getKey()))) continue;
                return false;
            }
            itr = m.entrySet().iterator();
            while (itr.hasNext()) {
                e = (Map.Entry)itr.next();
                Object k = e.getKey();
                Object v = e.getValue();
                if (k != null && v != null && v.equals(this.get(k))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public Object putIfAbsent(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.doPut(key, value, true);
    }

    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        return this.doRemove(key, value) != null;
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        Comparable k = this.comparable(key);
        while (true) {
            Node n;
            if ((n = this.findNode(k)) == null) {
                return false;
            }
            Object v = n.value;
            if (v == null) continue;
            if (!oldValue.equals(v)) {
                return false;
            }
            if (n.casValue(v, newValue)) break;
        }
        return true;
    }

    public Object replace(Object key, Object value) {
        Node n;
        Object v;
        if (value == null) {
            throw new NullPointerException();
        }
        Comparable k = this.comparable(key);
        do {
            if ((n = this.findNode(k)) != null) continue;
            return null;
        } while ((v = n.value) == null || !n.casValue(v, value));
        return v;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object firstKey() {
        Node n = this.findFirst();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    public Object lastKey() {
        Node n = this.findLast();
        if (n == null) {
            throw new NoSuchElementException();
        }
        return n.key;
    }

    public NavigableMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
        if (fromKey == null || toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, fromInclusive, toKey, toInclusive, false);
    }

    public NavigableMap headMap(Object toKey, boolean inclusive) {
        if (toKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, null, false, toKey, inclusive, false);
    }

    public NavigableMap tailMap(Object fromKey, boolean inclusive) {
        if (fromKey == null) {
            throw new NullPointerException();
        }
        return new SubMap(this, fromKey, inclusive, null, false, false);
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public SortedMap headMap(Object toKey) {
        return this.headMap(toKey, false);
    }

    public SortedMap tailMap(Object fromKey) {
        return this.tailMap(fromKey, true);
    }

    public Map.Entry lowerEntry(Object key) {
        return this.getNear(key, 2);
    }

    public Object lowerKey(Object key) {
        Node n = this.findNear(key, 2);
        return n == null ? null : n.key;
    }

    public Map.Entry floorEntry(Object key) {
        return this.getNear(key, 3);
    }

    public Object floorKey(Object key) {
        Node n = this.findNear(key, 3);
        return n == null ? null : n.key;
    }

    public Map.Entry ceilingEntry(Object key) {
        return this.getNear(key, 1);
    }

    public Object ceilingKey(Object key) {
        Node n = this.findNear(key, 1);
        return n == null ? null : n.key;
    }

    public Map.Entry higherEntry(Object key) {
        return this.getNear(key, 0);
    }

    public Object higherKey(Object key) {
        Node n = this.findNear(key, 0);
        return n == null ? null : n.key;
    }

    public Map.Entry firstEntry() {
        Node n;
        AbstractMap.SimpleImmutableEntry e;
        do {
            if ((n = this.findFirst()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public Map.Entry lastEntry() {
        Node n;
        AbstractMap.SimpleImmutableEntry e;
        do {
            if ((n = this.findLast()) != null) continue;
            return null;
        } while ((e = n.createSnapshot()) == null);
        return e;
    }

    public Map.Entry pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    public Map.Entry pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    Iterator keyIterator() {
        return new KeyIterator();
    }

    Iterator valueIterator() {
        return new ValueIterator();
    }

    Iterator entryIterator() {
        return new EntryIterator();
    }

    static final List toList(Collection c) {
        ArrayList list = new ArrayList();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    static final class SubMap
    extends AbstractMap
    implements ConcurrentNavigableMap,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -7647078645895051609L;
        private final ConcurrentSkipListMap m;
        private final Object lo;
        private final Object hi;
        private final boolean loInclusive;
        private final boolean hiInclusive;
        private final boolean isDescending;
        private transient KeySet keySetView;
        private transient Set entrySetView;
        private transient Collection valuesView;

        SubMap(ConcurrentSkipListMap map, Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean isDescending) {
            if (fromKey != null && toKey != null && map.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("inconsistent range");
            }
            this.m = map;
            this.lo = fromKey;
            this.hi = toKey;
            this.loInclusive = fromInclusive;
            this.hiInclusive = toInclusive;
            this.isDescending = isDescending;
        }

        private boolean tooLow(Object key) {
            int c;
            return this.lo != null && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(Object key) {
            int c;
            return this.hi != null && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(Object key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(Object key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        private boolean isBeforeEnd(Node n) {
            if (n == null) {
                return false;
            }
            if (this.hi == null) {
                return true;
            }
            Object k = n.key;
            if (k == null) {
                return true;
            }
            int c = this.m.compare(k, this.hi);
            return c <= 0 && (c != 0 || this.hiInclusive);
        }

        private Node loNode() {
            if (this.lo == null) {
                return this.m.findFirst();
            }
            if (this.loInclusive) {
                return this.m.findNear(this.lo, 0 | 1);
            }
            return this.m.findNear(this.lo, 0);
        }

        private Node hiNode() {
            if (this.hi == null) {
                return this.m.findLast();
            }
            if (this.hiInclusive) {
                return this.m.findNear(this.hi, 2 | 1);
            }
            return this.m.findNear(this.hi, 2);
        }

        private Object lowestKey() {
            Node n = this.loNode();
            if (this.isBeforeEnd(n)) {
                return n.key;
            }
            throw new NoSuchElementException();
        }

        private Object highestKey() {
            Object last;
            Node n = this.hiNode();
            if (n != null && this.inBounds(last = n.key)) {
                return last;
            }
            throw new NoSuchElementException();
        }

        private Map.Entry lowestEntry() {
            Node n;
            AbstractMap.SimpleImmutableEntry e;
            do {
                if (this.isBeforeEnd(n = this.loNode())) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        private Map.Entry highestEntry() {
            Node n;
            AbstractMap.SimpleImmutableEntry e;
            do {
                if ((n = this.hiNode()) != null && this.inBounds(n.key)) continue;
                return null;
            } while ((e = n.createSnapshot()) == null);
            return e;
        }

        private Map.Entry removeLowest() {
            Object k;
            Object v;
            do {
                Node n;
                if ((n = this.loNode()) == null) {
                    return null;
                }
                k = n.key;
                if (this.inBounds(k)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Map.Entry removeHighest() {
            Object k;
            Object v;
            do {
                Node n;
                if ((n = this.hiNode()) == null) {
                    return null;
                }
                k = n.key;
                if (this.inBounds(k)) continue;
                return null;
            } while ((v = this.m.doRemove(k, null)) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Map.Entry getNearEntry(Object key, int rel) {
            Object k;
            Node n;
            Object v;
            if (this.isDescending) {
                rel = (rel & 2) == 0 ? (rel |= 2) : (rel &= ~2);
            }
            if (this.tooLow(key)) {
                return (rel & 2) != 0 ? null : this.lowestEntry();
            }
            if (this.tooHigh(key)) {
                return (rel & 2) != 0 ? this.highestEntry() : null;
            }
            do {
                if ((n = this.m.findNear(key, rel)) == null || !this.inBounds(n.key)) {
                    return null;
                }
                k = n.key;
            } while ((v = n.getValidValue()) == null);
            return new AbstractMap.SimpleImmutableEntry(k, v);
        }

        private Object getNearKey(Object key, int rel) {
            Object k;
            Node n;
            Object v;
            if (this.isDescending) {
                rel = (rel & 2) == 0 ? (rel |= 2) : (rel &= ~2);
            }
            if (this.tooLow(key)) {
                Node n2;
                if ((rel & 2) == 0 && this.isBeforeEnd(n2 = this.loNode())) {
                    return n2.key;
                }
                return null;
            }
            if (this.tooHigh(key)) {
                Object last;
                Node n3;
                if ((rel & 2) != 0 && (n3 = this.hiNode()) != null && this.inBounds(last = n3.key)) {
                    return last;
                }
                return null;
            }
            do {
                if ((n = this.m.findNear(key, rel)) == null || !this.inBounds(n.key)) {
                    return null;
                }
                k = n.key;
            } while ((v = n.getValidValue()) == null);
            return k;
        }

        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        public Object get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : this.m.get(k);
        }

        public Object put(Object key, Object value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        public Object remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : this.m.remove(k);
        }

        public int size() {
            long count = 0L;
            Node n = this.loNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    ++count;
                }
                n = n.next;
            }
            return count >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count;
        }

        public boolean isEmpty() {
            return !this.isBeforeEnd(this.loNode());
        }

        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Node n = this.loNode();
            while (this.isBeforeEnd(n)) {
                Object v = n.getValidValue();
                if (v != null && value.equals(v)) {
                    return true;
                }
                n = n.next;
            }
            return false;
        }

        public void clear() {
            Node n = this.loNode();
            while (this.isBeforeEnd(n)) {
                if (n.getValidValue() != null) {
                    this.m.remove(n.key);
                }
                n = n.next;
            }
        }

        public Object putIfAbsent(Object key, Object value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        public Object replace(Object key, Object value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        public Comparator comparator() {
            Comparator cmp = this.m.comparator();
            if (this.isDescending) {
                return Collections.reverseOrder(cmp);
            }
            return cmp;
        }

        private SubMap newSubMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
            if (this.isDescending) {
                Object tk = fromKey;
                fromKey = toKey;
                toKey = tk;
                boolean ti = fromInclusive;
                fromInclusive = toInclusive;
                toInclusive = ti;
            }
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    int c = this.m.compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    int c = this.m.compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap(this.m, fromKey, fromInclusive, toKey, toInclusive, this.isDescending);
        }

        public NavigableMap subMap(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        public NavigableMap headMap(Object toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        public NavigableMap tailMap(Object fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        public SortedMap headMap(Object toKey) {
            return this.headMap(toKey, false);
        }

        public SortedMap tailMap(Object fromKey) {
            return this.tailMap(fromKey, true);
        }

        public NavigableMap descendingMap() {
            return new SubMap(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive, !this.isDescending);
        }

        public Map.Entry ceilingEntry(Object key) {
            return this.getNearEntry(key, 0 | 1);
        }

        public Object ceilingKey(Object key) {
            return this.getNearKey(key, 0 | 1);
        }

        public Map.Entry lowerEntry(Object key) {
            return this.getNearEntry(key, 2);
        }

        public Object lowerKey(Object key) {
            return this.getNearKey(key, 2);
        }

        public Map.Entry floorEntry(Object key) {
            return this.getNearEntry(key, 2 | 1);
        }

        public Object floorKey(Object key) {
            return this.getNearKey(key, 2 | 1);
        }

        public Map.Entry higherEntry(Object key) {
            return this.getNearEntry(key, 0);
        }

        public Object higherKey(Object key) {
            return this.getNearKey(key, 0);
        }

        public Object firstKey() {
            return this.isDescending ? this.highestKey() : this.lowestKey();
        }

        public Object lastKey() {
            return this.isDescending ? this.lowestKey() : this.highestKey();
        }

        public Map.Entry firstEntry() {
            return this.isDescending ? this.highestEntry() : this.lowestEntry();
        }

        public Map.Entry lastEntry() {
            return this.isDescending ? this.lowestEntry() : this.highestEntry();
        }

        public Map.Entry pollFirstEntry() {
            return this.isDescending ? this.removeHighest() : this.removeLowest();
        }

        public Map.Entry pollLastEntry() {
            return this.isDescending ? this.removeLowest() : this.removeHighest();
        }

        public Set keySet() {
            KeySet ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySet(this));
        }

        public NavigableSet navigableKeySet() {
            KeySet ks = this.keySetView;
            return ks != null ? ks : (this.keySetView = new KeySet(this));
        }

        public Collection values() {
            Collection vs = this.valuesView;
            return vs != null ? vs : (this.valuesView = new Values(this));
        }

        public Set entrySet() {
            Set es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new EntrySet(this));
        }

        public NavigableSet descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        Iterator keyIterator() {
            return new SubMapKeyIterator();
        }

        Iterator valueIterator() {
            return new SubMapValueIterator();
        }

        Iterator entryIterator() {
            return new SubMapEntryIterator();
        }

        final class SubMapEntryIterator
        extends SubMapIter {
            SubMapEntryIterator() {
            }

            public Object next() {
                Node n = this.next;
                Object v = this.nextValue;
                this.advance();
                return new AbstractMap.SimpleImmutableEntry(n.key, v);
            }
        }

        final class SubMapKeyIterator
        extends SubMapIter {
            SubMapKeyIterator() {
            }

            public Object next() {
                Node n = this.next;
                this.advance();
                return n.key;
            }
        }

        final class SubMapValueIterator
        extends SubMapIter {
            SubMapValueIterator() {
            }

            public Object next() {
                Object v = this.nextValue;
                this.advance();
                return v;
            }
        }

        abstract class SubMapIter
        implements Iterator {
            Node lastReturned;
            Node next;
            Object nextValue;

            SubMapIter() {
                block3: {
                    Object x;
                    do {
                        Node node = this.next = SubMap.this.isDescending ? SubMap.this.hiNode() : SubMap.this.loNode();
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (!SubMap.this.inBounds(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = x;
                    }
                }
            }

            public final boolean hasNext() {
                return this.next != null;
            }

            final void advance() {
                this.lastReturned = this.next;
                if (this.lastReturned == null) {
                    throw new NoSuchElementException();
                }
                if (SubMap.this.isDescending) {
                    this.descend();
                } else {
                    this.ascend();
                }
            }

            private void ascend() {
                block3: {
                    Object x;
                    do {
                        this.next = this.next.next;
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (SubMap.this.tooHigh(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = x;
                    }
                }
            }

            private void descend() {
                block3: {
                    Object x;
                    do {
                        this.next = SubMap.this.m.findNear(this.lastReturned.key, 2);
                        if (this.next == null) break block3;
                    } while ((x = this.next.value) == null || x == this.next);
                    if (SubMap.this.tooLow(this.next.key)) {
                        this.next = null;
                    } else {
                        this.nextValue = x;
                    }
                }
            }

            public void remove() {
                Node l = this.lastReturned;
                if (l == null) {
                    throw new IllegalStateException();
                }
                SubMap.this.m.remove(l.key);
                this.lastReturned = null;
            }
        }
    }

    static final class EntrySet
    extends AbstractSet {
        private final ConcurrentNavigableMap m;

        EntrySet(ConcurrentNavigableMap map) {
            this.m = map;
        }

        public Iterator iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).entryIterator();
            }
            return ((SubMap)this.m).entryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = this.m.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.m.remove(e.getKey(), e.getValue());
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public int size() {
            return this.m.size();
        }

        public void clear() {
            this.m.clear();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        public Object[] toArray(Object[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }
    }

    static final class Values
    extends AbstractCollection {
        private final ConcurrentNavigableMap m;

        Values(ConcurrentNavigableMap map) {
            this.m = map;
        }

        public Iterator iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).valueIterator();
            }
            return ((SubMap)this.m).valueIterator();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public int size() {
            return this.m.size();
        }

        public boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        public void clear() {
            this.m.clear();
        }

        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        public Object[] toArray(Object[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }
    }

    static final class KeySet
    extends AbstractSet
    implements NavigableSet {
        private final ConcurrentNavigableMap m;

        KeySet(ConcurrentNavigableMap map) {
            this.m = map;
        }

        public int size() {
            return this.m.size();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        public void clear() {
            this.m.clear();
        }

        public Object lower(Object e) {
            return this.m.lowerKey(e);
        }

        public Object floor(Object e) {
            return this.m.floorKey(e);
        }

        public Object ceiling(Object e) {
            return this.m.ceilingKey(e);
        }

        public Object higher(Object e) {
            return this.m.higherKey(e);
        }

        public Comparator comparator() {
            return this.m.comparator();
        }

        public Object first() {
            return this.m.firstKey();
        }

        public Object last() {
            return this.m.lastKey();
        }

        public Object pollFirst() {
            Map.Entry e = this.m.pollFirstEntry();
            return e == null ? null : e.getKey();
        }

        public Object pollLast() {
            Map.Entry e = this.m.pollLastEntry();
            return e == null ? null : e.getKey();
        }

        public Object[] toArray() {
            return ConcurrentSkipListMap.toList(this).toArray();
        }

        public Object[] toArray(Object[] a) {
            return ConcurrentSkipListMap.toList(this).toArray(a);
        }

        public Iterator iterator() {
            if (this.m instanceof ConcurrentSkipListMap) {
                return ((ConcurrentSkipListMap)this.m).keyIterator();
            }
            return ((SubMap)this.m).keyIterator();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        public Iterator descendingIterator() {
            return this.descendingSet().iterator();
        }

        public NavigableSet subSet(Object fromElement, boolean fromInclusive, Object toElement, boolean toInclusive) {
            return new ConcurrentSkipListSet((ConcurrentNavigableMap)this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        public NavigableSet headSet(Object toElement, boolean inclusive) {
            return new ConcurrentSkipListSet((ConcurrentNavigableMap)this.m.headMap(toElement, inclusive));
        }

        public NavigableSet tailSet(Object fromElement, boolean inclusive) {
            return new ConcurrentSkipListSet((ConcurrentNavigableMap)this.m.tailMap(fromElement, inclusive));
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        public SortedSet headSet(Object toElement) {
            return this.headSet(toElement, false);
        }

        public SortedSet tailSet(Object fromElement) {
            return this.tailSet(fromElement, true);
        }

        public NavigableSet descendingSet() {
            return new ConcurrentSkipListSet((ConcurrentNavigableMap)this.m.descendingMap());
        }
    }

    final class EntryIterator
    extends Iter {
        EntryIterator() {
        }

        public Object next() {
            Node n = this.next;
            Object v = this.nextValue;
            this.advance();
            return new AbstractMap.SimpleImmutableEntry(n.key, v);
        }
    }

    final class KeyIterator
    extends Iter {
        KeyIterator() {
        }

        public Object next() {
            Node n = this.next;
            this.advance();
            return n.key;
        }
    }

    final class ValueIterator
    extends Iter {
        ValueIterator() {
        }

        public Object next() {
            Object v = this.nextValue;
            this.advance();
            return v;
        }
    }

    abstract class Iter
    implements Iterator {
        Node lastReturned;
        Node next;
        Object nextValue;

        Iter() {
            block1: {
                Object x;
                do {
                    this.next = ConcurrentSkipListMap.this.findFirst();
                    if (this.next == null) break block1;
                } while ((x = this.next.value) == null || x == this.next);
                this.nextValue = x;
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final void advance() {
            block2: {
                Object x;
                this.lastReturned = this.next;
                if (this.lastReturned == null) {
                    throw new NoSuchElementException();
                }
                do {
                    this.next = this.next.next;
                    if (this.next == null) break block2;
                } while ((x = this.next.value) == null || x == this.next);
                this.nextValue = x;
            }
        }

        public void remove() {
            Node l = this.lastReturned;
            if (l == null) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListMap.this.remove(l.key);
            this.lastReturned = null;
        }
    }

    static final class ComparableUsingComparator
    implements Comparable {
        final Object actualKey;
        final Comparator cmp;

        ComparableUsingComparator(Object key, Comparator cmp) {
            this.actualKey = key;
            this.cmp = cmp;
        }

        public int compareTo(Object k2) {
            return this.cmp.compare(this.actualKey, k2);
        }
    }

    static final class HeadIndex
    extends Index {
        final int level;

        HeadIndex(Node node, Index down, Index right, int level) {
            super(node, down, right);
            this.level = level;
        }
    }

    static class Index {
        final Node node;
        final Index down;
        volatile Index right;

        Index(Node node, Index down, Index right) {
            this.node = node;
            this.down = down;
            this.right = right;
        }

        final synchronized boolean casRight(Index cmp, Index val) {
            if (this.right == cmp) {
                this.right = val;
                return true;
            }
            return false;
        }

        final boolean indexesDeletedNode() {
            return this.node.value == null;
        }

        final boolean link(Index succ, Index newSucc) {
            Node n = this.node;
            newSucc.right = succ;
            return n.value != null && this.casRight(succ, newSucc);
        }

        final boolean unlink(Index succ) {
            return !this.indexesDeletedNode() && this.casRight(succ, succ.right);
        }
    }

    static final class Node {
        final Object key;
        volatile Object value;
        volatile Node next;

        Node(Object key, Object value, Node next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        Node(Node next) {
            this.key = null;
            this.value = this;
            this.next = next;
        }

        synchronized boolean casValue(Object cmp, Object val) {
            if (this.value == cmp) {
                this.value = val;
                return true;
            }
            return false;
        }

        synchronized boolean casNext(Node cmp, Node val) {
            if (this.next == cmp) {
                this.next = val;
                return true;
            }
            return false;
        }

        boolean isMarker() {
            return this.value == this;
        }

        boolean isBaseHeader() {
            return this.value == BASE_HEADER;
        }

        boolean appendMarker(Node f) {
            return this.casNext(f, new Node(f));
        }

        void helpDelete(Node b, Node f) {
            if (f == this.next && this == b.next) {
                if (f == null || f.value != f) {
                    this.appendMarker(f);
                } else {
                    b.casNext(this, f.next);
                }
            }
        }

        Object getValidValue() {
            Object v = this.value;
            if (v == this || v == BASE_HEADER) {
                return null;
            }
            return v;
        }

        AbstractMap.SimpleImmutableEntry createSnapshot() {
            Object v = this.getValidValue();
            if (v == null) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry(this.key, v);
        }
    }
}

