/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.pdf.Barcode;
import clover.com.lowagie.text.pdf.BaseFont;
import clover.com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;

public class BarcodeInter25
extends Barcode {
    static byte[][] BARS = new byte[][]{{0, 0, 1, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 0, 0, 1}, {1, 1, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 1, 0, 0}, {0, 1, 1, 0, 0}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {0, 1, 0, 1, 0}};

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static char getChecksum(String string) {
        int n = 3;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            int n4 = string.charAt(n3) - 48;
            n2 += n * n4;
            n ^= 2;
            --n3;
        }
        return (char)((10 - n2 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        string = BarcodeInter25.keepNumbers(string);
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        int n2 = string.length() / 2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = string.charAt(n3 * 2) - 48;
            int n5 = string.charAt(n3 * 2 + 1) - 48;
            byte[] byArray2 = BARS[n4];
            byte[] byArray3 = BARS[n5];
            int n6 = 0;
            while (n6 < 5) {
                byArray[n++] = byArray2[n6];
                byArray[n++] = byArray3[n6];
                ++n6;
            }
            ++n3;
        }
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f = this.font.getWidthPoint(string, this.size);
        }
        string = BarcodeInter25.keepNumbers(this.code);
        int n = string.length();
        if (this.generateChecksum) {
            ++n;
        }
        float f3 = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f = this.font.getWidthPoint(string, this.size);
        }
        String string2 = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string2 = string2 + BarcodeInter25.getChecksum(string2);
        }
        int n = string2.length();
        float f2 = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f2) {
                    f3 = f - f2;
                    break;
                }
                f4 = f2 - f;
                break;
            }
            default: {
                if (f > f2) {
                    f3 = (f - f2) / 2.0f;
                    break;
                }
                f4 = (f2 - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f5 = f6 + this.baseline;
            }
        }
        byte[] byArray = BarcodeInter25.getBarsInter25(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            float f7;
            float f8 = f7 = byArray[n2] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f3, f5, f7, this.barHeight);
            }
            bl = !bl;
            f3 += f7;
            ++n2;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f4, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }
}

