/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text;

import clover.com.lowagie.text.Chunk;
import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.ElementListener;
import clover.com.lowagie.text.FontFactory;
import clover.com.lowagie.text.ListItem;
import clover.com.lowagie.text.MarkupAttributes;
import clover.com.lowagie.text.TextElementArray;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class List
implements TextElementArray,
MarkupAttributes {
    private ArrayList list = new ArrayList();
    private boolean numbered;
    private boolean lettered;
    private int first = 1;
    private char firstCh = (char)65;
    private char lastCh = (char)90;
    private Chunk symbol = new Chunk("-");
    private float indentationLeft = 0.0f;
    private float indentationRight = 0.0f;
    private int symbolIndent;
    protected Properties markupAttributes;

    public List(boolean bl, int n) {
        this.numbered = bl;
        this.lettered = false;
        this.symbolIndent = n;
    }

    public List(boolean bl, boolean bl2, int n) {
        this.numbered = bl;
        this.lettered = bl2;
        this.symbolIndent = n;
    }

    public List(Properties properties) {
        String string = (String)((Hashtable)properties).remove("listsymbol");
        if (string == null) {
            string = "-";
        }
        this.symbol = new Chunk(string, FontFactory.getFont(properties));
        this.numbered = false;
        string = (String)((Hashtable)properties).remove("numbered");
        if (string != null) {
            this.numbered = new Boolean(string);
            if (this.lettered && this.numbered) {
                this.lettered = false;
            }
        }
        if ((string = (String)((Hashtable)properties).remove("lettered")) != null) {
            this.lettered = new Boolean(string);
            if (this.numbered && this.lettered) {
                this.numbered = false;
            }
        }
        this.symbolIndent = 0;
        string = (String)((Hashtable)properties).remove("symbolindent");
        if (string != null) {
            this.symbolIndent = Integer.parseInt(string);
        }
        if ((string = (String)((Hashtable)properties).remove("first")) != null) {
            char c = string.charAt(0);
            if (Character.isLetter(c)) {
                this.setFirst(c);
            } else {
                this.setFirst(Integer.parseInt(string));
            }
        }
        if ((string = (String)((Hashtable)properties).remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)((Hashtable)properties).remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
        if (((Hashtable)properties).size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 14;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this.list).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public boolean add(Object object) {
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            if (this.numbered || this.lettered) {
                Chunk chunk = this.numbered ? new Chunk(String.valueOf(this.first + this.list.size()), this.symbol.font()) : new Chunk(this.nextLetter(), this.symbol.font());
                chunk.append(".");
                listItem.setListSymbol(chunk);
            } else {
                listItem.setListSymbol(this.symbol);
            }
            listItem.setIndentationLeft(this.symbolIndent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object instanceof List) {
                List list = (List)object;
                list.setIndentationLeft(list.indentationLeft() + (float)this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object instanceof String) {
                return this.add(new ListItem((String)object));
            }
        }
        return false;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public void setFirst(int n) {
        this.first = n;
    }

    public void setFirst(char c) {
        this.firstCh = c;
        this.lastCh = Character.isLowerCase(this.firstCh) ? (char)122 : (char)90;
    }

    public void setListSymbol(Chunk chunk) {
        this.symbol = chunk;
    }

    public void setListSymbol(String string) {
        this.symbol = new Chunk(string);
    }

    public ArrayList getItems() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public float leading() {
        if (this.list.size() < 1) {
            return -1.0f;
        }
        ListItem listItem = (ListItem)this.list.get(0);
        return listItem.leading();
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public int symbolIndent() {
        return this.symbolIndent;
    }

    public Chunk symbol() {
        return this.symbol;
    }

    public int first() {
        return this.first;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isSymbol(String string) {
        return "listsymbol".equals(string);
    }

    public static boolean isTag(String string) {
        return "list".equals(string);
    }

    private String nextLetter() {
        int n = this.list.size();
        int n2 = this.lastCh + '\u0000';
        int n3 = this.firstCh + n;
        while (n3 > n2) {
            n3 -= 26;
        }
        char[] cArray = new char[]{(char)n3};
        String string = new String(cArray);
        return string;
    }

    public void setMarkupAttribute(String string, String string2) {
        this.markupAttributes = this.markupAttributes == null ? new Properties() : this.markupAttributes;
        ((Hashtable)this.markupAttributes).put(string, string2);
    }

    public void setMarkupAttributes(Properties properties) {
        this.markupAttributes = properties;
    }

    public String getMarkupAttribute(String string) {
        return this.markupAttributes == null ? null : String.valueOf(((Hashtable)this.markupAttributes).get(string));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }
}

