/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text;

import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Element;
import clover.com.lowagie.text.ElementListener;
import clover.com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Graphic
extends PdfContentByte
implements Element {
    public static final String HORIZONTAL_LINE = "HORIZONTAL";
    public static final String BORDER = "BORDER";
    private HashMap attributes;

    public Graphic() {
        super(null);
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 39;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public void setHorizontalLine(float f, float f2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(HORIZONTAL_LINE, new Object[]{new Float(f), new Float(f2), new Color(0, 0, 0)});
    }

    public void setHorizontalLine(float f, float f2, Color color) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(HORIZONTAL_LINE, new Object[]{new Float(f), new Float(f2), color});
    }

    public void drawHorizontalLine(float f, Color color, float f2, float f3, float f4) {
        this.setLineWidth(f);
        this.setColorStroke(color);
        this.moveTo(f2, f4);
        this.lineTo(f3, f4);
        this.stroke();
        this.resetRGBColorStroke();
    }

    public void setBorder(float f, float f2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(BORDER, new Object[]{new Float(f), new Float(f2), new Color(0, 0, 0)});
    }

    public void setBorder(float f, float f2, Color color) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(BORDER, new Object[]{new Float(f), new Float(f2), color});
    }

    public void drawBorder(float f, Color color, float f2, float f3, float f4, float f5) {
        this.setLineWidth(f);
        this.setColorStroke(color);
        this.rectangle(f2, f3, f4 - f2, f5 - f3);
        this.stroke();
        this.resetRGBColorStroke();
    }

    public void processAttributes(float f, float f2, float f3, float f4, float f5) {
        if (this.attributes == null) {
            return;
        }
        Iterator iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            float f6;
            String string = (String)iterator.next();
            Object[] objectArray = (Object[])this.attributes.get(string);
            if (HORIZONTAL_LINE.equals(string)) {
                f6 = ((Float)objectArray[1]).floatValue();
                float f7 = (f3 - f) * (100.0f - f6) / 200.0f;
                this.drawHorizontalLine(((Float)objectArray[0]).floatValue(), (Color)objectArray[2], f + f7, f3 - f7, f5);
            }
            if (!BORDER.equals(string)) continue;
            f6 = ((Float)objectArray[1]).floatValue();
            this.drawBorder(((Float)objectArray[0]).floatValue(), (Color)objectArray[2], f - f6, f2 - f6, f3 + f6, f4 + f6);
        }
    }
}

