/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time;

import clover.cenqua_com_licensing.atlassian.time.DateTimeField;
import clover.cenqua_com_licensing.atlassian.time.DateTimeZone;
import clover.cenqua_com_licensing.atlassian.time.DurationField;
import clover.cenqua_com_licensing.atlassian.time.ReadablePartial;
import clover.cenqua_com_licensing.atlassian.time.ReadablePeriod;
import clover.cenqua_com_licensing.atlassian.time.chrono.BuddhistChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.CopticChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.GJChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.GregorianChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.ISOChronology;
import clover.cenqua_com_licensing.atlassian.time.chrono.JulianChronology;

public abstract class Chronology {
    public static Chronology getISO() {
        return ISOChronology.getInstance();
    }

    public static Chronology getISOUTC() {
        return ISOChronology.getInstanceUTC();
    }

    public static Chronology getISO(DateTimeZone dateTimeZone) {
        return ISOChronology.getInstance(dateTimeZone);
    }

    public static Chronology getGJ() {
        return GJChronology.getInstance();
    }

    public static Chronology getGJUTC() {
        return GJChronology.getInstanceUTC();
    }

    public static Chronology getGJ(DateTimeZone dateTimeZone) {
        return GJChronology.getInstance(dateTimeZone);
    }

    public static Chronology getGregorian() {
        return GregorianChronology.getInstance();
    }

    public static Chronology getGregorianUTC() {
        return GregorianChronology.getInstanceUTC();
    }

    public static Chronology getGregorian(DateTimeZone dateTimeZone) {
        return GregorianChronology.getInstance(dateTimeZone);
    }

    public static Chronology getJulian() {
        return JulianChronology.getInstance();
    }

    public static Chronology getJulianUTC() {
        return JulianChronology.getInstanceUTC();
    }

    public static Chronology getJulian(DateTimeZone dateTimeZone) {
        return JulianChronology.getInstance(dateTimeZone);
    }

    public static Chronology getBuddhist() {
        return BuddhistChronology.getInstance();
    }

    public static Chronology getBuddhistUTC() {
        return BuddhistChronology.getInstanceUTC();
    }

    public static Chronology getBuddhist(DateTimeZone dateTimeZone) {
        return BuddhistChronology.getInstance(dateTimeZone);
    }

    public static Chronology getCoptic() {
        return CopticChronology.getInstance();
    }

    public static Chronology getCopticUTC() {
        return CopticChronology.getInstanceUTC();
    }

    public static Chronology getCoptic(DateTimeZone dateTimeZone) {
        return CopticChronology.getInstance(dateTimeZone);
    }

    public abstract DateTimeZone getZone();

    public abstract Chronology withUTC();

    public abstract Chronology withZone(DateTimeZone var1);

    public abstract long getDateTimeMillis(int var1, int var2, int var3, int var4);

    public abstract long getDateTimeMillis(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract long getDateTimeMillis(long var1, int var3, int var4, int var5, int var6);

    public abstract void validate(ReadablePartial var1, int[] var2);

    public abstract int[] get(ReadablePartial var1, long var2);

    public abstract long set(ReadablePartial var1, long var2);

    public abstract int[] get(ReadablePeriod var1, long var2, long var4);

    public abstract int[] get(ReadablePeriod var1, long var2);

    public abstract long add(ReadablePeriod var1, long var2, int var4);

    public abstract long add(long var1, long var3, int var5);

    public abstract DurationField millis();

    public abstract DateTimeField millisOfSecond();

    public abstract DateTimeField millisOfDay();

    public abstract DurationField seconds();

    public abstract DateTimeField secondOfMinute();

    public abstract DateTimeField secondOfDay();

    public abstract DurationField minutes();

    public abstract DateTimeField minuteOfHour();

    public abstract DateTimeField minuteOfDay();

    public abstract DurationField hours();

    public abstract DateTimeField hourOfDay();

    public abstract DateTimeField clockhourOfDay();

    public abstract DurationField halfdays();

    public abstract DateTimeField hourOfHalfday();

    public abstract DateTimeField clockhourOfHalfday();

    public abstract DateTimeField halfdayOfDay();

    public abstract DurationField days();

    public abstract DateTimeField dayOfWeek();

    public abstract DateTimeField dayOfMonth();

    public abstract DateTimeField dayOfYear();

    public abstract DurationField weeks();

    public abstract DateTimeField weekOfWeekyear();

    public abstract DurationField weekyears();

    public abstract DateTimeField weekyear();

    public abstract DateTimeField weekyearOfCentury();

    public abstract DurationField months();

    public abstract DateTimeField monthOfYear();

    public abstract DurationField years();

    public abstract DateTimeField year();

    public abstract DateTimeField yearOfEra();

    public abstract DateTimeField yearOfCentury();

    public abstract DurationField centuries();

    public abstract DateTimeField centuryOfEra();

    public abstract DurationField eras();

    public abstract DateTimeField era();

    public abstract String toString();
}

