/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

public class DirectoryScanner
implements FileScanner,
SelectorScanner,
ResourceFactory {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final boolean[] CS_SCAN_ONLY = new boolean[]{true};
    private static final boolean[] CS_THEN_NON_CS = new boolean[]{true, false};
    private static Vector defaultExcludes = new Vector();
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected FileSelector[] selectors = null;
    protected Vector filesIncluded;
    protected Vector filesNotIncluded;
    protected Vector filesExcluded;
    protected Vector dirsIncluded;
    protected Vector dirsNotIncluded;
    protected Vector dirsExcluded;
    protected Vector filesDeselected;
    protected Vector dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;
    private Map fileListMap = new HashMap();
    private Set scannedDirs = new HashSet();
    private Set includeNonPatterns = new HashSet();
    private Set excludeNonPatterns = new HashSet();
    private String[] includePatterns;
    private String[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private Object scanLock = new Object();
    private boolean slowScanning = false;
    private Object slowScanLock = new Object();
    private IllegalStateException illegal = null;

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
            ++i;
        }
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public synchronized void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public synchronized File getBasedir() {
        return this.basedir;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public synchronized void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public synchronized void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            int i = 0;
            while (i < includes.length) {
                this.includes[i] = DirectoryScanner.normalizePattern(includes[i]);
                ++i;
            }
        }
    }

    public synchronized void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                this.excludes[i] = DirectoryScanner.normalizePattern(excludes[i]);
                ++i;
            }
        }
    }

    public synchronized void addExcludes(String[] excludes) {
        if (excludes != null && excludes.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] tmp = new String[excludes.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, tmp, 0, this.excludes.length);
                int i = 0;
                while (i < excludes.length) {
                    tmp[this.excludes.length + i] = DirectoryScanner.normalizePattern(excludes[i]);
                    ++i;
                }
                this.excludes = tmp;
            } else {
                this.setExcludes(excludes);
            }
        }
    }

    private static String normalizePattern(String p) {
        String pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public synchronized void setSelectors(FileSelector[] selectors) {
        this.selectors = selectors;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws IllegalStateException {
        Object object;
        Object object2 = this.scanLock;
        synchronized (object2) {
            if (this.scanning) {
                while (this.scanning) {
                    try {
                        this.scanLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                return;
            }
            this.scanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                String[] stringArray;
                boolean nullIncludes;
                this.illegal = null;
                this.clearResults();
                boolean bl = nullIncludes = this.includes == null;
                if (nullIncludes) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "**";
                } else {
                    stringArray = this.includes;
                }
                this.includes = stringArray;
                boolean nullExcludes = this.excludes == null;
                String[] stringArray3 = this.excludes = nullExcludes ? new String[]{} : this.excludes;
                if (this.basedir == null) {
                    this.illegal = new IllegalStateException("No basedir set");
                } else {
                    if (!this.basedir.exists()) {
                        this.illegal = new IllegalStateException("basedir " + this.basedir + " does not exist");
                    }
                    if (!this.basedir.isDirectory()) {
                        this.illegal = new IllegalStateException("basedir " + this.basedir + " is not a directory");
                    }
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                if (this.isIncluded("")) {
                    if (!this.isExcluded("")) {
                        if (this.isSelected("", this.basedir)) {
                            this.dirsIncluded.addElement("");
                        } else {
                            this.dirsDeselected.addElement("");
                        }
                    } else {
                        this.dirsExcluded.addElement("");
                    }
                } else {
                    this.dirsNotIncluded.addElement("");
                }
                this.checkIncludePatterns();
                this.clearCaches();
                this.includes = nullIncludes ? null : this.includes;
                this.excludes = nullExcludes ? null : this.excludes;
            }
        }
        finally {
            object = this.scanLock;
            synchronized (object) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkIncludePatterns() {
        block13: {
            block12: {
                newroots = new Hashtable<String, String>();
                icounter = 0;
                while (icounter < this.includes.length) {
                    newroots.put(SelectorUtils.rtrimWildcardTokens(this.includes[icounter]), this.includes[icounter]);
                    ++icounter;
                }
                if (!newroots.containsKey("")) break block12;
                this.scandir(this.basedir, "", true);
                break block13;
            }
            enum2 = newroots.keys();
            canonBase = null;
            try {
                canonBase = this.basedir.getCanonicalFile();
                if (true) ** GOTO lbl47
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
            do {
                currentelement = (String)enum2.nextElement();
                originalpattern = (String)newroots.get(currentelement);
                myfile = new File(this.basedir, currentelement);
                if (myfile.exists()) {
                    try {
                        canonFile = myfile.getCanonicalFile();
                        path = DirectoryScanner.FILE_UTILS.removeLeadingPath(canonBase, canonFile);
                        if ((!path.equals(currentelement) || DirectoryScanner.ON_VMS) && (myfile = this.findFile(this.basedir, currentelement, true)) != null) {
                            currentelement = DirectoryScanner.FILE_UTILS.removeLeadingPath(this.basedir, myfile);
                        }
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex);
                    }
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive() || !(f = this.findFile(this.basedir, currentelement, false)).exists())) {
                    currentelement = DirectoryScanner.FILE_UTILS.removeLeadingPath(this.basedir, f);
                    myfile = f;
                }
                if (myfile == null || !myfile.exists() || !this.followSymlinks && this.isSymlink(this.basedir, currentelement)) continue;
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                        this.accountForIncludedDir(currentelement, myfile, true);
                        continue;
                    }
                    if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                        currentelement = currentelement + File.separatorChar;
                    }
                    this.scandir(myfile, currentelement, true);
                    continue;
                }
                v0 = included = this.isCaseSensitive() != false ? originalpattern.equals(currentelement) : originalpattern.equalsIgnoreCase(currentelement);
                if (!included) continue;
                this.accountForIncludedFile(currentelement, myfile);
lbl47:
                // 6 sources

            } while (enum2.hasMoreElements());
        }
    }

    protected synchronized void clearResults() {
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slowScan() {
        Object object;
        Object object2 = this.slowScanLock;
        synchronized (object2) {
            if (this.haveSlowResults) {
                return;
            }
            if (this.slowScanning) {
                while (this.slowScanning) {
                    try {
                        this.slowScanLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                return;
            }
            this.slowScanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                Object[] excl = new String[this.dirsExcluded.size()];
                this.dirsExcluded.copyInto(excl);
                Object[] notIncl = new String[this.dirsNotIncluded.size()];
                this.dirsNotIncluded.copyInto(notIncl);
                int i = 0;
                while (i < excl.length) {
                    if (!this.couldHoldIncluded((String)excl[i])) {
                        this.scandir(new File(this.basedir, (String)excl[i]), (String)excl[i] + File.separator, false);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < notIncl.length) {
                    if (!this.couldHoldIncluded((String)notIncl[i2])) {
                        this.scandir(new File(this.basedir, (String)notIncl[i2]), (String)notIncl[i2] + File.separator, false);
                    }
                    ++i2;
                }
            }
        }
        finally {
            object = this.slowScanLock;
            synchronized (object) {
                this.haveSlowResults = true;
                this.slowScanning = false;
                this.slowScanLock.notifyAll();
            }
        }
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        if (dir == null) {
            throw new BuildException("dir must not be null.");
        }
        if (!dir.exists()) {
            throw new BuildException(dir + " doesn't exists.");
        }
        if (!dir.isDirectory()) {
            throw new BuildException(dir + " is not a directory.");
        }
        if (fast && this.hasBeenScanned(vpath)) {
            return;
        }
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            throw new BuildException("IO error scanning directory " + dir.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            Vector<Object> noLinks = new Vector<Object>();
            int i = 0;
            while (i < newfiles.length) {
                try {
                    if (FILE_UTILS.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + (String)newfiles[i];
                        File file = new File(dir, (String)newfiles[i]);
                        (file.isDirectory() ? this.dirsExcluded : this.filesExcluded).addElement(name);
                    } else {
                        noLinks.addElement(newfiles[i]);
                    }
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.addElement(newfiles[i]);
                }
                ++i;
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        int i = 0;
        while (i < newfiles.length) {
            String name = vpath + newfiles[i];
            File file = new File(dir, (String)newfiles[i]);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedDir(name, file, fast);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        this.scandir(file, name + File.separator, fast);
                    }
                }
                if (!fast) {
                    this.scandir(file, name + File.separator, fast);
                }
            } else if (file.isFile()) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedFile(name, file);
                } else {
                    this.everythingIncluded = false;
                    this.filesNotIncluded.addElement(name);
                }
            }
            ++i;
        }
    }

    private void accountForIncludedFile(String name, File file) {
        if (this.filesIncluded.contains(name) || this.filesExcluded.contains(name) || this.filesDeselected.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            this.filesExcluded.addElement(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            this.filesIncluded.addElement(name);
        } else {
            this.filesDeselected.addElement(name);
        }
        this.everythingIncluded &= included;
    }

    private void accountForIncludedDir(String name, File file, boolean fast) {
        if (this.dirsIncluded.contains(name) || this.dirsExcluded.contains(name) || this.dirsDeselected.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            this.dirsExcluded.addElement(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            this.dirsIncluded.addElement(name);
        } else {
            this.dirsDeselected.addElement(name);
        }
        this.everythingIncluded &= included;
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name + File.separator, fast);
        }
    }

    protected boolean isIncluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(name) : this.includeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        int i = 0;
        while (i < this.includePatterns.length) {
            if (DirectoryScanner.matchPath(this.includePatterns[i], name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        int i = 0;
        while (i < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[i], name, this.isCaseSensitive()) && this.isMorePowerfulThanExcludes(name, this.includes[i]) && this.isDeeper(this.includes[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDeeper(String pattern, String name) {
        Vector p = SelectorUtils.tokenizePath(pattern);
        Vector n = SelectorUtils.tokenizePath(name);
        return p.contains("**") || p.size() > n.size();
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = name + File.separator + "**";
        int counter = 0;
        while (counter < this.excludes.length) {
            if (this.excludes[counter].equals(soughtexclude)) {
                return false;
            }
            ++counter;
        }
        return true;
    }

    private boolean contentsExcluded(String name) {
        name = name.endsWith(File.separator) ? name : name + File.separator;
        int i = 0;
        while (i < this.excludes.length) {
            String e = this.excludes[i];
            if (e.endsWith("**") && SelectorUtils.matchPath(e.substring(0, e.length() - 2), name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(name) : this.excludeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        int i = 0;
        while (i < this.excludePatterns.length) {
            if (DirectoryScanner.matchPath(this.excludePatterns[i], name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            int i = 0;
            while (i < this.selectors.length) {
                if (!this.selectors[i].isSelected(this.basedir, name, file)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public synchronized String[] getIncludedFiles() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException();
        }
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException();
        }
        return this.filesIncluded.size();
    }

    public synchronized String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    public synchronized String[] getExcludedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public synchronized String[] getDeselectedFiles() {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    public synchronized String[] getIncludedDirectories() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException();
        }
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        Arrays.sort(directories);
        return directories;
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException();
        }
        return this.dirsIncluded.size();
    }

    public synchronized String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    public synchronized String[] getExcludedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public synchronized String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    public synchronized void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + defaultExcludes.size()];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        String[] defaultExcludesTemp = DirectoryScanner.getDefaultExcludes();
        int i = 0;
        while (i < defaultExcludesTemp.length) {
            newExcludes[i + excludesLength] = defaultExcludesTemp[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++i;
        }
        this.excludes = newExcludes;
    }

    public synchronized Resource getResource(String name) {
        File f = FILE_UTILS.resolveFile(this.basedir, name);
        return new Resource(name, f.exists(), f.lastModified(), f.isDirectory(), f.length());
    }

    private String[] list(File file) {
        String[] files = (String[])this.fileListMap.get(file);
        if (files == null && (files = file.list()) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    private File findFile(File base, String path, boolean cs) {
        return this.findFile(base, SelectorUtils.tokenizePath(path), cs);
    }

    private File findFile(File base, Vector pathElements, boolean cs) {
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new BuildException("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = (String)pathElements.remove(0);
        boolean[] matchCase = cs ? CS_SCAN_ONLY : CS_THEN_NON_CS;
        int i = 0;
        while (i < matchCase.length) {
            int j = 0;
            while (j < files.length) {
                if (matchCase[i] ? files[j].equals(current) : files[j].equalsIgnoreCase(current)) {
                    return this.findFile(new File(base, files[j]), pathElements, cs);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, SelectorUtils.tokenizePath(path));
    }

    private boolean isSymlink(File base, Vector pathElements) {
        if (pathElements.size() > 0) {
            String current = (String)pathElements.remove(0);
            try {
                return FILE_UTILS.isSymbolicLink(base, current) || this.isSymlink(new File(base, current), pathElements);
            }
            catch (IOException ioe) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    Set getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.fileListMap.clear();
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = null;
        this.excludePatterns = null;
        this.areNonPatternSetsReady = false;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private String[] fillNonPatternSet(Set set, String[] patterns) {
        ArrayList<String> al = new ArrayList<String>(patterns.length);
        int i = 0;
        while (i < patterns.length) {
            if (!SelectorUtils.hasWildcards(patterns[i])) {
                set.add(this.isCaseSensitive() ? patterns[i] : patterns[i].toUpperCase());
            } else {
                al.add(patterns[i]);
            }
            ++i;
        }
        return set.size() == 0 ? patterns : al.toArray(new String[al.size()]);
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
    }
}

