/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xframe.xsddoc.util;

import net.sf.xframe.xsddoc.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DomUtil {
    private DomUtil() {
    }

    public static Node getFirstElementChild(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static String getAttributeValue(Node node, String string) {
        try {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Node removeDuplicates(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !DomUtil.hasDuplicate(nodeList, node2)) continue;
            node.removeChild(node2);
        }
        return node;
    }

    private static boolean hasDuplicate(NodeList nodeList, Node node) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 == node || node2.getNodeType() != 1 || !DomUtil.equals(node, node2)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        if (!node.getNodeName().equals(node2.getNodeName())) {
            return false;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node3 = namedNodeMap.item(i);
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            if (namedNodeMap2 == null) {
                return false;
            }
            Node node4 = node2.getAttributes().getNamedItem(node3.getNodeName());
            if (node4 == null) {
                return false;
            }
            if (StringUtil.equals(node3.getNodeValue(), node4.getNodeValue())) continue;
            return false;
        }
        return true;
    }
}

