/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xframe.xsddoc;

import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.xframe.xsddoc.Processor;
import net.sf.xframe.xsddoc.ProcessorException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Task
extends MatchingTask {
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private Html footer;
    private Html doctitle;
    private Html header;
    private Html bottom;
    private String dir = null;
    private String file = null;
    private Vector filesets = new Vector();
    private Processor processor = new Processor();
    private boolean failonerror = true;
    private boolean verbose = false;
    private boolean debug = false;
    private DocumentBuilder builder = null;

    public void execute() throws BuildException {
        try {
            this.process();
        }
        catch (Exception exception) {
            if (this.failonerror) {
                if (exception instanceof BuildException) {
                    throw (BuildException)exception;
                }
                throw new BuildException((Throwable)exception);
            }
            this.log(exception.getMessage(), 1);
        }
    }

    private void process() throws ProcessorException {
        FileSet fileSet;
        Document document;
        int n;
        int n2 = this.file == null ? 0 : 1;
        int n3 = this.dir == null ? 0 : 1;
        int n4 = n = this.filesets.size() == 0 ? 0 : 1;
        if (n2 + n3 + n != 1) {
            throw new BuildException("Exactly one of the file or dir attributes, or a fileset element, must be set.");
        }
        if (this.doctitle != null) {
            this.processor.setDoctitle(this.doctitle.getText());
        }
        if (this.header != null) {
            this.processor.setHeader(this.header.getText());
        }
        if (this.footer != null) {
            this.processor.setFooter(this.footer.getText());
        }
        if (this.bottom != null) {
            this.processor.setBottom(this.bottom.getText());
        }
        if (this.file != null) {
            this.processor.setSchemaLocation(this.file);
            this.processor.execute();
        }
        if (this.dir != null) {
            document = this.createDocument();
            File file = new File(this.dir);
            if (!file.exists()) {
                throw new BuildException("not a directory: " + file.getAbsolutePath());
            }
            fileSet = file.list();
            for (int i = 0; i < ((String[])fileSet).length; ++i) {
                File file2;
                if (this.debug) {
                    System.out.println("found file " + (String)fileSet[i]);
                }
                if (!(file2 = new File((String)fileSet[i])).isDirectory()) {
                    this.addSchema(document, file.getAbsolutePath(), (String)fileSet[i]);
                    continue;
                }
                if (!this.debug) continue;
                System.out.println("Seems not to be a file " + (String)fileSet[i]);
            }
            this.processor.setSchemaLocation(file.getAbsolutePath() + File.separator + "mediator-schema");
            this.processor.setMainSchema(document);
            this.processor.execute();
        }
        if (this.filesets.size() > 0) {
            document = this.createDocument();
            for (int i = 0; i < this.filesets.size(); ++i) {
                fileSet = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                this.addSchemas(document, directoryScanner.getBasedir().getAbsolutePath(), directoryScanner);
            }
            this.processor.setSchemaLocation(this.getProject().getBaseDir().getAbsolutePath() + File.separator + "mediator-schema");
            this.processor.setMainSchema(document);
            this.processor.execute();
        }
    }

    private Document createDocument() {
        Document document = this.getDocumentBuilder().getDOMImplementation().createDocument(SCHEMA_NS, "schema", null);
        return document;
    }

    private DocumentBuilder getDocumentBuilder() throws BuildException {
        if (this.builder != null) {
            return this.builder;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            this.builder = documentBuilderFactory.newDocumentBuilder();
            return this.builder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException((Throwable)parserConfigurationException);
        }
    }

    private void addSchemas(Document document, String string, DirectoryScanner directoryScanner) {
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addSchema(document, string, stringArray[i]);
        }
    }

    private void addSchema(Document document, String string, String string2) {
        String string3 = null;
        string3 = this.getNamespace(string, string2);
        if (string3 == null) {
            if (this.debug) {
                System.out.println("Seems not to be a schema, ignoring " + string2);
            }
            return;
        }
        if (this.verbose) {
            System.out.println("found schema " + string2);
        }
        Element element = document.createElementNS(SCHEMA_NS, "import");
        String string4 = new File(string, string2).getAbsolutePath();
        element.setAttribute("schemaLocation", string4);
        element.setAttribute("namespace", string3);
        document.getDocumentElement().appendChild(element);
    }

    private String getNamespace(String string, String string2) {
        try {
            Document document = this.getDocumentBuilder().parse(new File(string, string2));
            Element element = document.getDocumentElement();
            if (!element.getLocalName().equals("schema") || !element.getNamespaceURI().equals(SCHEMA_NS)) {
                return null;
            }
            return element.getAttribute("targetNamespace");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.processor.setDebug(bl);
    }

    public void setOut(String string) {
        this.processor.setOut(string);
    }

    public void setSchemalocation(String string) {
        this.file = string;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public void setTitle(String string) {
        Html html = new Html();
        html.addText(string);
        this.addDoctitle(html);
    }

    public void setCss(String string) {
        this.processor.setCss(string);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        this.processor.setVerbose(bl);
    }

    public void setQuiet(boolean bl) {
        this.verbose = !bl;
        this.processor.setVerbose(!bl);
    }

    public void setHidelocalusage(boolean bl) {
        this.processor.setHideLocalUsage(bl);
    }

    public void setHidesubtypes(boolean bl) {
        this.processor.setHideSubTypes(bl);
    }

    public void setHidetypes(boolean bl) {
        this.processor.setHideTypes(bl);
    }

    public void setHideattributes(boolean bl) {
        this.processor.setHideAttributes(bl);
    }

    public void setHidegroups(boolean bl) {
        this.processor.setHideGroups(bl);
    }

    public void setXml(boolean bl) {
        this.processor.setXml(bl);
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addDoctitle(Html html) {
        this.doctitle = html;
    }

    public void setDoctitle(String string) {
        Html html = new Html();
        html.addText(string);
        this.addDoctitle(html);
    }

    public void setHeader(String string) {
        Html html = new Html();
        html.addText(string);
        this.addHeader(html);
    }

    public void addHeader(Html html) {
        this.header = html;
    }

    public void addFooter(Html html) {
        this.footer = html;
    }

    public void setFooter(String string) {
        Html html = new Html();
        html.addText(string);
        this.addFooter(html);
    }

    public void setBottom(String string) {
        Html html = new Html();
        html.addText(string);
        this.addBottom(html);
    }

    public void addBottom(Html html) {
        this.bottom = html;
    }

    protected void setCreateFolder(boolean bl) {
        this.processor.setCreateFolder(bl);
    }

    protected void setLauch(boolean bl) {
        this.processor.setLaunch(bl);
    }

    public static final class Html {
        private StringBuffer text = new StringBuffer();

        public void addText(String string) {
            this.text.append(string);
        }

        public String getText() {
            return this.text.substring(0);
        }
    }
}

