/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.plugin.jspwiki.test;

import com.ecyrd.jspwiki.plugin.PluginException;
import de.java2html.JavaSourceConversionSettings;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.plugin.AbstractJava2HtmlPlugin;
import de.java2html.plugin.jspwiki.Java2HtmlPlugin;
import java.util.HashMap;
import junit.framework.TestCase;

public class Java2HtmlPluginTest
extends TestCase {
    private static final String SOURCE_CODE = "public class HelloWorld {\n  public static void main(String args[]) {\n    System.out.println(\"Hello World!\");\n  }\n}";
    private static final String CONVERTED_HTML_DEFAULT_STYLE = AbstractJava2HtmlPlugin.convert("public class HelloWorld {\n  public static void main(String args[]) {\n    System.out.println(\"Hello World!\");\n  }\n}", AbstractJava2HtmlPlugin.getDefaultSettings());
    private Java2HtmlPlugin plugin;
    private static String CONVERTED_HTML_MONOCHROME_STYLE;

    protected void setUp() throws Exception {
        this.plugin = new Java2HtmlPlugin();
    }

    public void testThrowsUsageExceptionWhenNoSourceCodeGiven() {
        try {
            this.plugin.execute(null, new HashMap());
            Java2HtmlPluginTest.fail();
        }
        catch (PluginException expected) {
            Java2HtmlPluginTest.assertEquals((String)Java2HtmlPlugin.DEFAULT_USAGE_MESSAGE, (String)expected.getMessage());
        }
    }

    public void testConversionAsSourceParameter() throws PluginException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("source", SOURCE_CODE);
        Java2HtmlPluginTest.assertEquals((String)CONVERTED_HTML_DEFAULT_STYLE, (String)this.plugin.execute(null, map));
    }

    public void testConversionAsBodyParameter() throws PluginException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("_body", SOURCE_CODE);
        Java2HtmlPluginTest.assertEquals((String)CONVERTED_HTML_DEFAULT_STYLE, (String)this.plugin.execute(null, map));
    }

    public void testConversionAsBodyParameterWithLeadingNewLine() throws PluginException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("_body", "\npublic class HelloWorld {\n  public static void main(String args[]) {\n    System.out.println(\"Hello World!\");\n  }\n}");
        Java2HtmlPluginTest.assertEquals((String)CONVERTED_HTML_DEFAULT_STYLE, (String)this.plugin.execute(null, map));
    }

    public void testUsingDefaultStyleNameIsSameAsUsingDefaultStyle() throws PluginException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("source", SOURCE_CODE);
        map.put("style", AbstractJava2HtmlPlugin.getDefaultSettings().getConversionOptions().getStyleTable().getName());
        Java2HtmlPluginTest.assertEquals((String)CONVERTED_HTML_DEFAULT_STYLE, (String)this.plugin.execute(null, map));
    }

    public void testUsingMonochromeStyle() throws PluginException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("source", SOURCE_CODE);
        map.put("style", JavaSourceStyleTable.getDefaultMonochromeStyleTable().getName());
        Java2HtmlPluginTest.assertEquals((String)CONVERTED_HTML_MONOCHROME_STYLE, (String)this.plugin.execute(null, map));
    }

    public void testUnsupportedConversionStyle() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("style", "a_definitely_not_existing_style");
        try {
            this.plugin.execute(null, map);
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
    }

    static {
        JavaSourceConversionSettings monochromeOptions = AbstractJava2HtmlPlugin.getDefaultSettings();
        monochromeOptions.getConversionOptions().setStyleTable(JavaSourceStyleTable.getDefaultMonochromeStyleTable());
        CONVERTED_HTML_MONOCHROME_STYLE = AbstractJava2HtmlPlugin.convert(SOURCE_CODE, monochromeOptions);
    }
}

