/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.javasource;

import java.util.ArrayList;
import java.util.List;

public class JavaSourceType {
    private static final List ALL = new ArrayList();
    private static int idCounter = 0;
    public static final JavaSourceType BACKGROUND = new JavaSourceType("Background", false);
    public static final JavaSourceType LINE_NUMBERS = new JavaSourceType("Line numbers", true);
    public static final JavaSourceType COMMENT_BLOCK = new JavaSourceType("Multi-line comments", true);
    public static final JavaSourceType COMMENT_LINE = new JavaSourceType("Single-line comments", true);
    public static final JavaSourceType KEYWORD = new JavaSourceType("Keywords", true);
    public static final JavaSourceType STRING = new JavaSourceType("Strings", true);
    public static final JavaSourceType CHAR_CONSTANT = new JavaSourceType("Character constants", true);
    public static final JavaSourceType NUM_CONSTANT = new JavaSourceType("Numeric constants", true);
    public static final JavaSourceType PARENTHESIS = new JavaSourceType("Parenthesis", true);
    public static final JavaSourceType CODE_TYPE = new JavaSourceType("Primitive Types", true);
    public static final JavaSourceType CODE = new JavaSourceType("Others", true);
    public static final JavaSourceType JAVADOC_KEYWORD = new JavaSourceType("Javadoc keywords", true);
    public static final JavaSourceType JAVADOC_HTML_TAG = new JavaSourceType("Javadoc HTML tags", true);
    public static final JavaSourceType JAVADOC_LINKS = new JavaSourceType("Javadoc links", true);
    public static final JavaSourceType JAVADOC = new JavaSourceType("Javadoc others", true);
    public static final JavaSourceType UNDEFINED = new JavaSourceType("Undefined", false);
    public static final JavaSourceType ANNOTATION = new JavaSourceType("Annotation", true);
    private String name;
    private int id = idCounter++;
    private boolean displayRelevant;

    public static JavaSourceType[] getAll() {
        return ALL.toArray(new JavaSourceType[ALL.size()]);
    }

    private JavaSourceType(String name, boolean displayRelevant) {
        this.name = name;
        this.displayRelevant = displayRelevant;
        ALL.add(this);
    }

    public String getName() {
        return this.toString();
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public boolean isDisplayRelevant() {
        return this.displayRelevant;
    }
}

