/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.converter;

import de.java2html.Version;
import de.java2html.converter.AbstractJavaSourceConverter;
import de.java2html.converter.ConverterMetaData;
import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.RGB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class JavaSource2TeXConverter
extends AbstractJavaSourceConverter {
    private static String[] texFormats;
    protected static final String DOCUMENT_HEADER = "\\documentclass[11pt,a4paper]{article}\n\n\\usepackage{color}\n\n\\begin{document}\n\n";
    protected static final String DOCUMENT_FOOTER = "\\end{document}";
    protected static final String DOCUMENT_BLOCK_SEPARATOR = "\n\n";
    protected static final String BLOCK_HEADER;
    protected static final String[] WHITESPACES;

    private String createFormatDefinition(JavaSourceStyleTable styleTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("%Java2TeX style definitions\n");
        sb.append("%You can modify them to fit your needs\n");
        JavaSourceType[] allTypes = JavaSourceType.getAll();
        for (int i = 0; i < allTypes.length; ++i) {
            sb.append("\\newcommand{\\jttstyle");
            sb.append((char)(97 + i));
            sb.append("}{\\color[rgb]{");
            RGB color = styleTable.get(allTypes[i]).getColor();
            float[] cs = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
            sb.append(JavaSource2TeXConverter.floatToCharArray(cs[0]));
            sb.append(',');
            sb.append(JavaSource2TeXConverter.floatToCharArray(cs[1]));
            sb.append(',');
            sb.append(JavaSource2TeXConverter.floatToCharArray(cs[2]));
            sb.append("}} %");
            sb.append(allTypes[i].getName());
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public JavaSource2TeXConverter() {
        super(new ConverterMetaData("tex", "TeX", "tex"));
    }

    protected static final char[] floatToCharArray(float f) {
        if ((double)f >= 1.0) {
            return new char[]{'1', '.', '0', '0'};
        }
        return new char[]{'.', (char)(48.0f + f * 10.0f), (char)(48.0f + f * 100.0f % 10.0f), (char)(48.0f + f * 1000.0f % 10.0f)};
    }

    public String getDocumentHeader(JavaSourceConversionOptions options, String title) {
        return DOCUMENT_HEADER + this.createFormatDefinition(options.getStyleTable());
    }

    public String getDocumentFooter(JavaSourceConversionOptions options) {
        return DOCUMENT_FOOTER;
    }

    public String getBlockSeparator(JavaSourceConversionOptions options) {
        return DOCUMENT_BLOCK_SEPARATOR;
    }

    public void convert(JavaSource source, JavaSourceConversionOptions options, BufferedWriter writer) throws IOException {
        if (source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        writer.write(BLOCK_HEADER);
        if (!options.isShowFileName() || source.getFileName() != null) {
            // empty if block
        }
        writer.write("{");
        writer.newLine();
        writer.write("\\noindent \\ttfamily");
        writer.newLine();
        int lineCount = source.getLineCount();
        int lineNumber = 1;
        JavaSourceIterator iterator = source.getIterator();
        while (iterator.hasNext()) {
            JavaSourceRun run = iterator.getNext();
            if (run.isAtStartOfLine() && options.isShowLineNumbers()) {
                this.writeLineNumber(writer, lineNumber++, lineCount);
            }
            this.toTeX(run, writer);
            if (!run.isAtEndOfLine()) continue;
            writer.write("\\\\");
            writer.newLine();
        }
        writer.newLine();
        writer.write("}");
        writer.newLine();
    }

    public void writeLineNumber(BufferedWriter writer, int lineNumber, int lineCount) throws IOException {
        writer.write(texFormats[JavaSourceType.LINE_NUMBERS.getID()]);
        writer.write(JavaSource2TeXConverter.leftSpace(lineNumber, lineCount));
        writer.write(String.valueOf(lineNumber));
        writer.write(126);
    }

    protected void toTeX(JavaSourceRun run, BufferedWriter writer) throws IOException {
        writer.write(texFormats[run.getType().getID()]);
        String text = run.getCode();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                writer.write(126);
                continue;
            }
            if (ch == '_' || ch == '\\' || ch == '^' || ch == '~' || ch == '\"' || ch == '|' || ch == '<' || ch == '>' || ch == '*') {
                writer.write("\\verb#" + ch + "#");
                continue;
            }
            if (ch == '{' || ch == '}' || ch == '_' || ch == '&' || ch == '%' || ch == '$' || ch == '#') {
                writer.write("\\" + ch);
                continue;
            }
            writer.write(ch);
        }
    }

    protected static final String whiteSpace(int size) {
        if (size < WHITESPACES.length) {
            return WHITESPACES[size];
        }
        char[] result = new char[size];
        while (size > 0) {
            result[--size] = 126;
        }
        return new String(result);
    }

    protected static final String leftSpace(int num, int max) {
        int count = (int)(Math.log(max) / Math.log(10.0)) - (int)(Math.log(num) / Math.log(10.0));
        return JavaSource2TeXConverter.whiteSpace(count);
    }

    public static void main(String[] args) throws IOException {
        long time0 = System.currentTimeMillis();
        JavaSource source = new JavaSourceParser().parse(new File("JavaSourceParser.java"));
        long time1 = System.currentTimeMillis();
        JavaSource2TeXConverter conn1 = new JavaSource2TeXConverter();
        conn1.convert(source, JavaSourceConversionOptions.getDefault(), new StringWriter());
        long time2 = System.currentTimeMillis();
        JavaSource2HTMLConverter conn2 = new JavaSource2HTMLConverter();
        conn2.convert(source, JavaSourceConversionOptions.getDefault(), new StringWriter());
        long time3 = System.currentTimeMillis();
        System.out.println("Parse:  " + (time1 - time0) + "ms");
        System.out.println("toTeX:  " + (time2 - time1) + "ms");
        System.out.println("toHTML: " + (time3 - time2) + "ms");
    }

    static {
        JavaSourceType[] allTypes = JavaSourceType.getAll();
        texFormats = new String[allTypes.length];
        for (int i = 0; i < allTypes.length; ++i) {
            JavaSource2TeXConverter.texFormats[i] = "\\jttstyle" + (char)(97 + i) + " ";
        }
        BLOCK_HEADER = "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n%  Java Sourcecode to TeX automatically converted code\n%  " + Version.getJava2HtmlConverterTitle() + " " + Version.getBuildDate() + "by Markus Gebhard  markus@jave.de\n" + "%     Further information: http://www.java2html.de\n";
        WHITESPACES = new String[]{"", "~", "~~", "~~~", "~~~~"};
    }
}

