/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObject2LongSortedMap;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import clover.it.unimi.dsi.fastutil.objects.Object2LongMap;
import clover.it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Object2LongLinkedOpenCustomHashMap
extends AbstractObject2LongSortedMap
implements Serializable,
Cloneable,
Hash,
Object2LongSortedMap {
    protected transient Object[] key;
    protected transient long[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ObjectSet keys;
    protected volatile transient LongCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    protected Hash.Strategy strategy;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2LongLinkedOpenCustomHashMap(int n, float f, Hash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new long[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Object2LongLinkedOpenCustomHashMap(int n, Hash.Strategy strategy) {
        this(n, 0.75f, strategy);
    }

    public Object2LongLinkedOpenCustomHashMap(Hash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2LongLinkedOpenCustomHashMap(Map m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2LongLinkedOpenCustomHashMap(Map m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2LongLinkedOpenCustomHashMap(Object2LongMap m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll((Map)m);
    }

    public Object2LongLinkedOpenCustomHashMap(Object2LongMap m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2LongLinkedOpenCustomHashMap(Object[] k, long[] v, float f, Hash.Strategy strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2LongLinkedOpenCustomHashMap(Object[] k, long[] v, Hash.Strategy strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy strategy() {
        return this.strategy;
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public long put(Object k, long v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int n = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[n] == PRIMES[this.p]) {
                ++n;
            }
            this.rehash(n);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        long v = (Long)ov;
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Long(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(long v) {
        long[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public Object firstKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public Object lastKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public Comparator comparator() {
        return null;
    }

    public SortedMap tailMap(Object from) {
        throw new UnsupportedOperationException();
    }

    public SortedMap headMap(Object to) {
        throw new UnsupportedOperationException();
    }

    public SortedMap subMap(Object from, Object to) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public long getLong(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public long removeLong(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : new Long(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return new Long(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2LongLinkedOpenCustomHashMap.this.findKey(e.getKey());
                    return i >= 0 && Object2LongLinkedOpenCustomHashMap.this.value[i] == (Long)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2LongLinkedOpenCustomHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Object2LongLinkedOpenCustomHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Object2LongLinkedOpenCustomHashMap.this.count;
                }

                public void clear() {
                    Object2LongLinkedOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                public LongIterator longIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2LongLinkedOpenCustomHashMap.this.count;
                }

                public boolean contains(long v) {
                    return Object2LongLinkedOpenCustomHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2LongLinkedOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int n = PRIMES[newP];
        Object[] objectArray = this.key;
        Object[] objectArray2 = new Object[n];
        long[] lArray = this.value;
        long[] lArray2 = new long[n];
        byte[] byArray = this.state;
        byte[] byArray2 = new byte[n];
        int[] newN = this.link;
        int[] key = new int[n];
        this.first = -1;
        while (j-- != 0) {
            while (byArray[i] != -1) {
                ++i;
            }
            Object newKey = objectArray[i];
            long value = lArray[i];
            int state = this.strategy.hashCode(newKey) & Integer.MAX_VALUE;
            int newState = state % n;
            int link = state % (n - 2) + 1;
            if (byArray2[newState] != 0) {
                link = state % (n - 2) + 1;
                while (byArray2[newState = (newState + link) % n] != 0) {
                }
            }
            byArray2[newState] = -1;
            h1[newState] = newKey;
            k[newState] = value;
            int newLink = i;
            i = newN[i] ^ prev;
            prev = newLink;
            if (this.first != -1) {
                int n2 = newPrev;
                key[n2] = key[n2] ^ newState;
                key[newState] = newPrev;
                newPrev = newState;
                continue;
            }
            newPrev = this.first = newState;
            key[newState] = -1;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = objectArray2;
        this.value = lArray2;
        this.state = byArray2;
        this.link = key;
        this.last = newPrev;
        if (newPrev != -1) {
            int n3 = newPrev;
            key[n3] = ~key[n3];
        }
    }

    public Object clone() {
        Object2LongLinkedOpenCustomHashMap c;
        try {
            c = (Object2LongLinkedOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        c.strategy = this.strategy;
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            if (this != this.key[t]) {
                j = this.strategy.hashCode(this.key[t]);
            }
            h += (j ^= HashCommon.long2int(this.value[t]));
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        long[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeObject(key[j]);
            s.writeLong(value[j]);
        }
    }

    private void checkTable() {
        Object k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        ObjectBidirectionalIterator i = (ObjectBidirectionalIterator)this.keySet().iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.next();
            if (!this.containsKey(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = ((ObjectSortedSet)this.keySet()).iterator(this.lastKey());
            while (n-- != 0) {
                k = i.previous();
                if (!this.containsKey(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new long[n];
        long[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            void h1;
            void k2i;
            Object object = s.readObject();
            long l = s.readLong();
            int k = this.strategy.hashCode(object) & Integer.MAX_VALUE;
            int v = k % n;
            if (state[v] != 0) {
                int n2 = k % (n - 2) + 1;
                while (state[v = (v + n2) % n] != 0) {
                }
            }
            state[v] = -1;
            key[v] = k2i;
            value[v] = h1;
            if (this.first != -1) {
                int n3 = prev;
                link[n3] = link[n3] ^ v;
                link[v] = prev;
                prev = v;
                continue;
            }
            prev = this.first = v;
            link[v] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n4 = prev;
            link[n4] = ~link[n4];
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements LongListIterator {
        public long previousLong() {
            return Object2LongLinkedOpenCustomHashMap.this.value[this.previousEntry()];
        }

        public Object previous() {
            return new Long(Object2LongLinkedOpenCustomHashMap.this.value[this.previousEntry()]);
        }

        public long nextLong() {
            return Object2LongLinkedOpenCustomHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Long(Object2LongLinkedOpenCustomHashMap.this.value[this.nextEntry()]);
        }

        public void set(long v) {
            throw new UnsupportedOperationException();
        }

        public void add(long v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractObjectSortedSet
    implements ObjectSortedSet {
        private KeySet() {
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            return new KeyIterator(from);
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Object2LongLinkedOpenCustomHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Object2LongLinkedOpenCustomHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Object2LongLinkedOpenCustomHashMap.this.count;
            Object2LongLinkedOpenCustomHashMap.this.remove(k);
            return Object2LongLinkedOpenCustomHashMap.this.count != oldCount;
        }

        public void clear() {
            Object2LongLinkedOpenCustomHashMap.this.clear();
        }

        public Object first() {
            if (Object2LongLinkedOpenCustomHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Object2LongLinkedOpenCustomHashMap.this.key[Object2LongLinkedOpenCustomHashMap.this.first];
        }

        public Object last() {
            if (Object2LongLinkedOpenCustomHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Object2LongLinkedOpenCustomHashMap.this.key[Object2LongLinkedOpenCustomHashMap.this.last];
        }

        public Comparator comparator() {
            return null;
        }

        public final SortedSet tailSet(Object from) {
            throw new UnsupportedOperationException();
        }

        public final SortedSet headSet(Object to) {
            throw new UnsupportedOperationException();
        }

        public final SortedSet subSet(Object from, Object to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator {
        public KeyIterator(Object k) {
            super(k);
        }

        public Object previous() {
            return Object2LongLinkedOpenCustomHashMap.this.key[this.previousEntry()];
        }

        public KeyIterator() {
        }

        public Object next() {
            return Object2LongLinkedOpenCustomHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Object2LongLinkedOpenCustomHashMap.this.first;
        }

        MapIterator(Object from) {
            if (Object2LongLinkedOpenCustomHashMap.this.strategy.equals(Object2LongLinkedOpenCustomHashMap.this.key[Object2LongLinkedOpenCustomHashMap.this.last], from)) {
                this.prev = Object2LongLinkedOpenCustomHashMap.this.last;
                this.index = Object2LongLinkedOpenCustomHashMap.this.count;
            } else {
                int e;
                if (!Object2LongLinkedOpenCustomHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Object2LongLinkedOpenCustomHashMap.this.first;
                while (!Object2LongLinkedOpenCustomHashMap.this.strategy.equals(Object2LongLinkedOpenCustomHashMap.this.key[e = this.nextEntry()], from)) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = Object2LongLinkedOpenCustomHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = Object2LongLinkedOpenCustomHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public Object previous() {
            return new MapEntry(this.previousEntry());
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Object2LongLinkedOpenCustomHashMap.this.state[this.curr] = 1;
            Object2LongLinkedOpenCustomHashMap.this.key[this.curr] = HashCommon.REMOVED;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Object2LongLinkedOpenCustomHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Object2LongLinkedOpenCustomHashMap.this.link[this.curr] ^ this.prev;
            }
            --Object2LongLinkedOpenCustomHashMap.this.count;
            if (this.prev == -1) {
                Object2LongLinkedOpenCustomHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Object2LongLinkedOpenCustomHashMap.this.link[n] = Object2LongLinkedOpenCustomHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Object2LongLinkedOpenCustomHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Object2LongLinkedOpenCustomHashMap.this.link[n] = Object2LongLinkedOpenCustomHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Object2LongMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Object2LongLinkedOpenCustomHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Long(Object2LongLinkedOpenCustomHashMap.this.value[this.index]);
        }

        public long getLongValue() {
            return Object2LongLinkedOpenCustomHashMap.this.value[this.index];
        }

        public long setValue(long v) {
            long oldValue = Object2LongLinkedOpenCustomHashMap.this.value[this.index];
            Object2LongLinkedOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Long(this.setValue((Long)v));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2LongLinkedOpenCustomHashMap.this.strategy.equals(Object2LongLinkedOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2LongLinkedOpenCustomHashMap.this.value[this.index] == (Long)e.getValue();
        }

        public int hashCode() {
            return Object2LongLinkedOpenCustomHashMap.this.strategy.hashCode(Object2LongLinkedOpenCustomHashMap.this.key[this.index]) ^ HashCommon.long2int(Object2LongLinkedOpenCustomHashMap.this.value[this.index]);
        }

        public String toString() {
            return Object2LongLinkedOpenCustomHashMap.this.key[this.index] + "->" + Object2LongLinkedOpenCustomHashMap.this.value[this.index];
        }
    }
}

