/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import clover.it.unimi.dsi.fastutil.ints.IntCollection;
import clover.it.unimi.dsi.fastutil.ints.IntIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2IntMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2IntMap
implements Long2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractLong2IntMap() {
    }

    public void setDefRetValue(int rv) {
        this.defaultReturnValue(rv);
    }

    public int getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    public int defaultReturnValue() {
        return this.defRetValue;
    }

    public int put(long key, int value) {
        throw new UnsupportedOperationException();
    }

    public int remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? new Integer(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        int v = this.put(k, (Integer)ov);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        int v = this.remove(k);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(int v) {
        return ((IntCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2IntMap) {
            while (n-- != 0) {
                Long2IntMap.Entry e = (Long2IntMap.Entry)i.next();
                this.put(e.getLongKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2IntMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2IntMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2IntMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractLong2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2IntMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2IntMap.this.entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Long2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Long2IntMap.Entry first = (Long2IntMap.Entry)i.next();
            s.append(String.valueOf(first.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(first.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2IntMap.Entry {
        protected long key;
        protected int value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = (Integer)value;
        }

        public BasicEntry(long key, int value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Integer(this.setValue((Integer)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

