/*
 * Decompiled with CFR 0.152.
 */
package clover.edu.emory.mathcs.backport.java.util.concurrent;

import clover.edu.emory.mathcs.backport.java.util.AbstractQueue;
import clover.edu.emory.mathcs.backport.java.util.PriorityQueue;
import clover.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import clover.edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import clover.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import clover.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DelayQueue
extends AbstractQueue
implements BlockingQueue {
    private final transient Object lock = new Object();
    private final PriorityQueue q = new PriorityQueue();
    static final /* synthetic */ boolean $assertionsDisabled;

    public DelayQueue() {
    }

    public DelayQueue(Collection c) {
        this.addAll(c);
    }

    public boolean add(Object e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object e) {
        Object object = this.lock;
        synchronized (object) {
            Object first = this.q.peek();
            this.q.offer(e);
            if (first == null || ((Delayed)e).compareTo(first) < 0) {
                this.lock.notifyAll();
            }
            return true;
        }
    }

    public void put(Object e) {
        this.offer(e);
    }

    public boolean offer(Object e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object object = this.lock;
        synchronized (object) {
            Object first = this.q.peek();
            if (first == null || ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) > 0L) {
                return null;
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.lock.notifyAll();
            }
            return x;
        }
    }

    public Object take() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    this.lock.wait();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay <= 0L) break;
                TimeUnit.NANOSECONDS.timedWait(this.lock, delay);
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.lock.notifyAll();
            }
            return x;
        }
    }

    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                Object first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        return null;
                    }
                    TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                    nanos = deadline - Utils.nanoTime();
                    continue;
                }
                long delay = ((Delayed)first).getDelay(TimeUnit.NANOSECONDS);
                if (delay <= 0L) break;
                if (nanos <= 0L) {
                    return null;
                }
                if (delay > nanos) {
                    delay = nanos;
                }
                TimeUnit.NANOSECONDS.timedWait(this.lock, delay);
                nanos = deadline - Utils.nanoTime();
            }
            Object x = this.q.poll();
            if (!$assertionsDisabled && x == null) {
                throw new AssertionError();
            }
            if (this.q.size() != 0) {
                this.lock.notifyAll();
            }
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.q.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.q.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            Object first;
            int n = 0;
            while ((first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                c.add(this.q.poll());
                ++n;
            }
            if (n > 0) {
                this.lock.notifyAll();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            Object first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && ((Delayed)first).getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll());
            }
            if (n > 0) {
                this.lock.notifyAll();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.q.clear();
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.q.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.q.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.q.remove(o);
        }
    }

    public Iterator iterator() {
        return new Itr(this.toArray());
    }

    static {
        $assertionsDisabled = !DelayQueue.class.desiredAssertionStatus();
    }

    private class Itr
    implements Iterator {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public Object next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            Object object = DelayQueue.this.lock;
            synchronized (object) {
                Iterator it = DelayQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    return;
                }
            }
        }
    }
}

