/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.pdf.PdfException;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfStream;
import java.awt.color.ICC_Profile;

class PdfICCBased
extends PdfStream {
    protected int NumberOfComponents;

    PdfICCBased(ICC_Profile iCC_Profile) {
        try {
            this.NumberOfComponents = iCC_Profile.getNumComponents();
            PdfNumber pdfNumber = new PdfNumber(this.NumberOfComponents);
            switch (this.NumberOfComponents) {
                case 1: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICEGRAY);
                    break;
                }
                case 3: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICERGB);
                    break;
                }
                case 4: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICECMYK);
                    break;
                }
                default: {
                    throw new PdfException(this.NumberOfComponents + " component(s) is not supported in PDF1.4");
                }
            }
            this.put(PdfName.N, new PdfNumber(this.NumberOfComponents));
            this.bytes = iCC_Profile.getData();
            this.flateCompress();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

